/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.view.filter.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.ConditionVisitor;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.expr.Not;
import org.iplass.mtp.entity.query.condition.expr.Or;
import org.iplass.mtp.entity.query.condition.expr.Paren;
import org.iplass.mtp.entity.query.condition.predicate.Between;
import org.iplass.mtp.entity.query.condition.predicate.Contains;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.Greater;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.condition.predicate.IsNotNull;
import org.iplass.mtp.entity.query.condition.predicate.IsNull;
import org.iplass.mtp.entity.query.condition.predicate.Lesser;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.entity.query.condition.predicate.Like;
import org.iplass.mtp.entity.query.condition.predicate.NotEquals;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.view.filter.expression.UnsupportedFilterOperationException;

public class FilterValueExpressionChecker
implements ConditionVisitor {
    private static final String MSG_KEY = "view.filter.unsupportErr";

    public void execute(String expression) {
        try {
            Condition.newCondition(this.convCheckExpression(expression)).accept(this);
        }
        catch (QueryException e) {
            throw new UnsupportedFilterOperationException(FilterValueExpressionChecker.resourceString("view.filter.incorrectErr", new Object[0]), e);
        }
    }

    private String convCheckExpression(String expression) {
        StringBuilder sb = new StringBuilder();
        Matcher m = Pattern.compile("\\$\\d+").matcher(expression);
        int curIndex = 0;
        while (m.find()) {
            String numStr = expression.substring(m.start() + 1, m.end());
            int condNum = Integer.parseInt(numStr);
            if (curIndex < m.start()) {
                sb.append(expression.substring(curIndex, m.start()));
            }
            sb.append(condNum + "=" + condNum);
            curIndex = m.end();
        }
        if (curIndex < expression.length()) {
            sb.append(expression.substring(curIndex));
        }
        return sb.toString();
    }

    @Override
    public boolean visit(And and) {
        return true;
    }

    @Override
    public boolean visit(Paren paren) {
        return true;
    }

    @Override
    public boolean visit(Or or) {
        return true;
    }

    @Override
    public boolean visit(Equals equals) {
        String strVal1 = equals.getPropertyName();
        String strVal2 = equals.getValue().toString();
        try {
            int val1 = Integer.parseInt(strVal1);
            int val2 = Integer.parseInt(strVal2);
            if (val1 == val2) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new UnsupportedFilterOperationException(FilterValueExpressionChecker.resourceString(MSG_KEY, equals.toString()));
    }

    @Override
    public boolean visit(Not not) {
        return true;
    }

    @Override
    public boolean visit(Between between) {
        throw new UnsupportedFilterOperationException(FilterValueExpressionChecker.resourceString(MSG_KEY, between.toString()));
    }

    @Override
    public boolean visit(Greater greater) {
        throw new UnsupportedFilterOperationException(FilterValueExpressionChecker.resourceString(MSG_KEY, greater.toString()));
    }

    @Override
    public boolean visit(GreaterEqual greaterEqual) {
        throw new UnsupportedFilterOperationException(FilterValueExpressionChecker.resourceString(MSG_KEY, greaterEqual.toString()));
    }

    @Override
    public boolean visit(In in) {
        throw new UnsupportedFilterOperationException(FilterValueExpressionChecker.resourceString(MSG_KEY, in.toString()));
    }

    @Override
    public boolean visit(Lesser lesser) {
        throw new UnsupportedFilterOperationException(FilterValueExpressionChecker.resourceString(MSG_KEY, lesser.toString()));
    }

    @Override
    public boolean visit(LesserEqual lesserEqual) {
        throw new UnsupportedFilterOperationException(FilterValueExpressionChecker.resourceString(MSG_KEY, lesserEqual.toString()));
    }

    @Override
    public boolean visit(Like like) {
        throw new UnsupportedFilterOperationException(FilterValueExpressionChecker.resourceString(MSG_KEY, like.toString()));
    }

    @Override
    public boolean visit(NotEquals notEquals) {
        throw new UnsupportedFilterOperationException(FilterValueExpressionChecker.resourceString(MSG_KEY, notEquals.toString()));
    }

    @Override
    public boolean visit(IsNotNull isNotNull) {
        throw new UnsupportedFilterOperationException(FilterValueExpressionChecker.resourceString(MSG_KEY, isNotNull.toString()));
    }

    @Override
    public boolean visit(IsNull isNull) {
        throw new UnsupportedFilterOperationException(FilterValueExpressionChecker.resourceString(MSG_KEY, isNull.toString()));
    }

    @Override
    public boolean visit(Contains contains) {
        throw new UnsupportedFilterOperationException(FilterValueExpressionChecker.resourceString(MSG_KEY, contains.toString()));
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }
}

