/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.webhook.endpoint;

import org.iplass.mtp.webhook.endpoint.WebhookAuthenticationType;

public class WebhookEndpoint {
    private String url;
    private WebhookAuthenticationType headerAuthorizationType;
    private String headerAuthorizationContent;
    private String hmacKey;
    private String hmacHashHeader = null;
    private String headerAuthCustomTypeName = null;

    public WebhookEndpoint(String url) {
        this.url = url;
    }

    public WebhookEndpoint(String url, String hmacKey) {
        this.url = url;
        this.hmacKey = hmacKey;
    }

    public WebhookEndpoint(String url, WebhookAuthenticationType headerAuthorizationType, String headerAuthorizationContent) {
        this.url = url;
        this.headerAuthorizationType = headerAuthorizationType;
        this.headerAuthorizationContent = headerAuthorizationContent;
    }

    public WebhookEndpoint(String url, WebhookAuthenticationType headerAuthorizationType, String headerAuthorizationContent, String hmacKey) {
        this.url = url;
        this.headerAuthorizationType = headerAuthorizationType;
        this.headerAuthorizationContent = headerAuthorizationContent;
        this.hmacKey = hmacKey;
    }

    public void setBasicAuthorization(String userName, String password) {
        this.headerAuthorizationType = WebhookAuthenticationType.BASIC;
        this.headerAuthorizationContent = userName + ":" + password;
    }

    public void setBearerAuthorization(String bearerToken) {
        this.headerAuthorizationType = WebhookAuthenticationType.BEARER;
        this.headerAuthorizationContent = bearerToken;
    }

    public void setCustomAuthorization(String schemeName, String customToken) {
        this.headerAuthorizationType = WebhookAuthenticationType.CUSTOM;
        this.headerAuthorizationContent = customToken;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public WebhookAuthenticationType getHeaderAuthorizationType() {
        return this.headerAuthorizationType;
    }

    public void setHeaderAuthorizationType(WebhookAuthenticationType headerAuthorizationType) {
        this.headerAuthorizationType = headerAuthorizationType;
    }

    public String getHeaderAuthorizationContent() {
        return this.headerAuthorizationContent;
    }

    public void setHeaderAuthorizationContent(String headerAuthorizationContent) {
        this.headerAuthorizationContent = headerAuthorizationContent;
    }

    public String getHmacKey() {
        return this.hmacKey;
    }

    public void setHmacKey(String hmacKey) {
        this.hmacKey = hmacKey;
    }

    public String getHmacHashHeader() {
        return this.hmacHashHeader;
    }

    public void setHmacHashHeader(String hmacHashHeader) {
        this.hmacHashHeader = hmacHashHeader;
    }

    public String getHeaderAuthCustomTypeName() {
        return this.headerAuthCustomTypeName;
    }

    public void setHeaderAuthCustomTypeName(String headerAuthCustomTypeName) {
        this.headerAuthCustomTypeName = headerAuthCustomTypeName;
    }
}

