/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF_INDEX1" ON "OBJ_REF" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF_INDEX2" ON "OBJ_REF" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__1" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__1" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__1_INDEX1" ON "OBJ_REF__1" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__1_INDEX2" ON "OBJ_REF__1" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__2" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__2" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__2_INDEX1" ON "OBJ_REF__2" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__2_INDEX2" ON "OBJ_REF__2" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__3" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__3" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__3_INDEX1" ON "OBJ_REF__3" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__3_INDEX2" ON "OBJ_REF__3" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__4" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__4" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__4_INDEX1" ON "OBJ_REF__4" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__4_INDEX2" ON "OBJ_REF__4" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__5" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__5" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__5_INDEX1" ON "OBJ_REF__5" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__5_INDEX2" ON "OBJ_REF__5" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__6" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__6" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__6_INDEX1" ON "OBJ_REF__6" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__6_INDEX2" ON "OBJ_REF__6" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__7" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__7" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__7_INDEX1" ON "OBJ_REF__7" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__7_INDEX2" ON "OBJ_REF__7" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__8" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__8" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__8_INDEX1" ON "OBJ_REF__8" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__8_INDEX2" ON "OBJ_REF__8" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__9" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__9" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__9_INDEX1" ON "OBJ_REF__9" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__9_INDEX2" ON "OBJ_REF__9" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__10" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__10" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__10_INDEX1" ON "OBJ_REF__10" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__10_INDEX2" ON "OBJ_REF__10" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__11" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__11" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__11_INDEX1" ON "OBJ_REF__11" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__11_INDEX2" ON "OBJ_REF__11" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__12" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__12" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__12_INDEX1" ON "OBJ_REF__12" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__12_INDEX2" ON "OBJ_REF__12" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__13" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__13" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__13_INDEX1" ON "OBJ_REF__13" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__13_INDEX2" ON "OBJ_REF__13" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__14" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__14" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__14_INDEX1" ON "OBJ_REF__14" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__14_INDEX2" ON "OBJ_REF__14" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__15" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__15" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__15_INDEX1" ON "OBJ_REF__15" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__15_INDEX2" ON "OBJ_REF__15" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__16" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__16" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__16_INDEX1" ON "OBJ_REF__16" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__16_INDEX2" ON "OBJ_REF__16" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__17" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__17" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__17_INDEX1" ON "OBJ_REF__17" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__17_INDEX2" ON "OBJ_REF__17" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__18" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__18" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__18_INDEX1" ON "OBJ_REF__18" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__18_INDEX2" ON "OBJ_REF__18" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__19" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__19" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__19_INDEX1" ON "OBJ_REF__19" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__19_INDEX2" ON "OBJ_REF__19" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__20" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__20" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__20_INDEX1" ON "OBJ_REF__20" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__20_INDEX2" ON "OBJ_REF__20" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__21" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__21" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__21_INDEX1" ON "OBJ_REF__21" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__21_INDEX2" ON "OBJ_REF__21" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__22" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__22" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__22_INDEX1" ON "OBJ_REF__22" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__22_INDEX2" ON "OBJ_REF__22" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__23" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__23" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__23_INDEX1" ON "OBJ_REF__23" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__23_INDEX2" ON "OBJ_REF__23" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__24" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__24" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__24_INDEX1" ON "OBJ_REF__24" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__24_INDEX2" ON "OBJ_REF__24" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__25" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__25" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__25_INDEX1" ON "OBJ_REF__25" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__25_INDEX2" ON "OBJ_REF__25" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__26" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__26" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__26_INDEX1" ON "OBJ_REF__26" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__26_INDEX2" ON "OBJ_REF__26" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__27" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__27" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__27_INDEX1" ON "OBJ_REF__27" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__27_INDEX2" ON "OBJ_REF__27" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__28" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__28" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__28_INDEX1" ON "OBJ_REF__28" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__28_INDEX2" ON "OBJ_REF__28" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__29" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__29" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__29_INDEX1" ON "OBJ_REF__29" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__29_INDEX2" ON "OBJ_REF__29" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__30" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__30" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__30_INDEX1" ON "OBJ_REF__30" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__30_INDEX2" ON "OBJ_REF__30" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__31" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__31" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__31_INDEX1" ON "OBJ_REF__31" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__31_INDEX2" ON "OBJ_REF__31" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__32" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__32" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__32_INDEX1" ON "OBJ_REF__32" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__32_INDEX2" ON "OBJ_REF__32" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__33" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__33" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__33_INDEX1" ON "OBJ_REF__33" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__33_INDEX2" ON "OBJ_REF__33" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__34" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__34" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__34_INDEX1" ON "OBJ_REF__34" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__34_INDEX2" ON "OBJ_REF__34" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__35" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__35" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__35_INDEX1" ON "OBJ_REF__35" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__35_INDEX2" ON "OBJ_REF__35" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__36" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__36" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__36_INDEX1" ON "OBJ_REF__36" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__36_INDEX2" ON "OBJ_REF__36" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__37" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__37" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__37_INDEX1" ON "OBJ_REF__37" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__37_INDEX2" ON "OBJ_REF__37" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__38" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__38" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__38_INDEX1" ON "OBJ_REF__38" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__38_INDEX2" ON "OBJ_REF__38" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__39" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__39" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__39_INDEX1" ON "OBJ_REF__39" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__39_INDEX2" ON "OBJ_REF__39" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__40" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__40" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__40_INDEX1" ON "OBJ_REF__40" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__40_INDEX2" ON "OBJ_REF__40" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__41" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__41" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__41_INDEX1" ON "OBJ_REF__41" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__41_INDEX2" ON "OBJ_REF__41" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__42" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__42" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__42_INDEX1" ON "OBJ_REF__42" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__42_INDEX2" ON "OBJ_REF__42" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__43" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__43" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__43_INDEX1" ON "OBJ_REF__43" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__43_INDEX2" ON "OBJ_REF__43" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__44" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__44" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__44_INDEX1" ON "OBJ_REF__44" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__44_INDEX2" ON "OBJ_REF__44" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__45" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__45" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__45_INDEX1" ON "OBJ_REF__45" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__45_INDEX2" ON "OBJ_REF__45" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__46" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__46" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__46_INDEX1" ON "OBJ_REF__46" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__46_INDEX2" ON "OBJ_REF__46" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__47" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__47" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__47_INDEX1" ON "OBJ_REF__47" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__47_INDEX2" ON "OBJ_REF__47" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__48" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__48" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__48_INDEX1" ON "OBJ_REF__48" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__48_INDEX2" ON "OBJ_REF__48" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__49" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__49" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__49_INDEX1" ON "OBJ_REF__49" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__49_INDEX2" ON "OBJ_REF__49" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__50" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__50" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__50_INDEX1" ON "OBJ_REF__50" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__50_INDEX2" ON "OBJ_REF__50" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__51" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__51" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__51_INDEX1" ON "OBJ_REF__51" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__51_INDEX2" ON "OBJ_REF__51" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__52" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__52" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__52_INDEX1" ON "OBJ_REF__52" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__52_INDEX2" ON "OBJ_REF__52" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__53" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__53" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__53_INDEX1" ON "OBJ_REF__53" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__53_INDEX2" ON "OBJ_REF__53" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__54" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__54" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__54_INDEX1" ON "OBJ_REF__54" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__54_INDEX2" ON "OBJ_REF__54" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__55" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__55" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__55_INDEX1" ON "OBJ_REF__55" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__55_INDEX2" ON "OBJ_REF__55" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__56" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__56" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__56_INDEX1" ON "OBJ_REF__56" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__56_INDEX2" ON "OBJ_REF__56" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__57" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__57" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__57_INDEX1" ON "OBJ_REF__57" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__57_INDEX2" ON "OBJ_REF__57" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__58" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__58" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__58_INDEX1" ON "OBJ_REF__58" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__58_INDEX2" ON "OBJ_REF__58" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__59" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__59" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__59_INDEX1" ON "OBJ_REF__59" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__59_INDEX2" ON "OBJ_REF__59" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__60" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__60" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__60_INDEX1" ON "OBJ_REF__60" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__60_INDEX2" ON "OBJ_REF__60" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__61" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__61" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__61_INDEX1" ON "OBJ_REF__61" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__61_INDEX2" ON "OBJ_REF__61" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__62" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__62" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__62_INDEX1" ON "OBJ_REF__62" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__62_INDEX2" ON "OBJ_REF__62" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__63" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__63" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__63_INDEX1" ON "OBJ_REF__63" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__63_INDEX2" ON "OBJ_REF__63" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__64" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__64" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__64_INDEX1" ON "OBJ_REF__64" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__64_INDEX2" ON "OBJ_REF__64" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__65" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__65" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__65_INDEX1" ON "OBJ_REF__65" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__65_INDEX2" ON "OBJ_REF__65" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__66" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__66" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__66_INDEX1" ON "OBJ_REF__66" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__66_INDEX2" ON "OBJ_REF__66" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__67" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__67" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__67_INDEX1" ON "OBJ_REF__67" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__67_INDEX2" ON "OBJ_REF__67" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__68" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__68" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__68_INDEX1" ON "OBJ_REF__68" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__68_INDEX2" ON "OBJ_REF__68" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__69" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__69" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__69_INDEX1" ON "OBJ_REF__69" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__69_INDEX2" ON "OBJ_REF__69" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__70" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__70" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__70_INDEX1" ON "OBJ_REF__70" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__70_INDEX2" ON "OBJ_REF__70" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__71" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__71" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__71_INDEX1" ON "OBJ_REF__71" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__71_INDEX2" ON "OBJ_REF__71" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__72" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__72" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__72_INDEX1" ON "OBJ_REF__72" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__72_INDEX2" ON "OBJ_REF__72" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__73" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__73" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__73_INDEX1" ON "OBJ_REF__73" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__73_INDEX2" ON "OBJ_REF__73" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__74" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__74" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__74_INDEX1" ON "OBJ_REF__74" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__74_INDEX2" ON "OBJ_REF__74" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__75" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__75" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__75_INDEX1" ON "OBJ_REF__75" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__75_INDEX2" ON "OBJ_REF__75" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__76" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__76" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__76_INDEX1" ON "OBJ_REF__76" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__76_INDEX2" ON "OBJ_REF__76" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__77" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__77" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__77_INDEX1" ON "OBJ_REF__77" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__77_INDEX2" ON "OBJ_REF__77" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__78" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__78" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__78_INDEX1" ON "OBJ_REF__78" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__78_INDEX2" ON "OBJ_REF__78" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__79" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__79" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__79_INDEX1" ON "OBJ_REF__79" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__79_INDEX2" ON "OBJ_REF__79" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__80" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__80" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__80_INDEX1" ON "OBJ_REF__80" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__80_INDEX2" ON "OBJ_REF__80" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__81" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__81" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__81_INDEX1" ON "OBJ_REF__81" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__81_INDEX2" ON "OBJ_REF__81" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__82" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__82" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__82_INDEX1" ON "OBJ_REF__82" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__82_INDEX2" ON "OBJ_REF__82" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__83" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__83" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__83_INDEX1" ON "OBJ_REF__83" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__83_INDEX2" ON "OBJ_REF__83" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__84" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__84" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__84_INDEX1" ON "OBJ_REF__84" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__84_INDEX2" ON "OBJ_REF__84" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__85" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__85" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__85_INDEX1" ON "OBJ_REF__85" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__85_INDEX2" ON "OBJ_REF__85" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__86" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__86" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__86_INDEX1" ON "OBJ_REF__86" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__86_INDEX2" ON "OBJ_REF__86" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__87" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__87" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__87_INDEX1" ON "OBJ_REF__87" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__87_INDEX2" ON "OBJ_REF__87" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__88" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__88" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__88_INDEX1" ON "OBJ_REF__88" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__88_INDEX2" ON "OBJ_REF__88" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__89" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__89" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__89_INDEX1" ON "OBJ_REF__89" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__89_INDEX2" ON "OBJ_REF__89" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__90" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__90" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__90_INDEX1" ON "OBJ_REF__90" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__90_INDEX2" ON "OBJ_REF__90" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__91" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__91" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__91_INDEX1" ON "OBJ_REF__91" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__91_INDEX2" ON "OBJ_REF__91" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__92" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__92" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__92_INDEX1" ON "OBJ_REF__92" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__92_INDEX2" ON "OBJ_REF__92" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__93" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__93" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__93_INDEX1" ON "OBJ_REF__93" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__93_INDEX2" ON "OBJ_REF__93" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__94" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__94" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__94_INDEX1" ON "OBJ_REF__94" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__94_INDEX2" ON "OBJ_REF__94" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__95" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__95" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__95_INDEX1" ON "OBJ_REF__95" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__95_INDEX2" ON "OBJ_REF__95" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__96" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__96" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__96_INDEX1" ON "OBJ_REF__96" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__96_INDEX2" ON "OBJ_REF__96" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__97" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__97" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__97_INDEX1" ON "OBJ_REF__97" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__97_INDEX2" ON "OBJ_REF__97" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__98" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__98" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__98_INDEX1" ON "OBJ_REF__98" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__98_INDEX2" ON "OBJ_REF__98" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__99" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__99" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__99_INDEX1" ON "OBJ_REF__99" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__99_INDEX2" ON "OBJ_REF__99" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__100" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__100" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__100_INDEX1" ON "OBJ_REF__100" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__100_INDEX2" ON "OBJ_REF__100" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__101" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__101" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__101_INDEX1" ON "OBJ_REF__101" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__101_INDEX2" ON "OBJ_REF__101" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__102" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__102" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__102_INDEX1" ON "OBJ_REF__102" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__102_INDEX2" ON "OBJ_REF__102" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__103" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__103" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__103_INDEX1" ON "OBJ_REF__103" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__103_INDEX2" ON "OBJ_REF__103" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__104" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__104" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__104_INDEX1" ON "OBJ_REF__104" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__104_INDEX2" ON "OBJ_REF__104" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__105" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__105" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__105_INDEX1" ON "OBJ_REF__105" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__105_INDEX2" ON "OBJ_REF__105" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__106" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__106" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__106_INDEX1" ON "OBJ_REF__106" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__106_INDEX2" ON "OBJ_REF__106" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__107" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__107" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__107_INDEX1" ON "OBJ_REF__107" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__107_INDEX2" ON "OBJ_REF__107" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__108" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__108" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__108_INDEX1" ON "OBJ_REF__108" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__108_INDEX2" ON "OBJ_REF__108" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__109" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__109" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__109_INDEX1" ON "OBJ_REF__109" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__109_INDEX2" ON "OBJ_REF__109" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__110" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__110" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__110_INDEX1" ON "OBJ_REF__110" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__110_INDEX2" ON "OBJ_REF__110" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__111" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__111" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__111_INDEX1" ON "OBJ_REF__111" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__111_INDEX2" ON "OBJ_REF__111" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__112" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__112" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__112_INDEX1" ON "OBJ_REF__112" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__112_INDEX2" ON "OBJ_REF__112" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__113" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__113" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__113_INDEX1" ON "OBJ_REF__113" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__113_INDEX2" ON "OBJ_REF__113" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__114" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__114" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__114_INDEX1" ON "OBJ_REF__114" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__114_INDEX2" ON "OBJ_REF__114" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__115" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__115" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__115_INDEX1" ON "OBJ_REF__115" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__115_INDEX2" ON "OBJ_REF__115" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__116" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__116" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__116_INDEX1" ON "OBJ_REF__116" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__116_INDEX2" ON "OBJ_REF__116" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__117" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__117" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__117_INDEX1" ON "OBJ_REF__117" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__117_INDEX2" ON "OBJ_REF__117" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__118" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__118" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__118_INDEX1" ON "OBJ_REF__118" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__118_INDEX2" ON "OBJ_REF__118" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__119" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__119" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__119_INDEX1" ON "OBJ_REF__119" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__119_INDEX2" ON "OBJ_REF__119" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__120" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__120" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__120_INDEX1" ON "OBJ_REF__120" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__120_INDEX2" ON "OBJ_REF__120" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__121" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__121" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__121_INDEX1" ON "OBJ_REF__121" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__121_INDEX2" ON "OBJ_REF__121" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__122" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__122" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__122_INDEX1" ON "OBJ_REF__122" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__122_INDEX2" ON "OBJ_REF__122" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__123" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__123" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__123_INDEX1" ON "OBJ_REF__123" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__123_INDEX2" ON "OBJ_REF__123" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__124" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__124" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__124_INDEX1" ON "OBJ_REF__124" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__124_INDEX2" ON "OBJ_REF__124" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__125" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__125" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__125_INDEX1" ON "OBJ_REF__125" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__125_INDEX2" ON "OBJ_REF__125" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__126" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__126" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__126_INDEX1" ON "OBJ_REF__126" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__126_INDEX2" ON "OBJ_REF__126" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__127" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__127" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__127_INDEX1" ON "OBJ_REF__127" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__127_INDEX2" ON "OBJ_REF__127" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__MTP" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__MTP" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__MTP_INDEX1" ON "OBJ_REF__MTP" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__MTP_INDEX2" ON "OBJ_REF__MTP" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

/* drop/create OBJ_REF */
DROP TABLE "OBJ_REF__USER" CASCADE CONSTRAINT;

CREATE TABLE "OBJ_REF__USER" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "REF_DEF_ID" VARCHAR2(128) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL, 
    "OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL,
    "TARGET_OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "TARGET_OBJ_ID" VARCHAR2(64) NOT NULL,
    "TARGET_OBJ_VER" NUMBER(10,0) DEFAULT 0 NOT NULL
)
;

CREATE INDEX "OBJ_REF__USER_INDEX1" ON "OBJ_REF__USER" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID", "REF_DEF_ID") ;
CREATE INDEX "OBJ_REF__USER_INDEX2" ON "OBJ_REF__USER" ("TENANT_ID", "TARGET_OBJ_DEF_ID", "TARGET_OBJ_ID", "REF_DEF_ID") ;

