use mtdb
GO

DROP TABLE T_TENANT
GO

DROP SEQUENCE SEQ_T_TENANT_ID
GO

CREATE SEQUENCE SEQ_T_TENANT_ID MINVALUE 1 MAXVALUE 9999999 INCREMENT BY 1 START WITH 1 NO CACHE NO CYCLE
GO

CREATE TABLE T_TENANT
(
    ID NUMERIC(7,0) NOT NULL DEFAULT NEXT VALUE FOR SEQ_T_TENANT_ID,
    NAME NVARCHAR(256) NOT NULL,
    DESCRIPTION NVARCHAR(4000),
    HOST_NAME VARCHAR(256),
    URL NVARCHAR(256) NOT NULL,
    YUKO_DATE_FROM DATE NOT NULL,
    YUKO_DATE_TO DATE NOT NULL,
    CRE_USER VARCHAR(64),
    CRE_DATE DATETIME2(3),
    UP_USER VARCHAR(64),
    UP_DATE DATETIME2(3),
    CONSTRAINT T_TENANT_PK PRIMARY KEY (URL)
)
GO

CREATE INDEX T_TENANT_INDEX1 ON T_TENANT (ID)
GO
