/*
 * Copyright (C) 2020 DENTSU SOKEN INC. All Rights Reserved.
 *
 * Unless you have purchased a commercial license,
 * the following license terms apply:
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package org.iplass.mtp.impl.entity.interceptor;

import java.util.function.Predicate;

import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.interceptor.EntityGetRecycleBinInvocation;
import org.iplass.mtp.entity.interceptor.EntityInterceptor;
import org.iplass.mtp.entity.interceptor.InvocationType;
import org.iplass.mtp.impl.entity.EntityHandler;

public class EntityGetRecycleBinInvocationImpl extends EntityInvocationImpl<Void> implements EntityGetRecycleBinInvocation {

	private Long recycleBinId;
	private Predicate<Entity> callback;

	public EntityGetRecycleBinInvocationImpl(Predicate<Entity> callback, Long recycleBinId,
			EntityInterceptor[] entityInterceptors,
			EntityHandler entityHandler) {
		super(entityInterceptors, entityHandler);
		this.callback = callback;
		this.recycleBinId = recycleBinId;
	}

	public InvocationType getType() {
		return InvocationType.GET_RECYCLE_BIN;
	}

	@Override
	public Predicate<Entity> getCallback() {
		return callback;
	}

	@Override
	public void setCallback(Predicate<Entity> callback) {
		this.callback = callback;
	}

	@Override
	public Long getRecycleBinId() {
		return recycleBinId;
	}

	@Override
	public void setRecycleBinId(Long recycleBinId) {
		this.recycleBinId = recycleBinId;
	}

	@Override
	protected Void callEntityHandler(EntityHandler eh) {
		eh.getRecycleBin(callback, recycleBinId);
		return null;
	}


}
