/*
 * Copyright (C) 2017 DENTSU SOKEN INC. All Rights Reserved.
 * 
 * Unless you have purchased a commercial license,
 * the following license terms apply:
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */
package org.iplass.mtp.auth.policy;

import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.LoginFailedException;
import org.iplass.mtp.auth.policy.definition.NotificationType;

public class LoginNotification extends AccountNotification {
	private Credential credential;
	private LoginFailedException exception;
	
	public LoginNotification(NotificationType type, String userOid, Credential credential, LoginFailedException exception) {
		super(type, userOid);
		this.credential = credential;
		this.exception = exception;
	}

	public Credential getCredential() {
		return credential;
	}

	public LoginFailedException getException() {
		return exception;
	}

}
