/*
 * Copyright (C) 2014 DENTSU SOKEN INC. All Rights Reserved.
 * 
 * Unless you have purchased a commercial license,
 * the following license terms apply:
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package org.iplass.mtp.auth.policy;

import org.iplass.mtp.auth.policy.definition.NotificationType;

public class PasswordNotification extends AccountNotification {
	private String password;
	private boolean passwordAutoGenerated;
	
	public PasswordNotification(NotificationType type, String userOid, String password, boolean passwordAutoGenerated) {
		super(type, userOid);
		this.password = password;
		this.passwordAutoGenerated = passwordAutoGenerated;
	}
	
	/**
	 * アカウント作成時、パスワードリセット時のパスワード
	 * 
	 * @return
	 */
	public String getPassword() {
		return password;
	}
	/**
	 * アカウント作成時、パスワードリセット時のパスワードが自動生成されたものである場合true
	 * 
	 * @return
	 */
	public boolean isPasswordAutoGenerated() {
		return passwordAutoGenerated;
	}
	

}
