/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.command;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import org.iplass.mtp.command.IllegalParameterException;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.command.UploadFileHandle;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;

public interface RequestContext {
    public String getParam(String var1);

    public String[] getParams(String var1);

    default public <T> T getParam(String name, Class<T> type) {
        return this.getParam(name, type, null);
    }

    default public <T> T getParam(String name, Class<T> type, T defaultValue) {
        UploadFileHandle ret;
        if (type == UploadFileHandle.class) {
            ret = this.getParamAsFile(name);
        } else {
            try {
                ret = ConvertUtil.convert(type, this.getParam(name));
            }
            catch (RuntimeException e) {
                throw new IllegalParameterException(RequestContext.resourceString("command.RequestContextWrapper.canNotConv", name), e);
            }
        }
        if (ret == null) {
            return defaultValue;
        }
        return (T)ret;
    }

    default public <T> T[] getParams(String name, Class<T> type) {
        return this.getParams(name, type, null);
    }

    default public <T> T[] getParams(String name, Class<T> type, T[] defaultValues) {
        Object[] ret;
        if (type == UploadFileHandle.class) {
            ret = this.getParamsAsFile(name);
        } else {
            String[] vals = this.getParams(name);
            if (vals == null) {
                ret = null;
            } else if (type == String.class) {
                ret = vals;
            } else {
                try {
                    ret = (Object[])Array.newInstance(type, vals.length);
                    for (int i = 0; i < vals.length; ++i) {
                        ret[i] = ConvertUtil.convert(type, vals[i]);
                    }
                }
                catch (RuntimeException e) {
                    throw new IllegalParameterException(RequestContext.resourceString("command.RequestContextWrapper.canNotConv", name), e);
                }
            }
        }
        if (ret == null) {
            return defaultValues;
        }
        return ret;
    }

    default public Boolean getParamAsBoolean(String name) {
        return this.getParam(name, Boolean.class);
    }

    default public Boolean[] getParamsAsBoolean(String name) {
        return this.getParams(name, Boolean.class);
    }

    default public Long getParamAsLong(String name) {
        return this.getParam(name, Long.class);
    }

    default public Long[] getParamsAsLong(String name) {
        return this.getParams(name, Long.class);
    }

    default public Integer getParamAsInt(String name) {
        return this.getParam(name, Integer.class);
    }

    default public Integer[] getParamsAsInt(String name) {
        return this.getParams(name, Integer.class);
    }

    default public Double getParamAsDouble(String name) {
        return this.getParam(name, Double.class);
    }

    default public Double[] getParamsAsDouble(String name) {
        return this.getParams(name, Double.class);
    }

    default public Date getParamAsDate(String name, String format) {
        try {
            return ConvertUtil.convertToDate(Date.class, this.getParam(name), format, false);
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(RequestContext.resourceString("command.RequestContextWrapper.canNotConv", name), e);
        }
    }

    default public Date[] getParamsAsDate(String name, String format) {
        String[] vals = this.getParams(name);
        if (vals == null) {
            return null;
        }
        if (vals.getClass().getComponentType() == Date.class) {
            return (Date[])vals;
        }
        try {
            Date[] ret = new Date[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                ret[i] = ConvertUtil.convertToDate(Date.class, vals[i], format, false);
            }
            return ret;
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(RequestContext.resourceString("command.RequestContextWrapper.canNotConv", name), e);
        }
    }

    default public Timestamp getParamAsTimestamp(String name, String format) {
        try {
            return ConvertUtil.convertToDate(Timestamp.class, this.getParam(name), format, true);
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(RequestContext.resourceString("command.RequestContextWrapper.canNotConv", name), e);
        }
    }

    default public Timestamp[] getParamsAsTimestamp(String name, String format) {
        String[] vals = this.getParams(name);
        if (vals == null) {
            return null;
        }
        if (vals.getClass().getComponentType() == Timestamp.class) {
            return (Timestamp[])vals;
        }
        try {
            Timestamp[] ret = new Timestamp[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                ret[i] = ConvertUtil.convertToDate(Timestamp.class, vals[i], format, true);
            }
            return ret;
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(RequestContext.resourceString("command.RequestContextWrapper.canNotConv", name), e);
        }
    }

    default public Time getParamAsTime(String name, String format) {
        try {
            return ConvertUtil.convertToDate(Time.class, this.getParam(name), format, false);
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(RequestContext.resourceString("command.RequestContextWrapper.canNotConv", name), e);
        }
    }

    default public Time[] getParamsAsTime(String name, String format) {
        String[] vals = this.getParams(name);
        if (vals == null) {
            return null;
        }
        if (vals.getClass().getComponentType() == Time.class) {
            return (Time[])vals;
        }
        try {
            Time[] ret = new Time[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                ret[i] = ConvertUtil.convertToDate(Time.class, vals[i], format, false);
            }
            return ret;
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(RequestContext.resourceString("command.RequestContextWrapper.canNotConv", name), e);
        }
    }

    default public BigDecimal getParamAsBigDecimal(String name) {
        return this.getParam(name, BigDecimal.class);
    }

    default public BigDecimal[] getParamsAsBigDecimal(String name) {
        return this.getParams(name, BigDecimal.class);
    }

    public UploadFileHandle getParamAsFile(String var1);

    public UploadFileHandle[] getParamsAsFile(String var1);

    public Map<String, Object> getParamMap();

    public Iterator<String> getParamNames();

    public Object getAttribute(String var1);

    public void setAttribute(String var1, Object var2);

    public void removeAttribute(String var1);

    public Iterator<String> getAttributeNames();

    public SessionContext getSession();

    public SessionContext getSession(boolean var1);

    public static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }
}

