/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.command;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.command.UploadFileHandle;
import org.iplass.mtp.entity.BinaryReference;

public class RequestContextWrapper
implements RequestContext {
    private static final Object TOMB = new Object();
    private RequestContext context;
    private SessionContext session;
    private Map<String, Object> paramMap;
    private Map<String, Object> attribteMap;
    private Mode mode;

    public RequestContextWrapper(RequestContext context, Mode mode) {
        this.mode = mode;
        this.paramMap = new HashMap<String, Object>();
        switch (mode.ordinal()) {
            case 0: {
                if (context == null) {
                    throw new IllegalArgumentException("if mode is SHARED, specify non null RequestContext");
                }
                this.context = context;
                break;
            }
            case 1: {
                this.attribteMap = new HashMap<String, Object>();
                this.paramMap.putAll(context.getParamMap());
                Iterator<String> names = context.getAttributeNames();
                while (names.hasNext()) {
                    String name = names.next();
                    this.attribteMap.put(name, context.getAttribute(name));
                }
                this.session = context.getSession(false);
                break;
            }
        }
    }

    public RequestContextWrapper(RequestContext context) {
        this(context, Mode.COPY);
    }

    public Mode getMode() {
        return this.mode;
    }

    public RequestContext getWrapped() {
        return this.context;
    }

    public void setParam(String key, String value) {
        if (value == null) {
            if (this.mode == Mode.SHARED) {
                this.paramMap.put(key, TOMB);
            } else {
                this.paramMap.remove(key);
            }
        } else {
            this.paramMap.put(key, new String[]{value});
        }
    }

    public void setParams(String key, String[] value) {
        if (value == null) {
            if (this.mode == Mode.SHARED) {
                this.paramMap.put(key, TOMB);
            } else {
                this.paramMap.remove(key);
            }
        } else {
            this.paramMap.put(key, value);
        }
    }

    @Override
    public String getParam(String name) {
        Object val = this.paramMap.get(name);
        if (val == null) {
            if (this.mode == Mode.COPY) {
                return null;
            }
            return this.context.getParam(name);
        }
        if (val == TOMB) {
            return null;
        }
        if (val instanceof String[]) {
            return ((String[])val)[0];
        }
        return val.toString();
    }

    @Override
    public String[] getParams(String name) {
        Object val = this.paramMap.get(name);
        if (val == null) {
            if (this.mode == Mode.COPY) {
                return null;
            }
            return this.context.getParams(name);
        }
        if (val == TOMB) {
            return null;
        }
        return (String[])val;
    }

    @Override
    public UploadFileHandle getParamAsFile(String name) {
        Object val = this.paramMap.get(name);
        if (val == null) {
            if (this.mode == Mode.COPY) {
                return null;
            }
            return this.context.getParamAsFile(name);
        }
        if (val == TOMB) {
            return null;
        }
        if (val instanceof UploadFileHandle[]) {
            return ((UploadFileHandle[])val)[0];
        }
        return (UploadFileHandle)val;
    }

    @Override
    public UploadFileHandle[] getParamsAsFile(String name) {
        Object val = this.paramMap.get(name);
        if (val == null) {
            if (this.mode == Mode.COPY) {
                return null;
            }
            return this.context.getParamsAsFile(name);
        }
        if (val == TOMB) {
            return null;
        }
        return (UploadFileHandle[])val;
    }

    @Override
    public Map<String, Object> getParamMap() {
        if (this.paramMap.size() > 0) {
            if (this.mode == Mode.COPY) {
                return this.paramMap;
            }
            HashMap<String, Object> ret = new HashMap<String, Object>(this.context.getParamMap());
            for (Map.Entry<String, Object> e : this.paramMap.entrySet()) {
                if (e.getValue() == TOMB) {
                    ret.remove(e.getKey());
                    continue;
                }
                ret.put(e.getKey(), e.getValue());
            }
            return ret;
        }
        if (this.mode == Mode.COPY) {
            return Collections.emptyMap();
        }
        return this.context.getParamMap();
    }

    @Override
    public Iterator<String> getParamNames() {
        if (this.paramMap.size() > 0) {
            if (this.mode == Mode.COPY) {
                return this.paramMap.keySet().iterator();
            }
            HashSet<String> ret = new HashSet<String>();
            Iterator<String> it = this.context.getParamNames();
            while (it.hasNext()) {
                ret.add(it.next());
            }
            for (Map.Entry<String, Object> e : this.paramMap.entrySet()) {
                if (e.getValue() == TOMB) {
                    ret.remove(e.getKey());
                    continue;
                }
                ret.add(e.getKey());
            }
            return ret.iterator();
        }
        if (this.mode == Mode.COPY) {
            return Collections.emptySet().iterator();
        }
        return this.context.getParamNames();
    }

    @Override
    public Object getAttribute(String name) {
        if (this.mode == Mode.COPY) {
            return this.attribteMap.get(name);
        }
        return this.context.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.mode == Mode.COPY) {
            if (value == null) {
                this.attribteMap.remove(name);
            } else {
                this.attribteMap.put(name, value);
            }
        } else {
            this.context.setAttribute(name, value);
        }
    }

    @Override
    public void removeAttribute(String name) {
        if (this.mode == Mode.COPY) {
            this.attribteMap.remove(name);
        } else {
            this.context.removeAttribute(name);
        }
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.mode == Mode.SHARED) {
            return this.context.getAttributeNames();
        }
        return this.attribteMap.keySet().iterator();
    }

    @Override
    public SessionContext getSession() {
        return this.getSession(true);
    }

    @Override
    public SessionContext getSession(boolean create) {
        if (this.mode == Mode.SHARED) {
            return this.context.getSession(create);
        }
        if (this.context != null) {
            return this.context.getSession(create);
        }
        if (create && this.session == null) {
            this.session = new SessionContext(this){
                private Map<String, Object> map = new HashMap<String, Object>();

                @Override
                public void setAttribute(String name, Object value) {
                    this.map.put(name, value);
                }

                @Override
                public void removeAttribute(String name) {
                    this.map.remove(name);
                }

                @Override
                public Iterator<String> getAttributeNames() {
                    return this.map.keySet().iterator();
                }

                @Override
                public Object getAttribute(String name) {
                    return this.map.get(name);
                }

                @Override
                public BinaryReference loadFromTemporary(long lobId) {
                    return null;
                }
            };
        }
        return this.session;
    }

    public static enum Mode {
        SHARED,
        COPY;

    }
}

