/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.command.beanmapper;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.LinkedList;
import java.util.List;
import org.iplass.mtp.impl.command.beanmapper.jackson.MappingErrorSerializer;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="mappingError", propOrder={"propertyPath", "errorMessages"})
@JsonSerialize(using=MappingErrorSerializer.class)
public class MappingError {
    @XmlElement
    private String propertyPath;
    @XmlElementWrapper(name="errorMessages")
    @XmlElement(name="message")
    private List<String> errorMessages;
    @XmlTransient
    private Object errorValue;
    @XmlTransient
    private Object cause;

    public MappingError(String propertyPath, Object errorValue) {
        this.propertyPath = propertyPath;
        this.errorValue = errorValue;
    }

    public MappingError(String propertyPath, List<String> errorMessages, Object errorValue, Object cause) {
        this.propertyPath = propertyPath;
        this.errorMessages = errorMessages;
        this.errorValue = errorValue;
        this.cause = cause;
    }

    public MappingError(String propertyPath, String errorMessage, Object errorValue, Object cause) {
        this.propertyPath = propertyPath;
        this.errorMessages = new LinkedList<String>();
        this.errorMessages.add(errorMessage);
        this.errorValue = errorValue;
        this.cause = cause;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public void setPropertyPath(String propertyPath) {
        this.propertyPath = propertyPath;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void setErrorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public Object getErrorValue() {
        return this.errorValue;
    }

    public void setErrorValue(Object errorValue) {
        this.errorValue = errorValue;
    }

    public Object getCause() {
        return this.cause;
    }

    public void setCause(Object cause) {
        this.cause = cause;
    }

    public void addMessage(String message) {
        this.addMessage(message, null);
    }

    public void addMessage(String message, Object cause) {
        if (this.errorMessages == null) {
            this.errorMessages = new LinkedList<String>();
        }
        this.errorMessages.add(message);
        if (cause != null) {
            if (this.cause == null) {
                this.cause = cause;
            } else if (this.cause instanceof List) {
                ((List)this.cause).add(cause);
            } else {
                LinkedList<Object> causes = new LinkedList<Object>();
                causes.add(this.cause);
                causes.add(cause);
                this.cause = causes;
            }
        }
    }
}

