/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.command.beanmapper;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.command.beanmapper.MappingError;
import org.iplass.mtp.impl.command.beanmapper.jackson.MappingResultSerializer;

@XmlSeeAlso(value={MappingError.class})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonSerialize(using=MappingResultSerializer.class)
public class MappingResult {
    @XmlTransient
    private Object bean;
    @XmlTransient
    private Map<String, MappingError> errorMap;
    @XmlTransient
    private List<MappingError> errorList;

    public MappingResult() {
    }

    public MappingResult(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    @XmlElement
    public List<MappingError> getErrors() {
        if (this.errorList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.errorList);
    }

    public MappingError getError(String propertyPath) {
        if (this.errorMap == null) {
            return null;
        }
        return this.errorMap.get(propertyPath);
    }

    public void addError(MappingError error) {
        MappingError old;
        if (this.errorMap == null) {
            this.errorMap = new HashMap<String, MappingError>();
            this.errorList = new LinkedList<MappingError>();
        }
        if ((old = this.errorMap.put(error.getPropertyPath(), error)) != null) {
            this.errorList.remove(old);
        }
        this.errorList.add(error);
    }

    public MappingError removeError(String propertyPath) {
        if (this.errorMap == null) {
            return null;
        }
        MappingError err = this.errorMap.remove(propertyPath);
        if (err != null) {
            this.errorList.remove(err);
        }
        return err;
    }

    public boolean hasError() {
        return this.errorMap != null && this.errorMap.size() != 0;
    }

    public void addErrors(List<MappingError> errors) {
        for (MappingError me : errors) {
            Object addCause;
            MappingError pre = this.getError(me.getPropertyPath());
            if (pre == null) {
                this.addError(me);
                continue;
            }
            for (String msg : me.getErrorMessages()) {
                pre.addMessage(msg);
            }
            if (me.getCause() == null) continue;
            LinkedList<Object> merged = new LinkedList<Object>();
            Object preCause = pre.getCause();
            if (preCause instanceof List) {
                for (Object o : (List)preCause) {
                    merged.add(o);
                }
            } else if (preCause != null) {
                merged.add(preCause);
            }
            if ((addCause = me.getCause()) instanceof List) {
                for (Object o : (List)addCause) {
                    merged.add(o);
                }
            } else if (addCause != null) {
                merged.add(addCause);
            }
            if (merged.size() == 1) {
                pre.setCause(merged.get(0));
                continue;
            }
            pre.setCause(merged);
        }
    }
}

