/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.definition.binary;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.iplass.mtp.definition.binary.ArchiveBinaryDefinition;
import org.iplass.mtp.definition.binary.FileBinaryDefinition;

public class FileArchiveBinaryDefinition
extends FileBinaryDefinition
implements ArchiveBinaryDefinition {
    private static final long serialVersionUID = -4391803442328436515L;

    public FileArchiveBinaryDefinition() {
    }

    public FileArchiveBinaryDefinition(String name, Path file) {
        super(name, file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getEntryAsStream(String path) {
        try (ZipFile zip = new ZipFile(this.file.toFile());){
            ZipEntry e = zip.getEntry(path);
            if (e == null) {
                InputStream inputStream = null;
                return inputStream;
            }
            ZipInputStreamPerZipFile zipInputStreamPerZipFile = new ZipInputStreamPerZipFile(zip.getInputStream(e), zip);
            return zipInputStreamPerZipFile;
        }
        catch (IOException e2) {
            throw new IllegalStateException("can't open/read file:" + String.valueOf(this.file), e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getEntrySize(String path) {
        try (ZipFile zip = new ZipFile(this.file.toFile());){
            ZipEntry e = zip.getEntry(path);
            if (e == null) {
                long l = -1L;
                return l;
            }
            long l = e.getSize();
            return l;
        }
        catch (IOException e2) {
            throw new IllegalStateException("can't open/read file:" + String.valueOf(this.file), e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasEntry(String path) {
        try (ZipFile zip = new ZipFile(this.file.toFile());){
            ZipEntry e = zip.getEntry(path);
            if (e == null) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new IllegalStateException("can't open/read file:" + String.valueOf(this.file), e);
        }
    }

    private static class ZipInputStreamPerZipFile
    extends FilterInputStream {
        private ZipFile zip;

        protected ZipInputStreamPerZipFile(InputStream in, ZipFile zip) {
            super(in);
            this.zip = zip;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.zip.close();
            }
        }
    }
}

