/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.TargetVersion;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.l10n.MetaEachPropertyDataLocalizationStrategy;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.properties.extend.ExpressionType;

public class UpdateOption {
    private List<String> updateProperties;
    private boolean checkTimestamp = true;
    private TargetVersion targetVersion = TargetVersion.CURRENT_VALID;
    private boolean purgeCompositionedEntity = true;
    private boolean forceUpdate = false;
    private boolean checkLockedByUser = true;
    private boolean withValidation = true;
    private boolean notifyListeners = true;
    private boolean localized = false;

    public static UpdateOption allPropertyUpdateOption(String defName, boolean checkTimestamp) {
        return UpdateOption.allPropertyUpdateOption(defName, checkTimestamp, TargetVersion.CURRENT_VALID);
    }

    public static UpdateOption allPropertyUpdateOption(String defName, boolean checkTimestamp, TargetVersion targetVersion) {
        EntityDefinition def = ManagerLocator.getInstance().getManager(EntityDefinitionManager.class).get(defName);
        if (def == null) {
            throw new EntityRuntimeException(defName + " not defined.");
        }
        List<PropertyDefinition> props = def.getPropertyList();
        ArrayList<String> updateProps = new ArrayList<String>();
        if (props != null) {
            for (PropertyDefinition pd : props) {
                if (pd instanceof ExpressionProperty || !pd.isUpdatable() || pd.getName().equals("updateBy") || def.getVersionControlType() != VersionControlType.NONE && (pd.getIndexType() == IndexType.UNIQUE || pd.getIndexType() == IndexType.UNIQUE_WITHOUT_NULL) || pd instanceof ReferenceProperty && ((ReferenceProperty)pd).getMappedBy() != null) continue;
                updateProps.add(pd.getName());
            }
        }
        UpdateOption option = new UpdateOption(checkTimestamp);
        option.setUpdateProperties(updateProps);
        option.setTargetVersion(targetVersion);
        return option;
    }

    public static UpdateOption allPropertyUpdateOption(String defName, boolean checkTimestamp, boolean localized) {
        if (localized) {
            ExecuteContext exec = ExecuteContext.getCurrentContext();
            EntityContext ec = EntityContext.getCurrentContext();
            EntityHandler eh = ec.getHandlerByName(defName);
            ArrayList<String> updateProps = new ArrayList<String>();
            if (eh.getDataLocalizationStrategyRuntime() != null && eh.getDataLocalizationStrategyRuntime() instanceof MetaEachPropertyDataLocalizationStrategy.EachPropertyDataLocalizationStrategyRuntime) {
                MetaEachPropertyDataLocalizationStrategy.EachPropertyDataLocalizationStrategyRuntime dlsr = (MetaEachPropertyDataLocalizationStrategy.EachPropertyDataLocalizationStrategyRuntime)eh.getDataLocalizationStrategyRuntime();
                Map<String, String> propMap = dlsr.getPropMap(exec.getLanguage());
                for (String pn : propMap.keySet()) {
                    ReferencePropertyHandler rph;
                    PropertyHandler ph = eh.getProperty(pn, ec);
                    if (ph instanceof PrimitivePropertyHandler) {
                        PrimitivePropertyHandler pph = (PrimitivePropertyHandler)ph;
                        if (pph.getMetaData().getType() instanceof ExpressionType || !pph.getMetaData().isUpdatable() || pph.getName().equals("updateBy") || eh.getMetaData().getVersionControlType() != VersionControlType.NONE && (pph.getMetaData().getIndexType() == IndexType.UNIQUE || pph.getMetaData().getIndexType() == IndexType.UNIQUE_WITHOUT_NULL)) continue;
                        updateProps.add(pph.getName());
                        continue;
                    }
                    if (!(ph instanceof ReferencePropertyHandler) || !(rph = (ReferencePropertyHandler)ph).getMetaData().isUpdatable() || rph.getMappedByPropertyHandler(ec) != null) continue;
                    updateProps.add(rph.getName());
                }
                UpdateOption option = new UpdateOption(checkTimestamp);
                option.setUpdateProperties(updateProps);
                option.setTargetVersion(TargetVersion.CURRENT_VALID);
                option.setLocalized(localized);
                return option;
            }
        }
        return UpdateOption.allPropertyUpdateOption(defName, checkTimestamp, TargetVersion.CURRENT_VALID);
    }

    public UpdateOption() {
    }

    public UpdateOption(boolean checkTimestamp) {
        this.checkTimestamp = checkTimestamp;
    }

    public UpdateOption(boolean checkTimestamp, TargetVersion targetVersion) {
        this.checkTimestamp = checkTimestamp;
        this.targetVersion = targetVersion;
    }

    public UpdateOption copy() {
        UpdateOption copy = new UpdateOption();
        if (this.updateProperties != null) {
            copy.updateProperties = new ArrayList<String>(this.updateProperties);
        }
        copy.checkTimestamp = this.checkTimestamp;
        copy.targetVersion = this.targetVersion;
        copy.purgeCompositionedEntity = this.purgeCompositionedEntity;
        copy.forceUpdate = this.forceUpdate;
        copy.checkLockedByUser = this.checkLockedByUser;
        copy.withValidation = this.withValidation;
        copy.notifyListeners = this.notifyListeners;
        copy.localized = this.localized;
        return copy;
    }

    public TargetVersion getTargetVersion() {
        return this.targetVersion;
    }

    public void setTargetVersion(TargetVersion targetVersion) {
        this.targetVersion = targetVersion;
    }

    public boolean isPurgeCompositionedEntity() {
        return this.purgeCompositionedEntity;
    }

    public void setPurgeCompositionedEntity(boolean purgeCompositionedEntity) {
        this.purgeCompositionedEntity = purgeCompositionedEntity;
    }

    public void setCheckTimestamp(boolean checkTimestamp) {
        this.checkTimestamp = checkTimestamp;
    }

    public boolean isCheckTimestamp() {
        return this.checkTimestamp;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    public boolean isCheckLockedByUser() {
        return this.checkLockedByUser;
    }

    public void setCheckLockedByUser(boolean checkLockedByUser) {
        this.checkLockedByUser = checkLockedByUser;
    }

    public boolean isWithValidation() {
        return this.withValidation;
    }

    public void setWithValidation(boolean withValidation) {
        this.withValidation = withValidation;
    }

    public boolean isNotifyListeners() {
        return this.notifyListeners;
    }

    public void setNotifyListeners(boolean notifyListeners) {
        this.notifyListeners = notifyListeners;
    }

    public boolean isLocalized() {
        return this.localized;
    }

    public void setLocalized(boolean localized) {
        this.localized = localized;
    }

    public List<String> getUpdateProperties() {
        return this.updateProperties;
    }

    public void setUpdateProperties(List<String> updateProperties) {
        this.updateProperties = updateProperties;
    }

    public void setUpdateProperties(String ... updateProperty) {
        ArrayList<String> list = new ArrayList<String>();
        if (updateProperty != null) {
            for (String s : updateProperty) {
                list.add(s);
            }
        }
        this.updateProperties = list;
    }

    public UpdateOption add(String updateProperty) {
        if (this.updateProperties == null) {
            this.updateProperties = new ArrayList<String>();
        }
        if (!this.updateProperties.contains(updateProperty)) {
            this.updateProperties.add(updateProperty);
        }
        return this;
    }

    public UpdateOption force() {
        this.forceUpdate = true;
        return this;
    }

    public UpdateOption noCheckLockedByUser() {
        this.checkLockedByUser = false;
        return this;
    }

    public UpdateOption withoutValidation() {
        this.withValidation = false;
        return this;
    }

    public UpdateOption unnotifyListeners() {
        this.notifyListeners = false;
        return this;
    }

    public UpdateOption noPurgeCompositionedEntity() {
        this.purgeCompositionedEntity = false;
        return this;
    }

    public UpdateOption localized() {
        this.localized = true;
        return this;
    }

    public String toString() {
        return "UpdateOption [updateProperties=" + String.valueOf(this.updateProperties) + ", checkTimestamp=" + this.checkTimestamp + ", targetVersion=" + String.valueOf((Object)this.targetVersion) + ", purgeCompositionedEntity=" + this.purgeCompositionedEntity + ", forceUpdate=" + this.forceUpdate + ", checkLockedByUser=" + this.checkLockedByUser + ", withValidation=" + this.withValidation + ", notifyListeners=" + this.notifyListeners + ", localized=" + this.localized + "]";
    }
}

