/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.bulkupdate;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.bulkupdate.BulkUpdatable;
import org.iplass.mtp.entity.bulkupdate.BulkUpdateEntity;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.impl.entity.fileport.EntityCsvReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVFormattedEntityStream
implements BulkUpdatable {
    private static final Logger logger = LoggerFactory.getLogger(CSVFormattedEntityStream.class);
    public static final String CTRL_CODE_KEY = "_useCtrl";
    public static final String CTRL_INSERT = "I";
    public static final String CTRL_UPDATE = "U";
    public static final String CTRL_DELETE = "D";
    public static final String CTRL_MERGE = "M";
    private String definitionName;
    private List<String> updateProperties;
    private boolean enableAuditPropertySpecification;
    private Reader reader;
    private EntityCsvReader esReader;

    public CSVFormattedEntityStream(String definitionName, InputStream inputStream) {
        this.definitionName = definitionName;
        try {
            this.reader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EntityRuntimeException(e);
        }
    }

    public CSVFormattedEntityStream(String definitionName, InputStream inputStream, String charset) {
        this.definitionName = definitionName;
        try {
            this.reader = new InputStreamReader(inputStream, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new EntityRuntimeException(e);
        }
    }

    public CSVFormattedEntityStream(String definitionName, Reader reader) {
        this.definitionName = definitionName;
        this.reader = reader;
    }

    public CSVFormattedEntityStream(String definitionName, List<String> updateProperties, InputStream inputStream) {
        this.definitionName = definitionName;
        this.updateProperties = updateProperties;
        try {
            this.reader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EntityRuntimeException(e);
        }
    }

    public CSVFormattedEntityStream(String definitionName, List<String> updateProperties, InputStream inputStream, String charset) {
        this.definitionName = definitionName;
        this.updateProperties = updateProperties;
        try {
            this.reader = new InputStreamReader(inputStream, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new EntityRuntimeException(e);
        }
    }

    public CSVFormattedEntityStream(String definitionName, List<String> updateProperties, Reader reader) {
        this.definitionName = definitionName;
        this.updateProperties = updateProperties;
        this.reader = reader;
    }

    @Override
    public Iterator<BulkUpdateEntity> iterator() {
        if (this.esReader != null) {
            throw new EntityRuntimeException("concurrent iterate not supported on CSVFormattedEntityStream.");
        }
        EntityDefinitionManager edm = ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
        EntityDefinition def = edm.get(this.definitionName);
        if (def == null) {
            throw new EntityRuntimeException(this.definitionName + " definition not found.");
        }
        this.esReader = (EntityCsvReader)((EntityCsvReader)new EntityCsvReader(def, this.reader).withReferenceVersion(true)).enableAuditPropertySpecification(this.enableAuditPropertySpecification);
        return new It(this, this.esReader.iterator());
    }

    @Override
    public String getDefinitionName() {
        return this.definitionName;
    }

    @Override
    public void close() {
        if (this.esReader != null) {
            try {
                this.esReader.close();
            }
            catch (Exception e) {
                logger.error("Fail to close CSVFormattedEntityStream Resource. Check whether resource is leak or not.", (Throwable)e);
            }
            this.esReader = null;
            this.reader = null;
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                logger.error("Fail to close CSVFormattedEntityStream Resource. Check whether resource is leak or not.", (Throwable)e);
            }
            this.reader = null;
        }
    }

    @Override
    public List<String> getUpdateProperties() {
        return this.updateProperties;
    }

    @Override
    public boolean isEnableAuditPropertySpecification() {
        return this.enableAuditPropertySpecification;
    }

    public void setEnableAuditPropertySpecification(boolean enableAuditPropertySpecification) {
        this.enableAuditPropertySpecification = enableAuditPropertySpecification;
    }

    private class It
    implements Iterator<BulkUpdateEntity> {
        Iterator<Entity> internal;

        private It(CSVFormattedEntityStream cSVFormattedEntityStream, Iterator<Entity> internal) {
            this.internal = internal;
        }

        @Override
        public boolean hasNext() {
            return this.internal.hasNext();
        }

        @Override
        public BulkUpdateEntity next() {
            Entity e = this.internal.next();
            String ctrl = (String)e.getValue(CSVFormattedEntityStream.CTRL_CODE_KEY);
            if (ctrl == null) {
                ctrl = e.getValue("oid") == null ? CSVFormattedEntityStream.CTRL_INSERT : CSVFormattedEntityStream.CTRL_MERGE;
            }
            switch (ctrl) {
                case "D": {
                    return new BulkUpdateEntity(BulkUpdateEntity.UpdateMethod.DELETE, e);
                }
                case "I": {
                    return new BulkUpdateEntity(BulkUpdateEntity.UpdateMethod.INSERT, e);
                }
                case "M": {
                    return new BulkUpdateEntity(BulkUpdateEntity.UpdateMethod.MERGE, e);
                }
                case "U": {
                    return new BulkUpdateEntity(BulkUpdateEntity.UpdateMethod.UPDATE, e);
                }
            }
            throw new IllegalArgumentException("unsupprot controll flag");
        }
    }
}

