/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.definition;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import org.iplass.adminconsole.annotation.MultiLang;
import org.iplass.mtp.definition.Definition;
import org.iplass.mtp.definition.LocalizedStringDefinition;
import org.iplass.mtp.entity.definition.DataLocalizationStrategy;
import org.iplass.mtp.entity.definition.EntityMapping;
import org.iplass.mtp.entity.definition.EventListenerDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.StoreDefinition;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.definition.stores.SchemalessRdbStore;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EntityDefinition
implements Definition {
    private static final long serialVersionUID = 8760071361206854130L;
    public static final String SYSTEM_DEFAULT_DEFINITION_NAME = "Entity";
    private String name;
    @MultiLang(itemNameGetter="getName", itemKey="displayName", itemGetter="getDisplayName", itemSetter="setDisplayName", multiLangGetter="getLocalizedDisplayNameList", multiLangSetter="setLocalizedDisplayNameList")
    private String displayName;
    private String description;
    private String inheritedDefinition;
    private List<String> oidPropertyName;
    private String namePropertyName;
    private List<String> crawlPropertyName;
    @MultiLang(isMultiLangValue=false, itemKey="property", itemGetter="getDeclaredPropertyList", itemSetter="setPropertyList")
    private List<PropertyDefinition> propertyList;
    private List<EventListenerDefinition> eventListenerList;
    private List<LocalizedStringDefinition> localizedDisplayNameList;
    private EntityMapping mapping;
    private StoreDefinition storeDefinition = new SchemalessRdbStore();
    private VersionControlType versionControlType;
    private boolean crawl;
    private boolean queryCache;
    private DataLocalizationStrategy dataLocalizationStrategy;

    public EntityDefinition() {
    }

    public EntityDefinition(String name) {
        this.setName(name);
    }

    public DataLocalizationStrategy getDataLocalizationStrategy() {
        return this.dataLocalizationStrategy;
    }

    public void setDataLocalizationStrategy(DataLocalizationStrategy dataLocalizationStrategy) {
        this.dataLocalizationStrategy = dataLocalizationStrategy;
    }

    public boolean isQueryCache() {
        return this.queryCache;
    }

    public void setQueryCache(boolean queryCache) {
        this.queryCache = queryCache;
    }

    public boolean isCrawl() {
        return this.crawl;
    }

    public void setCrawl(boolean crawl) {
        this.crawl = crawl;
    }

    public String getNamePropertyName() {
        return this.namePropertyName;
    }

    public void setNamePropertyName(String namePropertyName) {
        this.namePropertyName = namePropertyName;
    }

    public VersionControlType getVersionControlType() {
        return this.versionControlType;
    }

    public void setVersionControlType(VersionControlType versionControlType) {
        this.versionControlType = versionControlType;
    }

    public List<String> getOidPropertyName() {
        return this.oidPropertyName;
    }

    public void setOidPropertyName(List<String> oidPropertyName) {
        this.oidPropertyName = oidPropertyName;
    }

    public List<String> getCrawlPropertyName() {
        return this.crawlPropertyName;
    }

    public void setCrawlPropertyName(List<String> crawlPropertyName) {
        this.crawlPropertyName = crawlPropertyName;
    }

    @Override
    public String getName() {
        return this.convertName(this.name);
    }

    @Override
    public void setName(String name) {
        this.name = this.convertName(name);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public String getInheritedDefinition() {
        return this.inheritedDefinition;
    }

    public void setInheritedDefinition(String inheritedDefinition) {
        this.inheritedDefinition = inheritedDefinition;
    }

    public List<PropertyDefinition> getPropertyList() {
        return this.propertyList;
    }

    public void setPropertyList(List<PropertyDefinition> propertyList) {
        this.propertyList = propertyList;
    }

    public List<PropertyDefinition> getDeclaredPropertyList() {
        ArrayList<PropertyDefinition> decList = new ArrayList<PropertyDefinition>();
        if (this.propertyList != null) {
            for (PropertyDefinition pd : this.propertyList) {
                if (pd.isInherited()) continue;
                decList.add(pd);
            }
        }
        return decList;
    }

    public void addProperty(PropertyDefinition property) {
        if (this.propertyList == null) {
            this.propertyList = new ArrayList<PropertyDefinition>();
        }
        this.propertyList.add(property);
    }

    public PropertyDefinition getProperty(String propName) {
        if (this.propertyList == null) {
            return null;
        }
        for (PropertyDefinition p : this.propertyList) {
            if (!propName.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public EntityMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(EntityMapping mapping) {
        this.mapping = mapping;
    }

    public List<EventListenerDefinition> getEventListenerList() {
        return this.eventListenerList;
    }

    public void setEventListenerList(List<EventListenerDefinition> eventListenerList) {
        this.eventListenerList = eventListenerList;
    }

    public void addEventListener(EventListenerDefinition eventListener) {
        if (this.eventListenerList == null) {
            this.eventListenerList = new ArrayList<EventListenerDefinition>();
        }
        this.eventListenerList.add(eventListener);
    }

    public StoreDefinition getStoreDefinition() {
        return this.storeDefinition;
    }

    public void setStoreDefinition(StoreDefinition storeDefinition) {
        this.storeDefinition = storeDefinition;
    }

    public List<LocalizedStringDefinition> getLocalizedDisplayNameList() {
        return this.localizedDisplayNameList;
    }

    public void setLocalizedDisplayNameList(List<LocalizedStringDefinition> localizedDisplayNameList) {
        this.localizedDisplayNameList = localizedDisplayNameList;
    }

    public void addLocalizedDisplayName(LocalizedStringDefinition localizedDisplayName) {
        if (this.localizedDisplayNameList == null) {
            this.localizedDisplayNameList = new ArrayList<LocalizedStringDefinition>();
        }
        this.localizedDisplayNameList.add(localizedDisplayName);
    }

    private String convertName(String name) {
        return name != null ? name.replace("/", ".") : null;
    }
}

