/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.definition.properties.selectvalue;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import org.iplass.adminconsole.annotation.MultiLang;
import org.iplass.mtp.definition.Definition;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.LocalizedSelectValueDefinition;

@XmlRootElement
public class SelectValueDefinition
implements Definition {
    private static final long serialVersionUID = 7442258946492974274L;
    private String name;
    private String displayName;
    private String description;
    @MultiLang(isMultiLangValue=false, itemKey="selectValue", itemGetter="getSelectValueList", itemSetter="setSelectValueList", multiLangGetter="getLocalizedSelectValueList", multiLangSetter="setLocalizedSelectValueList", isSelectValue=true)
    private List<SelectValue> selectValueList;
    private List<LocalizedSelectValueDefinition> localizedSelectValueList;

    public SelectValue getSelectValue(String value) {
        if (this.selectValueList != null) {
            for (SelectValue s : this.selectValueList) {
                if (!value.equals(s.getValue())) continue;
                return s;
            }
        }
        return null;
    }

    public SelectValue getLocalizedSelectValue(String value, String locale) {
        if (this.localizedSelectValueList != null) {
            for (LocalizedSelectValueDefinition ls : this.localizedSelectValueList) {
                if (!locale.equals(ls.getLocaleName())) continue;
                SelectValue s = ls.getSelectValue(value);
                if (s == null) break;
                return s;
            }
        }
        return this.getSelectValue(value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public List<SelectValue> getSelectValueList() {
        return this.selectValueList;
    }

    public void setSelectValueList(List<SelectValue> selectValueList) {
        this.selectValueList = selectValueList;
    }

    public List<LocalizedSelectValueDefinition> getLocalizedSelectValueList() {
        return this.localizedSelectValueList;
    }

    public void setLocalizedSelectValueList(List<LocalizedSelectValueDefinition> localizedSelectValueList) {
        this.localizedSelectValueList = localizedSelectValueList;
    }

    public void addSelectValue(SelectValue value) {
        if (this.selectValueList == null) {
            this.selectValueList = new ArrayList<SelectValue>();
        }
        this.selectValueList.add(value);
    }

    public void addLocalizedSelectValue(LocalizedSelectValueDefinition localizedSelectValue) {
        if (this.localizedSelectValueList == null) {
            this.localizedSelectValueList = new ArrayList<LocalizedSelectValueDefinition>();
        }
        this.localizedSelectValueList.add(localizedSelectValue);
    }
}

