/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query;

import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.QueryVisitor;
import org.iplass.mtp.entity.query.value.ValueExpression;

public class AsOf
implements ASTNode {
    private static final long serialVersionUID = 5164214522449613176L;
    private AsOfSpec spec;
    private ValueExpression value;

    public AsOf() {
    }

    public AsOf(AsOfSpec spec) {
        this.spec = spec;
    }

    public AsOf(ValueExpression value) {
        this.spec = AsOfSpec.SPEC_VALUE;
        this.value = value;
    }

    public AsOfSpec getSpec() {
        return this.spec;
    }

    public void setSpec(AsOfSpec spec) {
        this.spec = spec;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    public void accept(QueryVisitor visitor) {
        if (visitor.visit(this) && this.value != null) {
            this.value.accept(visitor);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("as of ");
        switch (this.spec.ordinal()) {
            case 1: {
                sb.append("now");
                break;
            }
            case 0: {
                sb.append("update time");
                break;
            }
            case 2: {
                sb.append(this.value);
                break;
            }
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.spec == null ? 0 : this.spec.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AsOf other = (AsOf)obj;
        if (this.spec != other.spec) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static enum AsOfSpec {
        UPDATE_TIME,
        NOW,
        SPEC_VALUE;

    }
}

