/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.condition.expr;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.ConditionVisitor;
import org.iplass.mtp.entity.query.condition.expr.Or;
import org.iplass.mtp.entity.query.condition.expr.Paren;
import org.iplass.mtp.entity.query.condition.predicate.Between;
import org.iplass.mtp.entity.query.condition.predicate.Contains;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.Greater;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.condition.predicate.IsNotNull;
import org.iplass.mtp.entity.query.condition.predicate.IsNull;
import org.iplass.mtp.entity.query.condition.predicate.Lesser;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.entity.query.condition.predicate.Like;
import org.iplass.mtp.entity.query.condition.predicate.NotEquals;

public class And
extends Condition {
    private static final long serialVersionUID = 6770787599085842938L;
    protected List<Condition> childExpressions;

    public And() {
    }

    public And(Condition ... condition) {
        if (condition != null) {
            ArrayList<Condition> condList = new ArrayList<Condition>();
            for (Condition c : condition) {
                if (c instanceof Or) {
                    c = new Paren(c);
                }
                condList.add(c);
            }
            this.childExpressions = condList;
        }
    }

    public And(List<Condition> childExpressions) {
        this.childExpressions = childExpressions;
    }

    public void setConditions(List<Condition> conditions) {
        this.childExpressions = conditions;
    }

    public void addExpression(Condition expression) {
        if (this.childExpressions == null) {
            this.childExpressions = new ArrayList<Condition>();
        }
        if (expression instanceof Or) {
            expression = new Paren(expression);
        }
        this.childExpressions.add(expression);
    }

    public List<Condition> getChildExpressions() {
        return this.childExpressions;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.childExpressions == null ? 0 : this.childExpressions.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        And other = (And)obj;
        return !(this.childExpressions == null ? other.childExpressions != null : !this.childExpressions.equals(other.childExpressions));
    }

    @Override
    public String toString() {
        if (this.childExpressions != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.childExpressions.size(); ++i) {
                if (i != 0) {
                    sb.append(" and ");
                }
                sb.append(this.childExpressions.get(i).toString());
            }
            return sb.toString();
        }
        return null;
    }

    @Override
    public void accept(ConditionVisitor visitor) {
        if (visitor.visit(this) && this.childExpressions != null) {
            for (Condition exp : this.childExpressions) {
                exp.accept(visitor);
            }
        }
    }

    public Condition strip() {
        if (this.childExpressions != null && this.childExpressions.size() == 1) {
            return this.childExpressions.get(0);
        }
        return this;
    }

    public And and(Condition expression) {
        this.addExpression(expression);
        return this;
    }

    public And eq(String propName, Object value) {
        Equals eq = new Equals(propName, value);
        this.addExpression(eq);
        return this;
    }

    public And neq(String propName, Object value) {
        NotEquals eq = new NotEquals(propName, value);
        this.addExpression(eq);
        return this;
    }

    public And lt(String propName, Object value) {
        Lesser less = new Lesser(propName, value);
        this.addExpression(less);
        return this;
    }

    public And lte(String propName, Object value) {
        LesserEqual lessEq = new LesserEqual(propName, value);
        this.addExpression(lessEq);
        return this;
    }

    public And gt(String propName, Object value) {
        Greater great = new Greater(propName, value);
        this.addExpression(great);
        return this;
    }

    public And gte(String propName, Object value) {
        GreaterEqual greatEq = new GreaterEqual(propName, value);
        this.addExpression(greatEq);
        return this;
    }

    public And in(String propName, Object ... values) {
        In in = new In(propName, values);
        this.addExpression(in);
        return this;
    }

    public And in(String propName, SubQuery subQuery) {
        In in = new In(propName, subQuery);
        this.addExpression(in);
        return this;
    }

    @Deprecated
    public And like(String propName, String pattern) {
        Like like = new Like(propName, pattern);
        this.addExpression(like);
        return this;
    }

    public And like(String propName, String str, Like.MatchPattern matchPatternType) {
        Like like = new Like(propName, str, matchPatternType);
        this.addExpression(like);
        return this;
    }

    public And between(String propName, Object from, Object to) {
        Between bet = new Between(propName, from, to);
        this.addExpression(bet);
        return this;
    }

    public And isNull(String propName) {
        IsNull isNull = new IsNull(propName);
        this.addExpression(isNull);
        return this;
    }

    public And isNotNull(String propName) {
        IsNotNull isNotNull = new IsNotNull(propName);
        this.addExpression(isNotNull);
        return this;
    }

    public And contains(String fullTextSearchExpression) {
        Contains contains = new Contains(fullTextSearchExpression);
        this.addExpression(contains);
        return this;
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }
}

