/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.hint;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.hint.EQLHint;
import org.iplass.mtp.entity.query.hint.HintVisitor;

public class IndexHint
extends EQLHint {
    private static final long serialVersionUID = -6307067004560551763L;
    private List<String> propertyNameList;

    public IndexHint() {
    }

    public IndexHint(String ... propertyName) {
        if (propertyName != null) {
            this.propertyNameList = new ArrayList<String>(propertyName.length);
            for (String p : propertyName) {
                this.propertyNameList.add(p);
            }
        }
    }

    public IndexHint(List<String> propertyNameList) {
        this.propertyNameList = propertyNameList;
    }

    public List<String> getPropertyNameList() {
        return this.propertyNameList;
    }

    public void setPropertyNameList(List<String> propertyNameList) {
        this.propertyNameList = propertyNameList;
    }

    public IndexHint add(String propertyName) {
        if (this.propertyNameList == null) {
            this.propertyNameList = new ArrayList<String>();
        }
        this.propertyNameList.add(propertyName);
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.propertyNameList == null ? 0 : this.propertyNameList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexHint other = (IndexHint)obj;
        return !(this.propertyNameList == null ? other.propertyNameList != null : !this.propertyNameList.equals(other.propertyNameList));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("index");
        if (this.propertyNameList != null && this.propertyNameList.size() > 0) {
            sb.append("(");
            boolean first = true;
            for (String p : this.propertyNameList) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(p);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    @Override
    public void accept(HintVisitor visitor) {
        visitor.visit(this);
    }
}

