/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.hint;

import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.entity.query.hint.HintVisitor;

public class NativeHint
extends Hint {
    private static final long serialVersionUID = -7024532266130797312L;
    private String table;
    private String hintExpression;

    public NativeHint() {
    }

    public NativeHint(String hintExpression) {
        this.hintExpression = hintExpression;
        this.checkValidHint();
    }

    public NativeHint(String table, String hintExpression) {
        this.table = table;
        this.hintExpression = hintExpression;
        this.checkValidHint();
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getHintExpression() {
        return this.hintExpression;
    }

    public void setHintExpression(String hintExpression) {
        this.hintExpression = hintExpression;
        this.checkValidHint();
    }

    private void checkValidHint() {
        if (this.hintExpression != null && (this.hintExpression.contains(";") || this.hintExpression.contains("--") || this.hintExpression.contains("/*") || this.hintExpression.contains("*/"))) {
            throw new QueryException("NativeHint expression:'" + this.hintExpression + "' is not valid.");
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hintExpression == null ? 0 : this.hintExpression.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NativeHint other = (NativeHint)obj;
        if (this.hintExpression == null ? other.hintExpression != null : !this.hintExpression.equals(other.hintExpression)) {
            return false;
        }
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }

    @Override
    public String toString() {
        if (this.table == null) {
            return "native('" + this.hintExpression + "')";
        }
        return "native(" + this.table + ",'" + this.hintExpression + "')";
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    @Override
    public void accept(HintVisitor visitor) {
        visitor.visit(this);
    }
}

