/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value.expr;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.expr.Polynomial;
import org.iplass.mtp.entity.query.value.primary.ParenValue;

public class Term
extends ValueExpression {
    private static final long serialVersionUID = -322677503164182618L;
    private List<ValueExpression> mulValues;
    private List<ValueExpression> divValues;

    public Term() {
    }

    public Term(ValueExpression baseValue) {
        this.mul(baseValue);
    }

    public Term(List<ValueExpression> mulValues, List<ValueExpression> divValues) {
        if (mulValues != null) {
            for (ValueExpression v : mulValues) {
                this.mul(v);
            }
        }
        if (divValues != null) {
            for (ValueExpression v : divValues) {
                this.div(v);
            }
        }
    }

    public List<ValueExpression> getMulValues() {
        return this.mulValues;
    }

    public void setMulValues(List<ValueExpression> mulValues) {
        this.mulValues = mulValues;
    }

    public List<ValueExpression> getDivValues() {
        return this.divValues;
    }

    public void setDivValues(List<ValueExpression> divValues) {
        this.divValues = divValues;
    }

    public Term mul(ValueExpression value) {
        if (this.mulValues == null) {
            this.mulValues = new ArrayList<ValueExpression>();
        }
        if (value instanceof Polynomial) {
            value = new ParenValue(value);
        }
        this.mulValues.add(value);
        return this;
    }

    public Term div(ValueExpression value) {
        if (this.divValues == null) {
            this.divValues = new ArrayList<ValueExpression>();
        }
        if (value instanceof Polynomial) {
            value = new ParenValue(value);
        }
        this.divValues.add(value);
        return this;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.mulValues != null) {
            for (i = 0; i < this.mulValues.size(); ++i) {
                if (i != 0) {
                    sb.append("*");
                }
                sb.append(this.mulValues.get(i));
            }
        }
        if (this.divValues != null) {
            for (i = 0; i < this.divValues.size(); ++i) {
                sb.append("/");
                sb.append(this.divValues.get(i));
            }
        }
        return sb.toString();
    }

    @Override
    public void accept(ValueExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.mulValues != null) {
                for (ValueExpression v : this.mulValues) {
                    v.accept(visitor);
                }
            }
            if (this.divValues != null) {
                for (ValueExpression v : this.divValues) {
                    v.accept(visitor);
                }
            }
        }
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.divValues == null ? 0 : this.divValues.hashCode());
        result = 31 * result + (this.mulValues == null ? 0 : this.mulValues.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Term other = (Term)obj;
        if (this.divValues == null ? other.divValues != null : !this.divValues.equals(other.divValues)) {
            return false;
        }
        return !(this.mulValues == null ? other.mulValues != null : !this.mulValues.equals(other.mulValues));
    }
}

