/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value.window;

import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.aggregate.Aggregate;
import org.iplass.mtp.entity.query.value.window.PartitionBy;
import org.iplass.mtp.entity.query.value.window.WindowFunction;
import org.iplass.mtp.entity.query.value.window.WindowOrderBy;
import org.iplass.mtp.entity.query.value.window.WindowSortSpec;

public class WindowAggregate
extends WindowFunction {
    private static final long serialVersionUID = -4147882213737684279L;
    private Aggregate aggregate;

    public WindowAggregate() {
    }

    public WindowAggregate(Aggregate aggregate) {
        this.aggregate = aggregate;
    }

    public WindowAggregate(Aggregate aggregate, PartitionBy partitionBy, WindowOrderBy orderBy) {
        this.aggregate = aggregate;
        this.setPartitionBy(partitionBy);
        this.setOrderBy(orderBy);
    }

    public Aggregate getAggregate() {
        return this.aggregate;
    }

    public void setAggregate(Aggregate aggregate) {
        this.aggregate = aggregate;
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    @Override
    public void accept(ValueExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.aggregate != null) {
                this.aggregate.accept(visitor);
            }
            if (this.getPartitionBy() != null) {
                this.getPartitionBy().accept(visitor);
            }
            if (this.getOrderBy() != null) {
                this.getOrderBy().accept(visitor);
            }
        }
    }

    @Override
    public WindowAggregate partitionBy(Object ... partitionField) {
        super.partitionBy(partitionField);
        return this;
    }

    @Override
    public WindowAggregate orderBy(WindowSortSpec ... sortSpec) {
        super.orderBy(sortSpec);
        return this;
    }

    @Override
    protected void writeWindowFunctionType(StringBuilder sb) {
        if (this.aggregate != null) {
            sb.append(this.aggregate);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.aggregate == null ? 0 : this.aggregate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WindowAggregate other = (WindowAggregate)obj;
        return !(this.aggregate == null ? other.aggregate != null : !this.aggregate.equals(other.aggregate));
    }
}

