/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value.window;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.window.WindowSortSpec;

public class WindowOrderBy
implements ASTNode {
    private static final long serialVersionUID = -2446539769686000926L;
    private List<WindowSortSpec> sortSpecList = new ArrayList<WindowSortSpec>();

    public List<WindowSortSpec> getSortSpecList() {
        return this.sortSpecList;
    }

    public void setSortSpecList(List<WindowSortSpec> sortSpecList) {
        this.sortSpecList = sortSpecList;
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    public void accept(ValueExpressionVisitor visitor) {
        if (visitor.visit(this) && this.sortSpecList != null) {
            for (WindowSortSpec s : this.sortSpecList) {
                s.accept(visitor);
            }
        }
    }

    public WindowOrderBy add(WindowSortSpec sortSpec) {
        if (sortSpec == null) {
            throw new NullPointerException("sortSpec is null");
        }
        if (this.sortSpecList == null) {
            this.sortSpecList = new ArrayList<WindowSortSpec>();
        }
        this.sortSpecList.add(sortSpec);
        return this;
    }

    public WindowOrderBy add(Object value, SortSpec.SortType type) {
        return this.add(value, type, null);
    }

    public WindowOrderBy add(Object value, SortSpec.SortType type, SortSpec.NullOrderingSpec nullOrderingSpec) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        if (this.sortSpecList == null) {
            this.sortSpecList = new ArrayList<WindowSortSpec>();
        }
        ValueExpression v = null;
        if (value instanceof ValueExpression) {
            v = (ValueExpression)value;
        } else if (value instanceof String) {
            v = new EntityField((String)value);
        } else {
            throw new QueryException("value is ValueExpression or String type required.");
        }
        return this.add(new WindowSortSpec(v, type, nullOrderingSpec));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("order by ");
        if (this.sortSpecList != null) {
            for (int i = 0; i < this.sortSpecList.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.sortSpecList.get(i));
            }
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sortSpecList == null ? 0 : this.sortSpecList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WindowOrderBy other = (WindowOrderBy)obj;
        return !(this.sortSpecList == null ? other.sortSpecList != null : !this.sortSpecList.equals(other.sortSpecList));
    }
}

