/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.async.rdb.sql;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.iplass.mtp.async.ExceptionHandlingMode;
import org.iplass.mtp.async.TaskStatus;
import org.iplass.mtp.impl.async.rdb.Task;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class TaskQueueInsertSql
extends UpdateSqlHandler {
    public String toInsertSql(RdbAdapter rdb) {
        return "INSERT INTO TASK_QUEUE(TENANT_ID,Q_ID,TASK_ID,V_TIME,STATUS,G_KEY,VW_ID,EXP_MODE,RES_FLG,VER,UP_DATE,SERVER_ID,RE_CNT,CALLABLE) VALUES(?,?,?,?,?,?,?,?,?,?," + rdb.systimestamp() + ",?,0,?)";
    }

    public void setStoreParameter(Task task, RdbAdapter rdb, PreparedStatement ps) throws SQLException {
        int num = 1;
        ps.setInt(num++, task.getTenantId());
        ps.setInt(num++, task.getQueueId());
        ps.setLong(num++, task.getTaskId());
        ps.setLong(num++, task.getVisibleTime());
        ps.setString(num++, TaskQueueInsertSql.toStatusStr(task.getStatus()));
        ps.setString(num++, task.getGroupingKey());
        ps.setInt(num++, task.getVirtualWorkerId());
        ps.setString(num++, TaskQueueInsertSql.toExpModeStr(task.getExceptionHandlingMode()));
        ps.setString(num++, TaskQueueInsertSql.toFlagStr(task.isReturnResult()));
        ps.setLong(num++, task.getVersion());
        ps.setString(num++, task.getServerId());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(bos));){
            oos.writeObject(task.getCallable());
            oos.flush();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        ps.setBinaryStream(num++, new ByteArrayInputStream(bos.toByteArray()));
    }

    static String toFlagStr(boolean flag) {
        if (flag) {
            return "1";
        }
        return "0";
    }

    static String toExpModeStr(ExceptionHandlingMode exceptionHandlingMode) {
        if (exceptionHandlingMode == null) {
            return null;
        }
        switch (exceptionHandlingMode) {
            case ABORT: {
                return "A";
            }
            case ABORT_LOG_FATAL: {
                return "F";
            }
            case RESTART: {
                return "R";
            }
        }
        return null;
    }

    static String toStatusStr(TaskStatus status) {
        if (status == null) {
            return null;
        }
        switch (status) {
            case ABORTED: {
                return "A";
            }
            case COMPLETED: {
                return "C";
            }
            case EXECUTING: {
                return "E";
            }
            case SUBMITTED: {
                return "S";
            }
            case UNKNOWN: {
                return "U";
            }
            case RETURNED: {
                return "R";
            }
        }
        return null;
    }

    public String toCopySql(RdbAdapter rdb) {
        return "INSERT INTO TASK_QUEUE_HI(TENANT_ID,Q_ID,TASK_ID,V_TIME,STATUS,G_KEY,VW_ID,EXP_MODE,RES_FLG,VER,UP_DATE,SERVER_ID,RE_CNT,CALLABLE,RES) SELECT TENANT_ID,Q_ID,TASK_ID,V_TIME,?,G_KEY,VW_ID,EXP_MODE,RES_FLG,VER+1," + rdb.systimestamp() + ",SERVER_ID,RE_CNT,CALLABLE,RES FROM TASK_QUEUE WHERE TENANT_ID=? AND Q_ID=? AND TASK_ID=? AND VER=?";
    }

    public void setStoreParameterForCopy(Task task, TaskStatus toStatus, RdbAdapter rdb, PreparedStatement ps) throws SQLException {
        int num = 1;
        ps.setString(num++, TaskQueueInsertSql.toStatusStr(toStatus));
        ps.setInt(num++, task.getTenantId());
        ps.setInt(num++, task.getQueueId());
        ps.setLong(num++, task.getTaskId());
        ps.setLong(num++, task.getVersion());
    }
}

