/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.async.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.iplass.mtp.async.AsyncTaskFuture;
import org.iplass.mtp.async.AsyncTaskOption;
import org.iplass.mtp.async.StartMode;
import org.iplass.mtp.async.TaskStatus;
import org.iplass.mtp.impl.async.AsyncTaskContextImpl;
import org.iplass.mtp.impl.async.AsyncTaskRuntimeException;
import org.iplass.mtp.impl.async.AsyncTaskService;
import org.iplass.mtp.impl.async.ExceptionHandleable;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.core.Executable;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.rdb.connection.ResourceHolder;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ThreadingAsyncTaskService
extends AsyncTaskService {
    private static Logger logger = LoggerFactory.getLogger(ThreadingAsyncTaskService.class);
    private static Logger fatal = LoggerFactory.getLogger((String)"mtp.fatal.async");
    public static final String FIXED = "fixed";
    public static final String SINGLE = "single";
    public static final String CACHED = "cached";
    private String threadPoolType = "cached";
    private int corePoolSize = 0;
    private int maximumPoolSize = -1;
    private long keepAliveTime = 60000L;
    private boolean useResourceHolder = true;
    private ExecutorService executor;

    public String getThreadPoolType() {
        return this.threadPoolType;
    }

    public void setThreadPoolType(String threadPoolType) {
        this.threadPoolType = threadPoolType;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    @Override
    public <V> Future<V> execute(Callable<V> task) {
        return this.executeImpl(task, true);
    }

    private <V> V callImpl(Callable<V> task) {
        try {
            return task.call();
        }
        catch (Exception e) {
            throw new WrapException(e);
        }
    }

    public <V> Future<V> executeImpl(final Callable<V> task, boolean inheritAuthContext) {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        final TenantContext tc = ec.getTenantContext();
        AuthContextHolder ach = AuthContextHolder.getAuthContext();
        final UserContext uc = ach.isSecuredAction() && inheritAuthContext ? ach.getUserContext() : null;
        final String mdcUser = ec.getClientId();
        final String mdcTraceId = MDC.get((String)"traceId");
        Callable wrapper = new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    if (ThreadingAsyncTaskService.this.useResourceHolder) {
                        ResourceHolder.init();
                    }
                    Object t = ExecuteContext.executeAs(tc, new Executable<V>(){

                        @Override
                        public V execute() {
                            AsyncTaskContextImpl asyncTaskContext = new AsyncTaskContextImpl(-1L, null);
                            ExecuteContext ec = ExecuteContext.getCurrentContext();
                            try {
                                ec.setAttribute("mtp.async.AsyncTaskContext", asyncTaskContext, false);
                                if (mdcTraceId != null) {
                                    ec.mdcPut("traceId", mdcTraceId);
                                }
                                ec.mdcPut("user", mdcUser);
                                if (uc != null) {
                                    AuthService as = ServiceRegistry.getRegistry().getService(AuthService.class);
                                    Object object = as.doSecuredAction(uc, () -> ThreadingAsyncTaskService.this.callImpl(task));
                                    return object;
                                }
                                Object as = ThreadingAsyncTaskService.this.callImpl(task);
                                return as;
                            }
                            catch (WrapException e) {
                                logger.error("exception occured in async task:" + e.getCause().getMessage(), e.getCause());
                                if (task instanceof ExceptionHandleable) {
                                    ((ExceptionHandleable)((Object)task)).aborted(e.getCause());
                                }
                                throw e;
                            }
                            catch (RuntimeException e) {
                                logger.error("exception occured in async task:" + e.getMessage(), (Throwable)e);
                                if (task instanceof ExceptionHandleable) {
                                    ((ExceptionHandleable)((Object)task)).aborted(e);
                                }
                                throw e;
                            }
                            catch (Error e) {
                                fatal.error("error occured in async task:" + e.getMessage(), (Throwable)e);
                                if (task instanceof ExceptionHandleable) {
                                    ((ExceptionHandleable)((Object)task)).aborted(e);
                                }
                                throw e;
                            }
                            finally {
                                ec.mdcPut("user", null);
                                ec.mdcPut("traceId", null);
                                ec.removeAttribute("mtp.async.AsyncTaskContext");
                            }
                        }
                    });
                    return t;
                }
                catch (WrapException e) {
                    throw (Exception)e.getCause();
                }
                finally {
                    if (ThreadingAsyncTaskService.this.useResourceHolder) {
                        ResourceHolder.fin();
                    }
                }
            }
        };
        return this.executor.submit(wrapper);
    }

    @Override
    public void destroy() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = null;
    }

    @Override
    public void init(Config config) {
        if (config.getValue("threadPoolType") != null) {
            this.threadPoolType = config.getValue("threadPoolType");
        }
        if (config.getValue("corePoolSize") != null) {
            this.corePoolSize = Integer.parseInt(config.getValue("corePoolSize"));
        }
        if (config.getValue("maximumPoolSize") != null) {
            this.maximumPoolSize = Integer.parseInt(config.getValue("maximumPoolSize"));
        }
        if (config.getValue("keepAliveTime") != null) {
            this.keepAliveTime = Long.parseLong(config.getValue("keepAliveTime"));
        }
        if (config.getValue("useResourceHolder") != null) {
            this.useResourceHolder = Boolean.valueOf(config.getValue("useResourceHolder"));
        }
        this.createExecuter();
    }

    private void createExecuter() {
        switch (this.threadPoolType) {
            case "fixed": {
                if (this.corePoolSize < 1) {
                    throw new ServiceConfigrationException("fixed type must specify corePoolSize greater than 1");
                }
                this.executor = Executors.newFixedThreadPool(this.corePoolSize);
                break;
            }
            case "single": {
                this.executor = Executors.newSingleThreadExecutor();
                break;
            }
            case "cached": {
                if (this.maximumPoolSize == -1) {
                    this.executor = new ThreadPoolExecutor(this.corePoolSize, Integer.MAX_VALUE, this.keepAliveTime, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
                    break;
                }
                this.executor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
                break;
            }
            default: {
                throw new ServiceConfigrationException("threadPoolType:" + this.threadPoolType + " unkown");
            }
        }
    }

    @Override
    public <V> AsyncTaskFuture<V> execute(Callable<V> task, AsyncTaskOption option, boolean inheritAuthContext) {
        if (option.getStartMode() == StartMode.AFTER_COMMIT) {
            throw new AsyncTaskRuntimeException("ThreadingAsyncTaskService support only AsyncTaskStartMode.IMMEDIATELY");
        }
        return new ThreadingAsyncTaskFuture<V>(this.executeImpl(task, inheritAuthContext), option.isReturnResult());
    }

    @Override
    public <V> AsyncTaskFuture<V> getResult(long taskId, String queueName) {
        throw new UnsupportedOperationException("ThreadingAsyncTaskService not support getResult() methods");
    }

    private static class WrapException
    extends RuntimeException {
        private static final long serialVersionUID = 6163604599717782498L;

        public WrapException(Throwable cause) {
            super(cause);
        }
    }

    private static class ThreadingAsyncTaskFuture<V>
    implements AsyncTaskFuture<V> {
        private final Future<V> real;
        private final boolean returnResult;

        private ThreadingAsyncTaskFuture(Future<V> real, boolean returnResult) {
            this.real = real;
            this.returnResult = returnResult;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.real.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.real.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.real.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.real.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.real.get(timeout, unit);
        }

        @Override
        public long getTaskId() {
            return -1L;
        }

        @Override
        public TaskStatus getStatus() {
            if (this.real.isCancelled()) {
                return TaskStatus.ABORTED;
            }
            if (this.real.isDone()) {
                if (this.returnResult) {
                    return TaskStatus.RETURNED;
                }
                return TaskStatus.COMPLETED;
            }
            return TaskStatus.EXECUTING;
        }

        @Override
        public String getQueueName() {
            return "localThread";
        }
    }
}

