/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth;

import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.token.AuthTokenInfoList;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.AuthTokenInfoListImpl;
import org.iplass.mtp.impl.auth.UserBinding;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.AnonymousUserContext;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.AuthenticationPolicyService;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAuthenticationPolicy;
import org.iplass.mtp.impl.auth.authenticate.trust.TrustedAuthValidateResult;
import org.iplass.mtp.impl.auth.authorize.AuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthContextHolder {
    private static final Logger log = LoggerFactory.getLogger(AuthContextHolder.class);
    private static final String PERMISSION_CACHE_NAMESPACE = "mtp.auth.permissionCache";
    private AuthService authService;
    private boolean isSecuredAction;
    private boolean isPrivileged = false;
    private UserContext userContext;
    private Map<UserInRoleCacheKey, Boolean> userInRoleCache;
    private CacheStore permissionCache;
    private User userForApl;
    private AuthTokenInfoListImpl authTokenInfoList;
    private MetaAuthenticationPolicy.AuthenticationPolicyRuntime policy;
    private AuthContextHolder wrapped;

    public static AuthContextHolder getAuthContext() {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        AuthContextHolder holder = (AuthContextHolder)ec.getAttribute("mtp.auth.authCotnextHolder");
        if (holder == null) {
            holder = ServiceRegistry.getRegistry().getService(AuthService.class).newAuthContextHolder();
            ec.setAttribute("mtp.auth.authCotnextHolder", holder, false);
        }
        return holder;
    }

    static void reflesh() {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        AuthContextHolder holder = (AuthContextHolder)ec.getAttribute("mtp.auth.authCotnextHolder");
        if (holder != null) {
            AuthService as = ServiceRegistry.getRegistry().getService(AuthService.class);
            UserContext account = as.getCurrentSessionUserContext();
            if (account == null) {
                account = new AnonymousUserContext();
            }
            holder.reflesh(account);
        }
    }

    AuthContextHolder(UserContext userContext, AuthService authService) {
        this.userContext = userContext;
        this.authService = authService;
    }

    public UserBinding newUserBinding() {
        return this.newUserBinding(ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class));
    }

    public UserBinding newUserBinding(TenantAuthorizeContext authContext) {
        return new UserBinding(this.userContext, authContext);
    }

    protected void reflesh(UserContext account) {
        this.userContext = account;
        this.permissionCache = null;
        this.userInRoleCache = null;
        this.userForApl = null;
        this.policy = null;
        this.authTokenInfoList = null;
        if (this.wrapped != null) {
            this.wrapped.reflesh(account);
        }
    }

    public boolean isPrivilegedExecution() {
        return this.isPrivileged() || !this.isSecuredAction();
    }

    void setSecuredAction(boolean isSecuredAction) {
        this.isSecuredAction = isSecuredAction;
    }

    public boolean isSecuredAction() {
        return this.isSecuredAction;
    }

    void setPrivileged(boolean isPrivileged) {
        this.isPrivileged = isPrivileged;
    }

    public boolean isPrivileged() {
        return this.isPrivileged;
    }

    public UserContext getUserContext() {
        return this.userContext;
    }

    public AuthTokenInfoList getAuthTokenInfoList() {
        if (this.authTokenInfoList == null) {
            this.authTokenInfoList = new AuthTokenInfoListImpl(this.getUserContext());
        }
        return this.authTokenInfoList;
    }

    public User getUserCopy() {
        if (this.userForApl == null) {
            this.userForApl = (User)this.getUserContext().getUser().deepCopy();
        }
        return this.userForApl;
    }

    public MetaAuthenticationPolicy.AuthenticationPolicyRuntime getPolicy() {
        if (this.policy == null) {
            String policyName = (String)this.userContext.getAttribute("accountPolicy");
            AuthenticationPolicyService ps = ServiceRegistry.getRegistry().getService(AuthenticationPolicyService.class);
            this.policy = ps.getOrDefault(policyName);
        }
        return this.policy;
    }

    public void setPolicy(MetaAuthenticationPolicy.AuthenticationPolicyRuntime policy) {
        this.policy = policy;
    }

    private boolean userInRole(int tenantId, String role) {
        if (this.isSecuredAction()) {
            return this.authService.getAuthorizationProvider().userInRole(this, tenantId, role);
        }
        return true;
    }

    public boolean userInRole(String role, int tenantId) {
        UserInRoleCacheKey cacheKey;
        Boolean result;
        if (role == null) {
            throw new NullPointerException("role is null");
        }
        if (this.userInRoleCache == null) {
            this.userInRoleCache = new HashMap<UserInRoleCacheKey, Boolean>();
        }
        if ((result = this.userInRoleCache.get(cacheKey = new UserInRoleCacheKey(tenantId, role))) != null && log.isTraceEnabled()) {
            log.trace("userInRole Cache Hit role={}, result={}", (Object)cacheKey, (Object)result);
        }
        if (result == null) {
            boolean userInRole = this.userInRole(tenantId, role);
            result = userInRole;
            this.userInRoleCache.put(cacheKey, result);
            if (log.isDebugEnabled()) {
                log.debug("userInRole(" + role + ", " + tenantId + ") = " + result + " (put to userInRole cache)");
            }
        }
        return result;
    }

    public AuthorizationContext getAuthorizationContext(Permission permission) {
        return this.authService.getAuthorizationContext(permission);
    }

    public boolean checkPermission(Permission permission) {
        if (permission == null) {
            throw new NullPointerException("permission is null");
        }
        if (this.permissionCache == null) {
            this.permissionCache = ServiceRegistry.getRegistry().getService(CacheService.class).createLocalCache(PERMISSION_CACHE_NAMESPACE);
        }
        CacheEntry entry = this.permissionCache.get(permission);
        Boolean result = null;
        if (entry != null) {
            result = (Boolean)entry.getValue();
            if (log.isTraceEnabled()) {
                log.trace("permission cache Hit permission={}, result={}", (Object)permission, (Object)result);
            }
        }
        if (result == null) {
            if (this.isPrivilegedExecution()) {
                if (log.isDebugEnabled()) {
                    log.debug("check " + String.valueOf(permission) + " = true (privilegedExecution)");
                }
                return true;
            }
            AuthorizationContext ac = this.authService.getAuthorizationContext(permission);
            result = ac.isPermit(permission, this);
            if (ac.isResultCacheable(permission)) {
                this.permissionCache.put(new CacheEntry((Object)permission, (Object)result, new Object[0]), true);
                if (log.isDebugEnabled()) {
                    log.debug("check " + String.valueOf(permission) + " = " + result + " (put to permission cache)");
                }
            } else if (log.isDebugEnabled()) {
                log.debug("check " + String.valueOf(permission) + " = " + result);
            }
        }
        return result;
    }

    public boolean[] checkPermission(Permission[] permissions) {
        boolean[] result = new boolean[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            result[i] = this.checkPermission(permissions[i]);
        }
        return result;
    }

    public AuthContextHolder privilegedAuthContextHolder() {
        AuthContextHolder priv = this.authService.newAuthContextHolder(this.userContext);
        priv.isPrivileged = true;
        priv.setSecuredAction(this.isSecuredAction);
        priv.policy = this.policy;
        priv.wrapped = this;
        return priv;
    }

    public TrustedAuthValidateResult checkCurrentSessionTrusted() {
        return this.authService.checkCurrentSessionTrusted();
    }

    private static final class UserInRoleCacheKey {
        final int tenantId;
        final String role;

        UserInRoleCacheKey(int tenantId, String role) {
            this.tenantId = tenantId;
            this.role = role;
        }

        public final int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
            result = 31 * result + this.tenantId;
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UserInRoleCacheKey other = (UserInRoleCacheKey)obj;
            if (this.role == null ? other.role != null : !this.role.equals(other.role)) {
                return false;
            }
            return this.tenantId == other.tenantId;
        }

        public String toString() {
            return "UserInRoleCacheKey [tenantId=" + this.tenantId + ", role=" + this.role + "]";
        }
    }
}

