/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth;

import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.token.AuthTokenInfoList;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.AnonymousUserContext;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;

public class AuthContextImpl
extends AuthContext {
    AuthContextImpl() {
    }

    @Override
    public User getUser() {
        return this.getAuthContextHolder().getUserCopy();
    }

    @Override
    public String getPolicyName() {
        if (this.getAuthContextHolder().getPolicy() != null) {
            return this.getAuthContextHolder().getPolicy().getMetaData().getName();
        }
        return null;
    }

    private AuthContextHolder getAuthContextHolder() {
        return AuthContextHolder.getAuthContext();
    }

    @Override
    public boolean userInRole(String role) {
        if (role == null) {
            throw new NullPointerException("role is null");
        }
        return this.getAuthContextHolder().userInRole(role, ExecuteContext.getCurrentContext().getClientTenantId());
    }

    @Override
    public boolean checkPermission(Permission permission) {
        return this.getAuthContextHolder().checkPermission(permission);
    }

    @Override
    public Tenant getTenant() {
        Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
        return ObjectUtil.deepCopy(tenant);
    }

    @Override
    public void refresh() {
        AuthService as = ServiceRegistry.getRegistry().getService(AuthService.class);
        as.reloadUserEntity();
        AuthContextHolder.reflesh();
    }

    @Override
    public boolean isCurrentSessionTrusted() {
        return this.getAuthContextHolder().checkCurrentSessionTrusted().isTrusted();
    }

    @Override
    public Class<? extends Credential> getCredentialTypeForTrust() {
        return this.getAuthContextHolder().checkCurrentSessionTrusted().getCredentialTypeForTrust();
    }

    @Override
    public boolean isAuthenticated() {
        return !(this.getAuthContextHolder().getUserContext() instanceof AnonymousUserContext);
    }

    @Override
    public Object getAttribute(String name) {
        UserContext uc = this.getAuthContextHolder().getUserContext();
        if (uc == null) {
            return null;
        }
        return uc.getAttribute(name);
    }

    @Override
    public boolean isPrivileged() {
        return this.getAuthContextHolder().isPrivilegedExecution();
    }

    @Override
    public AuthTokenInfoList getAuthTokenInfos() {
        if (this.isAuthenticated()) {
            return this.getAuthContextHolder().getAuthTokenInfoList();
        }
        return null;
    }

    @Override
    public long getAuthTime() {
        UserContext uc = this.getAuthContextHolder().getUserContext();
        if (uc == null) {
            return Long.MIN_VALUE;
        }
        return uc.getCreationTime();
    }
}

