/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth;

import java.util.List;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.AuthManager;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.CredentialExpiredException;
import org.iplass.mtp.auth.login.CredentialUpdateException;
import org.iplass.mtp.auth.login.LoginFailedException;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthContextImpl;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.group.GroupContext;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.spi.ServiceRegistry;

public class AuthManagerImpl
implements AuthManager {
    private AuthService authService = ServiceRegistry.getRegistry().getService(AuthService.class);

    @Override
    public AuthContext getContext() {
        return new AuthContextImpl();
    }

    @Override
    public <T> T doPrivileged(Supplier<T> action) {
        return this.authService.doSecuredAction(AuthContextHolder.getAuthContext().privilegedAuthContextHolder(), action);
    }

    @Override
    public boolean canUpdateCredential() {
        return this.authService.getAccountManagementModule().canUpdateCredential();
    }

    @Override
    public boolean canUpdateCredential(String policyName) {
        return this.authService.getAccountManagementModule(policyName).canUpdateCredential();
    }

    @Override
    public boolean canResetCredential() {
        return this.authService.getAccountManagementModule().canResetCredential();
    }

    @Override
    public boolean canResetCredential(String policyName) {
        return this.authService.getAccountManagementModule(policyName).canResetCredential();
    }

    @Override
    public void resetCredential(Credential credential) {
        this.authService.resetCredential(credential);
    }

    @Override
    public void resetCredential(Credential credential, String policyName) {
        this.authService.resetCredential(credential, policyName);
    }

    @Override
    public String[] getGroupOids(AuthManager.GroupOidListType type, String ... groupCode) {
        TenantAuthorizeContext tenantAuthContext = ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class);
        TreeSet<String> list = new TreeSet<String>();
        block5: for (String code : groupCode) {
            GroupContext gc = tenantAuthContext.getGroupContext(code);
            if (gc == null) continue;
            switch (type) {
                case ONLY_SPECIFY: {
                    list.add(gc.getOid());
                    continue block5;
                }
                case WITH_CHILDREN: {
                    List<GroupContext> gclc = gc.getAllNestedChildGroup();
                    for (GroupContext gclcgc : gclc) {
                        list.add(gclcgc.getOid());
                    }
                    continue block5;
                }
                case WITH_PARENTS: {
                    List<GroupContext> gclp = gc.getGroupPath();
                    for (GroupContext gclpgc : gclp) {
                        list.add(gclpgc.getOid());
                    }
                    continue block5;
                }
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void login(Credential credential) throws LoginFailedException, CredentialExpiredException {
        this.authService.login(credential);
    }

    @Override
    public void logout() {
        this.authService.logout();
    }

    @Override
    public void reAuth(Credential credential) throws LoginFailedException, CredentialExpiredException {
        this.authService.reAuth(credential);
    }

    @Override
    public void updateCredential(Credential oldCredential, Credential newCredential) {
        this.authService.updateCredential(oldCredential, newCredential);
    }

    @Override
    public void updateCredential(Credential oldCredential, Credential newCredential, String policyName) throws CredentialUpdateException {
        this.authService.updateCredential(oldCredential, newCredential, policyName);
    }

    @Override
    public boolean canResetLockoutStatus() {
        return this.authService.getAccountManagementModule().canResetLockoutStatus();
    }

    @Override
    public boolean canResetLockoutStatus(String policyName) {
        return this.authService.getAccountManagementModule(policyName).canResetLockoutStatus();
    }

    @Override
    public void resetLockoutStatus(String accountId) {
        this.authService.getAccountManagementModule().resetLockoutStatus(accountId);
    }

    @Override
    public void resetLockoutStatus(String accountId, String policyName) {
        this.authService.getAccountManagementModule(policyName).resetLockoutStatus(accountId);
    }
}

