/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate;

import java.io.IOException;
import java.io.StringWriter;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.UserEntityResolver;
import org.iplass.mtp.impl.script.GroovyScriptContext;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.GroovyScriptService;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.ScriptService;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountBaseUserEntityResolver
implements UserEntityResolver {
    public static final String UNMODIFIABLE_UNIQUE_KEY_NAME = "unmodifiableUniqueKey";
    public static final String ID_NAME = "id";
    private static Logger logger = LoggerFactory.getLogger(AccountBaseUserEntityResolver.class);
    private AttributeMapping[] attributeMapping;
    private ScriptEngine se;

    public AttributeMapping[] getAttributeMapping() {
        return this.attributeMapping;
    }

    public void setAttributeMapping(AttributeMapping[] attributeMapping) {
        this.attributeMapping = attributeMapping;
    }

    @Override
    public void inited(AuthService service, AuthenticationProvider provider) {
        if (this.attributeMapping == null) {
            this.attributeMapping = new AttributeMapping[3];
            this.attributeMapping[0] = new AttributeMapping("oid", UNMODIFIABLE_UNIQUE_KEY_NAME);
            this.attributeMapping[1] = new AttributeMapping("accountId", ID_NAME);
            this.attributeMapping[2] = new AttributeMapping("name", ID_NAME);
        }
        for (AttributeMapping am : this.attributeMapping) {
            if (am.accountAttributeName != null && am.accountAttributeName.contains("${")) {
                if (this.se == null) {
                    this.se = ((GroovyScriptService)ServiceRegistry.getRegistry().getService(ScriptService.class)).createScriptEngine(true);
                }
                am.accountAttributeNameTemplate = GroovyTemplateCompiler.compile(am.accountAttributeName, "_" + provider.getProviderName() + "_ABUER_AN_" + am.propertyName, (GroovyScriptEngine)this.se);
            }
            if (am.valueConvertScript == null) continue;
            if (this.se == null) {
                this.se = ((GroovyScriptService)ServiceRegistry.getRegistry().getService(ScriptService.class)).createScriptEngine(true);
            }
            am.valueConverterScript = this.se.createScript(am.valueConvertScript, "_" + provider.getProviderName() + "_ABUER_VC_" + am.propertyName);
        }
    }

    @Override
    public User searchUser(AccountHandle account) {
        User user = new User();
        for (AttributeMapping am : this.attributeMapping) {
            Object val = null;
            if (am.getAccountAttributeName() != null) {
                switch (am.getAccountAttributeName()) {
                    case "id": {
                        val = account.getCredential().getId();
                        break;
                    }
                    case "unmodifiableUniqueKey": {
                        val = account.getUnmodifiableUniqueKey();
                        break;
                    }
                    default: {
                        if (am.accountAttributeNameTemplate == null) {
                            val = account.getAttributeMap().get(am.getAccountAttributeName());
                            break;
                        }
                        StringWriter sb = new StringWriter();
                        try {
                            am.accountAttributeNameTemplate.doTemplate(new GroovyTemplateBinding(sb, account.getAttributeMap()));
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        val = sb.toString();
                    }
                }
            }
            if (val == null && am.getDefaultValue() != null) {
                val = am.getDefaultValue();
            }
            if (val != null && am.valueConverterScript != null) {
                GroovyScriptContext ctx = new GroovyScriptContext();
                ctx.setAttribute("value", val);
                val = am.valueConverterScript.eval(ctx);
            }
            if (val != null && am.getType() != null && am.getType() != val.getClass()) {
                val = ConvertUtil.convert(am.getType(), val);
            }
            user.setValue(am.getPropertyName(), val);
        }
        return user;
    }

    @Override
    public String getUnmodifiableUniqueKeyProperty() {
        return "oid";
    }

    public static class AttributeMapping {
        private String propertyName;
        private String accountAttributeName;
        private Object defaultValue;
        private Class<?> type;
        private String valueConvertScript;
        private GroovyTemplate accountAttributeNameTemplate;
        private Script valueConverterScript;

        public AttributeMapping() {
        }

        public AttributeMapping(String propertyName) {
            this.propertyName = propertyName;
        }

        public AttributeMapping(String propertyName, String accountAttributeName) {
            this.propertyName = propertyName;
            this.accountAttributeName = accountAttributeName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getAccountAttributeName() {
            return this.accountAttributeName;
        }

        public void setAccountAttributeName(String accountAttributeName) {
            this.accountAttributeName = accountAttributeName;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public String getValueConvertScript() {
            return this.valueConvertScript;
        }

        public void setValueConvertScript(String valueConvertScript) {
            this.valueConvertScript = valueConvertScript;
        }
    }
}

