/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate;

import java.util.List;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.CredentialUpdateException;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AccountManagementModule;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.AutoLoginHandler;
import org.iplass.mtp.impl.auth.authenticate.DefaultUserEntityResolver;
import org.iplass.mtp.impl.auth.authenticate.UserEntityResolver;
import org.iplass.mtp.impl.auth.authenticate.trust.DefaultTrustedAuthValidator;
import org.iplass.mtp.impl.auth.authenticate.trust.TrustedAuthValidator;
import org.iplass.mtp.impl.auth.log.AuthLogger;
import org.iplass.mtp.impl.auth.log.AuthLoggerService;
import org.iplass.mtp.spi.Config;

public abstract class AuthenticationProviderBase
implements AuthenticationProvider {
    public static AccountManagementModule NO_UPDATABLE_AMM = new AccountManagementModule(){

        @Override
        public void updateCredential(Credential oldCredential, Credential newCredential) throws CredentialUpdateException {
        }

        @Override
        public void update(User user, List<String> updateProperties) {
        }

        @Override
        public void restore(User user) {
        }

        @Override
        public void resetCredential(Credential credential) throws CredentialUpdateException {
        }

        @Override
        public void remove(User user) {
        }

        @Override
        public void purge(User user) {
        }

        @Override
        public void create(User user) {
        }

        @Override
        public boolean canUpdateCredential() {
            return false;
        }

        @Override
        public boolean canUpdate() {
            return false;
        }

        @Override
        public boolean canRestore() {
            return false;
        }

        @Override
        public boolean canResetCredential() {
            return false;
        }

        @Override
        public boolean canRemove() {
            return false;
        }

        @Override
        public boolean canPurge() {
            return false;
        }

        @Override
        public boolean canCreate() {
            return false;
        }

        @Override
        public void afterCreate(User user) {
        }

        @Override
        public boolean canResetLockoutStatus() {
            return false;
        }

        @Override
        public void resetLockoutStatus(String accountId) {
        }

        @Override
        public void afterUpdate(User user, String policyName, List<String> updateProperties) {
        }
    };
    private AuthLogger authLogger;
    private boolean selectableOnAuthPolicy = true;
    private String providerName;
    private String authLoggerName;
    private UserEntityResolver userEntityResolver;
    private TrustedAuthValidator trustedAuthValidator;
    private AutoLoginHandler autoLoginHandler;

    @Override
    public AutoLoginHandler getAutoLoginHandler() {
        return this.autoLoginHandler;
    }

    public void setAutoLoginHandler(AutoLoginHandler autoLoginHandler) {
        this.autoLoginHandler = autoLoginHandler;
    }

    @Override
    public TrustedAuthValidator getTrustedAuthValidator() {
        return this.trustedAuthValidator;
    }

    public void setTrustedAuthValidator(TrustedAuthValidator trustedAuthValidator) {
        this.trustedAuthValidator = trustedAuthValidator;
    }

    @Override
    public UserEntityResolver getUserEntityResolver() {
        return this.userEntityResolver;
    }

    public void setUserEntityResolver(UserEntityResolver userEntityResolver) {
        this.userEntityResolver = userEntityResolver;
    }

    public String getAuthLoggerName() {
        return this.authLoggerName;
    }

    public void setAuthLoggerName(String authLoggerName) {
        this.authLoggerName = authLoggerName;
    }

    @Override
    public boolean isSelectableOnAuthPolicy() {
        return this.selectableOnAuthPolicy;
    }

    public void setSelectableOnAuthPolicy(boolean selectableOnAuthPolicy) {
        this.selectableOnAuthPolicy = selectableOnAuthPolicy;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    @Override
    public AuthLogger getAuthLogger() {
        return this.authLogger;
    }

    @Override
    public void cleanupData() {
    }

    @Override
    public void inited(AuthService service, Config config) {
        this.authLogger = config.getDependentService(AuthLoggerService.class).getAuthLogger(this.authLoggerName);
        if (this.userEntityResolver == null) {
            DefaultUserEntityResolver er = new DefaultUserEntityResolver();
            er.setEagerLoadReferenceProperty(DefaultUserEntityResolver.DEFAULT_EAGER_LOAD_REFERENCE_PROPERTY);
            er.setUnmodifiableUniqueKeyProperty("oid");
            this.userEntityResolver = er;
        }
        this.userEntityResolver.inited(service, this);
        if (this.trustedAuthValidator == null) {
            this.trustedAuthValidator = new DefaultTrustedAuthValidator(this.getAccountHandleClassForTrust().getName(), this.getCredentialTypeForTrust().getName());
        }
        this.trustedAuthValidator.inited(service, this);
        if (this.autoLoginHandler != null) {
            this.autoLoginHandler.inited(service, this);
        }
    }

    protected abstract Class<? extends AccountHandle> getAccountHandleClassForTrust();

    protected Class<? extends Credential> getCredentialTypeForTrust() {
        return this.getCredentialType();
    }

    @Override
    public void destroyed() {
    }
}

