/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate;

import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.UserSessionStore;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.session.Session;
import org.iplass.mtp.impl.session.SessionService;
import org.iplass.mtp.spi.Config;

public class DefaultUserSessionStore
implements UserSessionStore {
    private SessionService sessionService;
    private boolean shareLoginSession;
    private SessionFixationProtectionMethod sessionFixationProtection = SessionFixationProtectionMethod.CHANGE_SESSION_ID;

    public boolean isShareLoginSession() {
        return this.shareLoginSession;
    }

    public void setShareLoginSession(boolean shareLoginSession) {
        this.shareLoginSession = shareLoginSession;
    }

    public SessionFixationProtectionMethod getSessionFixationProtection() {
        return this.sessionFixationProtection;
    }

    public void setSessionFixationProtection(SessionFixationProtectionMethod sessionFixationProtection) {
        this.sessionFixationProtection = sessionFixationProtection;
    }

    public SessionService getSessionService() {
        return this.sessionService;
    }

    @Override
    public UserContext getUserContext() {
        Session session = this.sessionService.getSession(false);
        if (session != null) {
            Object key = null;
            if (this.shareLoginSession) {
                key = "mtp.auth.UserHandle";
            } else {
                int tenantId = ExecuteContext.getCurrentContext().getTenantContext().getTenantId();
                key = "mtp.auth.UserHandle." + tenantId;
            }
            return (UserContext)session.getAttribute((String)key);
        }
        return null;
    }

    @Override
    public void setUserContext(UserContext user, boolean withSessionInit) {
        Session session;
        if (this.sessionFixationProtection == SessionFixationProtectionMethod.CHANGE_SESSION_ID) {
            session = this.sessionService.getSession(true);
            if (withSessionInit) {
                session.changeSessionId();
            }
        } else {
            if (withSessionInit && (session = this.sessionService.getSession(false)) != null) {
                session.invalidate();
            }
            session = this.sessionService.getSession(true);
        }
        if (this.shareLoginSession) {
            session.setAttribute("mtp.auth.UserHandle", user);
        } else {
            int tenantId = ExecuteContext.getCurrentContext().getTenantContext().getTenantId();
            session.setAttribute("mtp.auth.UserHandle." + tenantId, user);
        }
    }

    @Override
    public void invalidateUserSession() {
        Session session = this.sessionService.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    @Override
    public void inited(AuthService service, Config config) {
        this.sessionService = config.getDependentService(SessionService.class);
    }

    @Override
    public void destroyed() {
    }

    public static enum SessionFixationProtectionMethod {
        NEW_SESSION,
        CHANGE_SESSION_ID;

    }
}

