/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.builtin;

import java.io.UnsupportedEncodingException;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.iplass.mtp.impl.auth.authenticate.builtin.PasswordHashSetting;
import org.iplass.mtp.impl.util.HashUtil;
import org.iplass.mtp.spi.ServiceConfigrationException;

public class Argon2PasswordHashSetting
extends PasswordHashSetting {
    public static final String ALG_ARGON2_D = "argon2d";
    public static final String ALG_ARGON2_I = "argon2i";
    public static final String ALG_ARGON2_ID = "argon2id";
    private int parallelism;
    private int memorySizeKB;
    private int iterations;
    private int hashLength = 32;
    private int algArgon2 = 2;

    @Override
    public void setPasswordHashAlgorithm(String passwordHashAlgorithm) {
        if (passwordHashAlgorithm == null) {
            this.algArgon2 = 2;
        }
        switch (passwordHashAlgorithm.toLowerCase()) {
            case "argon2d": {
                this.algArgon2 = 0;
                break;
            }
            case "argon2i": {
                this.algArgon2 = 1;
                break;
            }
            case "argon2id": {
                this.algArgon2 = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown Algorithm:" + passwordHashAlgorithm);
            }
        }
        super.setPasswordHashAlgorithm(passwordHashAlgorithm);
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public int getMemorySizeKB() {
        return this.memorySizeKB;
    }

    public void setMemorySizeKB(int memorySizeKB) {
        this.memorySizeKB = memorySizeKB;
    }

    public int getHashLength() {
        return this.hashLength;
    }

    public void setHashLength(int hashLength) {
        this.hashLength = hashLength;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public void checkValidConfiguration() {
        if (this.algArgon2 != 0 && this.algArgon2 != 1 && this.algArgon2 != 2) {
            throw new ServiceConfigrationException("invalid PasswordHashAlgorithm:" + this.getPasswordHashAlgorithm());
        }
        if (this.parallelism < 1) {
            throw new ServiceConfigrationException("invalid parallelism:" + this.parallelism);
        }
        if (this.memorySizeKB < 1) {
            throw new ServiceConfigrationException("invalid memorySizeKB:" + this.memorySizeKB);
        }
        if (this.iterations < 1) {
            throw new ServiceConfigrationException("invalid iterations:" + this.iterations);
        }
        if (this.hashLength < 1) {
            throw new ServiceConfigrationException("invalid hashLength:" + this.hashLength);
        }
    }

    @Override
    protected String hash(String password, String salt) {
        byte[] ret = new byte[this.hashLength];
        Argon2Parameters.Builder pb = new Argon2Parameters.Builder(this.algArgon2).withParallelism(this.parallelism).withMemoryAsKB(this.memorySizeKB).withIterations(this.iterations);
        try {
            pb.withSalt(salt.getBytes("UTF-8"));
            if (this.getSystemSalt() != null) {
                pb.withSecret(this.getSystemSalt().getBytes("UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        Argon2Parameters params = pb.build();
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        generator.init(params);
        generator.generateBytes(password.toCharArray(), ret);
        StringBuilder sb = new StringBuilder();
        return HashUtil.hexToString(sb, ret);
    }
}

