/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.builtin.policy;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.auth.policy.AccountNotification;
import org.iplass.mtp.auth.policy.AccountNotificationListener;
import org.iplass.mtp.auth.policy.LoginNotification;
import org.iplass.mtp.auth.policy.PasswordNotification;
import org.iplass.mtp.auth.policy.PropertyNotification;
import org.iplass.mtp.auth.policy.definition.AccountNotificationListenerDefinition;
import org.iplass.mtp.auth.policy.definition.NotificationType;
import org.iplass.mtp.auth.policy.definition.listeners.ScriptingAccountNotificationListenerDefinition;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAccountNotificationListener;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;

public class MetaScriptingAccountNotificationListener
extends MetaAccountNotificationListener {
    private static final long serialVersionUID = 6452808987410984246L;
    public static final String NOTIFICATION_BINDING_NAME = "notification";
    private static final String SCRIPT_PREFIX = "MetaScriptingAccountNotificationListener_script";
    private String script;
    private List<NotificationType> listenNotification;

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public List<NotificationType> getListenNotification() {
        return this.listenNotification;
    }

    public void setListenNotification(List<NotificationType> listenNotification) {
        this.listenNotification = listenNotification;
    }

    @Override
    public AccountNotificationListener createInstance(String policyName, int i) {
        TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
        ScriptEngine scriptEngine = tc.getScriptEngine();
        if (this.script != null) {
            String scriptName;
            String scriptWithImport = "import " + NotificationType.class.getName() + ";\n" + this.script;
            Script compiledScript = scriptEngine.createScript(scriptWithImport, scriptName = "MetaScriptingAccountNotificationListener_script_" + policyName + "_" + i);
            if (compiledScript.isInstantiateAs(AccountNotificationListener.class)) {
                return new TypedListener(this, compiledScript);
            }
            return new ScriptListener(this, compiledScript, scriptEngine);
        }
        return null;
    }

    @Override
    public AccountNotificationListenerDefinition currentConfig() {
        ScriptingAccountNotificationListenerDefinition def = new ScriptingAccountNotificationListenerDefinition();
        def.setScript(this.script);
        if (this.listenNotification != null) {
            def.setListenNotification(new ArrayList<NotificationType>(this.listenNotification));
        }
        return def;
    }

    @Override
    public void applyConfig(AccountNotificationListenerDefinition def) {
        ScriptingAccountNotificationListenerDefinition sdef = (ScriptingAccountNotificationListenerDefinition)def;
        this.script = sdef.getScript();
        this.listenNotification = sdef.getListenNotification() != null ? new ArrayList<NotificationType>(sdef.getListenNotification()) : null;
    }

    private class TypedListener
    implements AccountNotificationListener {
        private boolean created;
        private boolean reset;
        private boolean rockedout;
        private boolean credentialUpdate;
        private boolean propertyUpdate;
        private boolean remove;
        private boolean loginSuccess;
        private boolean loginFailed;
        private Script compiledScript;
        private AccountNotificationListener delegate;

        private TypedListener(MetaScriptingAccountNotificationListener metaScriptingAccountNotificationListener, Script compiledScript) {
            this.compiledScript = compiledScript;
            this.delegate = compiledScript.createInstanceAs(AccountNotificationListener.class, null);
            if (metaScriptingAccountNotificationListener.listenNotification != null) {
                for (NotificationType t : metaScriptingAccountNotificationListener.listenNotification) {
                    switch (t) {
                        case CREATED: {
                            this.created = true;
                            break;
                        }
                        case CREDENTIAL_RESET: {
                            this.reset = true;
                            break;
                        }
                        case ROCKEDOUT: {
                            this.rockedout = true;
                            break;
                        }
                        case CREDENTIAL_UPDATED: {
                            this.credentialUpdate = true;
                            break;
                        }
                        case PROPERTY_UPDATED: {
                            this.propertyUpdate = true;
                            break;
                        }
                        case REMOVE: {
                            this.remove = true;
                            break;
                        }
                        case LOGIN_SUCCESS: {
                            this.loginSuccess = true;
                            break;
                        }
                        case LOGIN_FAILED: {
                            this.loginFailed = true;
                            break;
                        }
                    }
                }
            }
        }

        @Override
        public void created(PasswordNotification notification) {
            if (this.created) {
                this.delegate.created(notification);
            }
        }

        @Override
        public void credentialReset(PasswordNotification notification) {
            if (this.reset) {
                this.delegate.credentialReset(notification);
            }
        }

        @Override
        public void rockedout(AccountNotification notification) {
            if (this.rockedout) {
                this.delegate.rockedout(notification);
            }
        }

        @Override
        public void credentialUpdated(PasswordNotification notification) {
            if (this.credentialUpdate) {
                this.delegate.credentialUpdated(notification);
            }
        }

        @Override
        public void propertyUpdated(PropertyNotification notification) {
            if (this.propertyUpdate) {
                this.delegate.propertyUpdated(notification);
            }
        }

        @Override
        public void remove(AccountNotification notification) {
            if (this.remove) {
                this.delegate.remove(notification);
            }
        }

        @Override
        public void loginSuccess(LoginNotification notification) {
            if (this.loginSuccess) {
                this.delegate.loginSuccess(notification);
            }
        }

        @Override
        public void loginFailed(LoginNotification notification) {
            if (this.loginFailed) {
                this.delegate.loginFailed(notification);
            }
        }
    }

    private class ScriptListener
    implements AccountNotificationListener {
        private boolean created;
        private boolean reset;
        private boolean rockedout;
        private boolean credentialUpdate;
        private boolean propertyUpdate;
        private boolean remove;
        private boolean loginSuccess;
        private boolean loginFailed;
        private Script compiledScript;
        private ScriptEngine scriptEngine;

        private ScriptListener(MetaScriptingAccountNotificationListener metaScriptingAccountNotificationListener, Script compiledScript, ScriptEngine scriptEngine) {
            this.compiledScript = compiledScript;
            this.scriptEngine = scriptEngine;
            if (metaScriptingAccountNotificationListener.listenNotification != null) {
                for (NotificationType t : metaScriptingAccountNotificationListener.listenNotification) {
                    switch (t) {
                        case CREATED: {
                            this.created = true;
                            break;
                        }
                        case CREDENTIAL_RESET: {
                            this.reset = true;
                            break;
                        }
                        case ROCKEDOUT: {
                            this.rockedout = true;
                            break;
                        }
                        case CREDENTIAL_UPDATED: {
                            this.credentialUpdate = true;
                            break;
                        }
                        case PROPERTY_UPDATED: {
                            this.propertyUpdate = true;
                            break;
                        }
                        case REMOVE: {
                            this.remove = true;
                            break;
                        }
                        case LOGIN_SUCCESS: {
                            this.loginSuccess = true;
                            break;
                        }
                        case LOGIN_FAILED: {
                            this.loginFailed = true;
                            break;
                        }
                    }
                }
            }
        }

        private Object callScript(AccountNotification notification) {
            ScriptContext sc = this.scriptEngine.newScriptContext();
            sc.setAttribute(MetaScriptingAccountNotificationListener.NOTIFICATION_BINDING_NAME, notification);
            return this.compiledScript.eval(sc);
        }

        @Override
        public void created(PasswordNotification notification) {
            if (this.created) {
                this.callScript(notification);
            }
        }

        @Override
        public void credentialReset(PasswordNotification notification) {
            if (this.reset) {
                this.callScript(notification);
            }
        }

        @Override
        public void rockedout(AccountNotification notification) {
            if (this.rockedout) {
                this.callScript(notification);
            }
        }

        @Override
        public void credentialUpdated(PasswordNotification notification) {
            if (this.credentialUpdate) {
                this.callScript(notification);
            }
        }

        @Override
        public void propertyUpdated(PropertyNotification notification) {
            if (this.propertyUpdate) {
                this.callScript(notification);
            }
        }

        @Override
        public void remove(AccountNotification notification) {
            if (this.remove) {
                this.callScript(notification);
            }
        }

        @Override
        public void loginSuccess(LoginNotification notification) {
            if (this.loginSuccess) {
                this.callScript(notification);
            }
        }

        @Override
        public void loginFailed(LoginNotification notification) {
            if (this.loginFailed) {
                this.callScript(notification);
            }
        }
    }
}

