/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.ldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.ldap.LdapAccountHandle;
import org.iplass.mtp.impl.auth.authenticate.ldap.LdapAuthStrategy;
import org.iplass.mtp.impl.auth.authenticate.ldap.LdapAuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.ldap.LdapUtil;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.tenant.Tenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NeoLdapAuthStrategy
implements LdapAuthStrategy {
    private static final String DN_ATTRIBUTE_NAME = "dn";
    private static final String DEFAULT_INIT_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String LDAP_POOLING_FLAG = "com.sun.jndi.ldap.connect.pool";
    private static Logger logger = LoggerFactory.getLogger(NeoLdapAuthStrategy.class);
    private LdapAuthenticationProvider p;
    private Pattern userNamePattern = Pattern.compile("\\$\\{userName\\}");
    private Pattern tenantNamePattern = Pattern.compile("\\$\\{tenantName\\}");
    private Pattern userDnPattern = Pattern.compile("\\$\\{userDn\\}");
    private boolean providerUrlHasDn;
    private String baseDn;
    private boolean userDnPatternHasUserName;
    private boolean userDnPatternHasTenantName;
    private boolean userBaseDnHasTenantName;
    private boolean userFilterPatternHasUserName;
    private boolean userFilterPatternHasTenantName;
    private boolean groupBaseDnHasTenantName;
    private boolean groupFilterPatternHasTenantName;
    private boolean tenantGroupCnPatternHasTenantName;
    private String[] attrIds;
    private String[] groupAttrIds;
    private boolean hasAdminIdPass;

    NeoLdapAuthStrategy(LdapAuthenticationProvider provider) {
        this.p = provider;
        String purl = (String)this.p.getJndiEnv().get("java.naming.provider.url");
        if (purl == null) {
            throw new ServiceConfigrationException("java.naming.provider.url not specified");
        }
        int index = (purl = purl.substring(purl.indexOf("://") + 3)).lastIndexOf(47);
        if (index >= 0 && index < purl.length() - 1) {
            this.providerUrlHasDn = true;
            try {
                this.baseDn = new LdapName(purl.substring(index + 1)).toString();
            }
            catch (InvalidNameException e) {
                throw new ServiceConfigrationException(e);
            }
        }
        this.userDnPatternHasUserName = this.p.getUserDn() != null && this.p.getUserDn().contains("${userName}");
        this.userDnPatternHasTenantName = this.p.getUserDn() != null && this.p.getUserDn().contains("${tenantName}");
        this.userBaseDnHasTenantName = this.p.getUserBaseDn() != null && this.p.getUserBaseDn().contains("${tenantName}");
        this.userFilterPatternHasUserName = this.p.getUserFilter() != null && this.p.getUserFilter().contains("${userName}");
        this.userFilterPatternHasTenantName = this.p.getUserFilter() != null && this.p.getUserFilter().contains("${tenantName}");
        this.groupBaseDnHasTenantName = this.p.getGroupBaseDn() != null && this.p.getGroupBaseDn().contains("${tenantName}");
        this.groupFilterPatternHasTenantName = this.p.getGroupFilter() != null && this.p.getGroupFilter().contains("${tenantName}");
        boolean bl = this.tenantGroupCnPatternHasTenantName = this.p.getTenantGroupCode() != null && this.p.getTenantGroupCode().contains("${tenantName}");
        if (this.p.getUserAttribute() != null) {
            ArrayList<String> tmp = new ArrayList<String>();
            for (String s : this.p.getUserAttribute()) {
                tmp.add(s);
            }
            if (this.p.getUniqueKeyAttribute() != null && !tmp.contains(this.p.getUniqueKeyAttribute())) {
                tmp.add(this.p.getUniqueKeyAttribute());
            }
            this.attrIds = tmp.toArray(new String[tmp.size()]);
        }
        this.groupAttrIds = new String[]{this.p.getGroupCodeAttribute()};
        this.hasAdminIdPass = this.p.getJndiEnv().get("java.naming.security.principal") != null;
    }

    private Hashtable<Object, Object> createBaseEnv() {
        Hashtable<Object, Object> env = new Hashtable<Object, Object>();
        env.put("java.naming.factory.initial", DEFAULT_INIT_CONTEXT_FACTORY);
        if (this.p.getJndiEnv() != null) {
            env.putAll(this.p.getJndiEnv());
        }
        return env;
    }

    private InitialLdapContext initContext() throws NamingException {
        Hashtable<Object, Object> env = this.createBaseEnv();
        return new InitialLdapContext(env, null);
    }

    private String userDnStr(IdPasswordCredential idPass) {
        String userDn = this.p.getUserDn();
        if (this.userDnPatternHasTenantName) {
            Tenant t = ExecuteContext.getCurrentContext().getCurrentTenant();
            userDn = this.tenantNamePattern.matcher(userDn).replaceAll(LdapUtil.escapeForDN(t.getName()));
        }
        if (this.userDnPatternHasUserName) {
            userDn = this.userNamePattern.matcher(userDn).replaceAll(LdapUtil.escapeForDN(idPass.getId()));
        }
        return userDn;
    }

    private String searchFilterStr(IdPasswordCredential idPass) {
        String filter = this.p.getUserFilter();
        if (this.userFilterPatternHasTenantName) {
            Tenant t = ExecuteContext.getCurrentContext().getCurrentTenant();
            filter = this.tenantNamePattern.matcher(filter).replaceAll(LdapUtil.escapeForFilter(t.getName()));
        }
        if (this.userFilterPatternHasUserName) {
            filter = this.userNamePattern.matcher(filter).replaceAll(LdapUtil.escapeForFilter(idPass.getId()));
        }
        return filter;
    }

    private String userBaseDnStr() {
        String baseDn = this.p.getUserBaseDn();
        if (this.userBaseDnHasTenantName) {
            Tenant t = ExecuteContext.getCurrentContext().getCurrentTenant();
            baseDn = this.tenantNamePattern.matcher(baseDn).replaceAll(LdapUtil.escapeForDN(t.getName()));
        }
        return baseDn;
    }

    private String groupBaseDnStr() {
        String baseDn = this.p.getGroupBaseDn();
        if (this.groupBaseDnHasTenantName) {
            Tenant t = ExecuteContext.getCurrentContext().getCurrentTenant();
            baseDn = this.tenantNamePattern.matcher(baseDn).replaceAll(LdapUtil.escapeForDN(t.getName()));
        }
        return baseDn;
    }

    private String groupFilterStr(String userDn) {
        String filter = this.p.getGroupFilter();
        if (this.groupFilterPatternHasTenantName) {
            Tenant t = ExecuteContext.getCurrentContext().getCurrentTenant();
            filter = this.tenantNamePattern.matcher(filter).replaceAll(LdapUtil.escapeForFilter(t.getName()));
        }
        filter = this.userDnPattern.matcher(filter).replaceAll(LdapUtil.escapeForFilter(userDn));
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> searchUserByFilter(String filter, InitialLdapContext ctx) throws NamingException {
        if (logger.isDebugEnabled()) {
            logger.debug("search User by filter:" + filter);
        }
        SearchControls cons = new SearchControls();
        cons.setSearchScope(2);
        if (this.attrIds != null) {
            cons.setReturningAttributes(this.attrIds);
        }
        String baseDn = "";
        if (this.p.getUserBaseDn() != null) {
            baseDn = this.userBaseDnStr();
        }
        try (NamingEnumeration<SearchResult> results = null;){
            results = ctx.search(baseDn, filter, cons);
            if (results.hasMore()) {
                SearchResult entry = results.next();
                String[] ret = new HashMap();
                ret.put(DN_ATTRIBUTE_NAME, entry.getNameInNamespace());
                NamingEnumeration<? extends Attribute> attrs = entry.getAttributes().getAll();
                while (attrs.hasMore()) {
                    Attribute attr = attrs.next();
                    if (attr.size() > 1) {
                        Object[] vals = new Object[attr.size()];
                        for (int i = 0; i < vals.length; ++i) {
                            vals[i] = attr.get(i);
                        }
                        ret.put(attr.getID(), vals);
                        continue;
                    }
                    ret.put(attr.getID(), attr.get());
                }
                if (this.attrIds != null) {
                    for (String ai : this.attrIds) {
                        if (ret.containsKey(ai)) continue;
                        ret.put(ai, null);
                    }
                }
                String[] stringArray = ret;
                return stringArray;
            }
        }
        return null;
    }

    private Map<String, Object> searchUserByDn(String userDn, InitialLdapContext ctx) throws NamingException {
        String orgDn = userDn;
        if (this.providerUrlHasDn && (userDn = new LdapName(userDn).toString()).endsWith(this.baseDn)) {
            userDn = userDn.substring(0, userDn.length() - this.baseDn.length() - 1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("search User by userDn:" + userDn);
        }
        Attributes attrs = this.attrIds != null ? ctx.getAttributes(userDn, this.attrIds) : ctx.getAttributes(userDn);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(DN_ATTRIBUTE_NAME, orgDn);
        NamingEnumeration<? extends Attribute> ae = attrs.getAll();
        while (ae.hasMore()) {
            Attribute attr = ae.next();
            if (attr.size() > 1) {
                Object[] vals = new Object[attr.size()];
                for (int i = 0; i < vals.length; ++i) {
                    vals[i] = attr.get(i);
                }
                ret.put(attr.getID(), vals);
                continue;
            }
            ret.put(attr.getID(), attr.get());
        }
        if (this.attrIds != null) {
            for (String ai : this.attrIds) {
                if (ret.containsKey(ai)) continue;
                ret.put(ai, null);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> searchGroupByFilter(String filter, InitialLdapContext ctx) throws NamingException {
        if (logger.isDebugEnabled()) {
            logger.debug("search Group by filter:" + filter);
        }
        SearchControls cons = new SearchControls();
        cons.setSearchScope(2);
        cons.setReturningAttributes(this.groupAttrIds);
        String baseDn = "";
        if (this.p.getGroupBaseDn() != null) {
            baseDn = this.groupBaseDnStr();
        }
        try (NamingEnumeration<SearchResult> results = null;){
            results = ctx.search(baseDn, filter, cons);
            ArrayList<String> ret = new ArrayList<String>();
            while (results.hasMore()) {
                SearchResult entry = results.next();
                Attribute gc = entry.getAttributes().get(this.p.getGroupCodeAttribute());
                if (gc == null) continue;
                ret.add(gc.toString());
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccountHandle login(Credential credential) {
        if (!(credential instanceof IdPasswordCredential)) {
            return null;
        }
        IdPasswordCredential idPass = (IdPasswordCredential)credential;
        InitialContext forSearch = null;
        InitialContext forAuth = null;
        LdapAccountHandle account = null;
        Map<String, Object> userAttributes = null;
        try {
            String userDn;
            if (this.p.getUserDn() == null) {
                forSearch = this.initContext();
                String filter = this.searchFilterStr(idPass);
                userAttributes = this.searchUserByFilter(filter, (InitialLdapContext)forSearch);
                userDn = (String)userAttributes.get(DN_ATTRIBUTE_NAME);
            } else {
                userDn = this.userDnStr(idPass);
            }
            Hashtable<Object, Object> env = this.createBaseEnv();
            env.remove(LDAP_POOLING_FLAG);
            env.put("java.naming.security.principal", userDn);
            env.put("java.naming.security.credentials", idPass.getPassword());
            try {
                forAuth = new InitialLdapContext(env, null);
                account = new LdapAccountHandle(idPass.getId());
            }
            catch (NamingException e) {
                logger.debug("login failed.", (Throwable)e);
                AccountHandle accountHandle = null;
                if (forSearch != null) {
                    try {
                        forSearch.close();
                    }
                    catch (NamingException e2) {
                        logger.error("Fail to close InitialLdapContext. Check whether resource is leak or not.", (Throwable)e2);
                    }
                }
                if (forAuth != null) {
                    try {
                        forAuth.close();
                    }
                    catch (NamingException e3) {
                        logger.error("Fail to close InitialLdapContext. Check whether resource is leak or not.", (Throwable)e3);
                    }
                }
                return accountHandle;
            }
            if (this.p.isGetUser() && userAttributes == null || this.p.isGetGroup() || this.p.isGroupAsTenant()) {
                if (forSearch == null) {
                    if (this.hasAdminIdPass) {
                        forSearch = this.initContext();
                        forAuth.close();
                    } else {
                        forSearch = forAuth;
                    }
                } else {
                    forAuth.close();
                }
            }
            forAuth = null;
            if (this.p.isGetUser() && userAttributes == null) {
                if (this.p.getUserFilter() != null) {
                    String filter = this.searchFilterStr(idPass);
                    userAttributes = this.searchUserByFilter(filter, (InitialLdapContext)forSearch);
                    if (userAttributes == null) {
                        throw new NamingException("Can't search user attributes, maybe search filter is wrong or has no permission:filter=" + filter);
                    }
                } else {
                    userAttributes = this.searchUserByDn(userDn, (InitialLdapContext)forSearch);
                    if (userAttributes == null) {
                        throw new NamingException("Can't search user attributes, maybe userDN is wrong or has no permission:userDN=" + userDn);
                    }
                }
                account.getAttributeMap().putAll(userAttributes);
                if (this.p.getUniqueKeyAttribute() != null) {
                    account.setUnmodifiableUniqueKey(ConvertUtil.convert(String.class, userAttributes.get(this.p.getUniqueKeyAttribute())));
                }
            }
            if (this.p.isGetGroup() || this.p.isGroupAsTenant()) {
                String userDnForGroupSearch = (String)account.getAttributeMap().get(DN_ATTRIBUTE_NAME);
                if (userDnForGroupSearch == null) {
                    userDnForGroupSearch = userDn;
                }
                String filter = this.groupFilterStr(userDnForGroupSearch);
                List<String> gcodes = this.searchGroupByFilter(filter, (InitialLdapContext)forSearch);
                if (this.p.isGroupAsTenant() && !this.checkTenantValid(gcodes)) {
                    AccountHandle accountHandle = null;
                    return accountHandle;
                }
                if (gcodes != null && gcodes.size() > 0) {
                    account.getAttributeMap().put("groupCode", gcodes.toArray(new String[gcodes.size()]));
                }
            }
            LdapAccountHandle ldapAccountHandle = account;
            return ldapAccountHandle;
        }
        catch (NamingException e) {
            logger.error("Can't login because unexpected error occured on LDAP Access:" + String.valueOf(e), (Throwable)e);
        }
        finally {
            if (forSearch != null) {
                try {
                    forSearch.close();
                }
                catch (NamingException e) {
                    logger.error("Fail to close InitialLdapContext. Check whether resource is leak or not.", (Throwable)e);
                }
            }
            if (forAuth != null) {
                try {
                    forAuth.close();
                }
                catch (NamingException e) {
                    logger.error("Fail to close InitialLdapContext. Check whether resource is leak or not.", (Throwable)e);
                }
            }
        }
        return null;
    }

    private boolean checkTenantValid(List<String> gcodes) {
        String tenantGroupName = ExecuteContext.getCurrentContext().getCurrentTenant().getName();
        if (this.tenantGroupCnPatternHasTenantName) {
            tenantGroupName = this.tenantNamePattern.matcher(this.p.getTenantGroupCode()).replaceAll(tenantGroupName);
        }
        if (gcodes.remove(tenantGroupName)) {
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Can't resolve tenant as group:" + tenantGroupName);
        }
        return false;
    }

    @Override
    public void logout(AccountHandle user) {
    }

    @Override
    public void destroyed() {
    }
}

