/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.rememberme;

import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.CredentialUpdateException;
import org.iplass.mtp.auth.login.LoginFailedException;
import org.iplass.mtp.auth.login.rememberme.RememberMeTokenCredential;
import org.iplass.mtp.auth.login.rememberme.RememberMeTokenStolenException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AccountManagementModule;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProviderBase;
import org.iplass.mtp.impl.auth.authenticate.AutoLoginHandler;
import org.iplass.mtp.impl.auth.authenticate.AutoLoginInstruction;
import org.iplass.mtp.impl.auth.authenticate.UserEntityResolver;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.AuthenticationPolicyService;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAuthenticationPolicy;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaRememberMePolicy;
import org.iplass.mtp.impl.auth.authenticate.rememberme.RememberMeTokenAccountHandle;
import org.iplass.mtp.impl.auth.authenticate.rememberme.RememberMeTokenHandler;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenClientStore;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.auth.authenticate.trust.TrustedAuthValidator;
import org.iplass.mtp.impl.auth.log.AuthLogger;
import org.iplass.mtp.impl.command.RequestContextHolder;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.TenantAuthInfo;
import org.iplass.mtp.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RememberMeTokenAuthenticationProvider
implements AuthenticationProvider,
AutoLoginHandler {
    private static final String REMMEFLAG = "mtp.auth.RememberMeTokenAuthenticationProvider.rememberMe";
    private static Logger logger = LoggerFactory.getLogger(RememberMeTokenAuthenticationProvider.class);
    private String providerName;
    private Boolean selectableOnAuthPolicy;
    private RememberMeTokenHandler tokenHandler;
    private boolean deleteTokenOnFailure = true;
    private String authTokenType = "REMME";
    private AuthTokenClientStore clientStore;
    private RememberMeTokenAccountManagementModule amm = new RememberMeTokenAccountManagementModule();
    private AuthenticationProvider authenticationProvider;
    private TrustedAuthValidator trustedAuthValidator;
    private AutoLoginHandler autoLoginHandler;
    private AuthService service;
    private AuthenticationPolicyService authPolicyService = ServiceRegistry.getRegistry().getService(AuthenticationPolicyService.class);
    private AuthTokenService tokenService = ServiceRegistry.getRegistry().getService(AuthTokenService.class);

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public void setAuthenticationProvider(AuthenticationProvider baseAuthenticationProvider) {
        this.authenticationProvider = baseAuthenticationProvider;
    }

    public boolean isDeleteTokenOnFailure() {
        return this.deleteTokenOnFailure;
    }

    public void setDeleteTokenOnFailure(boolean deleteTokenOnFailure) {
        this.deleteTokenOnFailure = deleteTokenOnFailure;
    }

    public AuthTokenClientStore getClientStore() {
        return this.clientStore;
    }

    public void setClientStore(AuthTokenClientStore clientStore) {
        this.clientStore = clientStore;
    }

    public String getAuthTokenType() {
        return this.authTokenType;
    }

    public void setAuthTokenType(String authTokenType) {
        this.authTokenType = authTokenType;
    }

    @Override
    public void inited(AuthService service, Config config) {
        if (this.trustedAuthValidator != null) {
            this.trustedAuthValidator.inited(service, this);
        }
        this.tokenHandler = (RememberMeTokenHandler)this.tokenService.getHandler(this.authTokenType);
        if (this.autoLoginHandler != null) {
            this.autoLoginHandler.inited(service, this);
        }
        this.service = service;
    }

    @Override
    public void destroyed() {
    }

    @Override
    public void cleanupData() {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        long now = ec.getCurrentTimestamp().getTime();
        if (logger.isDebugEnabled()) {
            logger.debug("creanup timeup token of tenant:" + ec.getClientTenantId());
        }
        List<String> names = this.authPolicyService.nameList();
        for (String name : names) {
            MetaAuthenticationPolicy.AuthenticationPolicyRuntime apr = (MetaAuthenticationPolicy.AuthenticationPolicyRuntime)this.authPolicyService.getRuntimeByName(name);
            if (apr.getMetaData().getRememberMePolicy() == null || apr.getMetaData().getRememberMePolicy().getLifetimeMinutes() <= 0L) continue;
            long timeoutMillis = TimeUnit.MINUTES.toMillis(apr.getMetaData().getRememberMePolicy().getLifetimeMinutes());
            this.tokenHandler.authTokenStore().deleteByDate(ec.getClientTenantId(), this.authTokenType, new Timestamp(now - timeoutMillis));
        }
        this.authenticationProvider.cleanupData();
    }

    @Override
    public AccountHandle login(Credential credential) {
        Boolean remMeFlag;
        if (credential instanceof RememberMeTokenCredential) {
            MetaRememberMePolicy pol;
            AuthToken rmtoken;
            RememberMeTokenCredential rmtc = (RememberMeTokenCredential)credential;
            RememberMeTokenAccountHandle account = null;
            int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
            if (rmtc.getToken() != null) {
                AuthToken crToken = new AuthToken();
                crToken.decodeToken(rmtc.getToken());
                if (!this.authTokenType.equals(crToken.getType())) {
                    return null;
                }
                if (crToken.getToken() == null) {
                    if (this.deleteTokenOnFailure) {
                        this.clientStore.clearToken();
                    }
                    throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.authenticate.rememberme.failed", new Object[0]));
                }
                rmtoken = this.tokenHandler.authTokenStore().getBySeries(tenantId, this.authTokenType, crToken.getSeries());
                if (rmtoken == null) {
                    if (this.deleteTokenOnFailure) {
                        this.clientStore.clearToken();
                    }
                    throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.authenticate.rememberme.failed", new Object[0]));
                }
                if (!this.tokenHandler.checkTokenValid(crToken.getToken(), rmtoken)) {
                    if (this.deleteTokenOnFailure) {
                        this.tokenHandler.authTokenStore().delete(tenantId, this.authTokenType, rmtoken.getOwnerId());
                        this.clientStore.clearToken();
                    }
                    throw new RememberMeTokenStolenException(CoreResourceBundleUtil.resourceString("impl.auth.authenticate.rememberme.tokenStolen", new Object[0]));
                }
                pol = this.rememberMePolicy(rmtoken.getPolicyName());
                if (pol == null) {
                    if (this.deleteTokenOnFailure) {
                        this.tokenHandler.authTokenStore().delete(tenantId, this.authTokenType, rmtoken.getOwnerId());
                        this.clientStore.clearToken();
                    }
                    throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.authenticate.rememberme.failed", new Object[0]));
                }
                int maxAgeSeconds = this.maxAgeSeconds(rmtoken, pol.getLifetimeMinutes());
                if (maxAgeSeconds <= 0) {
                    if (this.deleteTokenOnFailure) {
                        this.clientStore.clearToken();
                    }
                    throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.authenticate.rememberme.expired", new Object[0]));
                }
            } else {
                throw new IllegalArgumentException("specify token");
            }
            AuthToken newToken = this.nextToken(rmtoken, !pol.isAbsoluteLifetime());
            int newMaxAgeSeconds = this.maxAgeSeconds(newToken, pol.getLifetimeMinutes());
            Transaction.requiresNew(t -> {
                this.tokenHandler.authTokenStore().update(newToken, rmtoken);
                t.afterCommit(() -> this.clientStore.setToken(newToken.encodeToken(), newMaxAgeSeconds));
            });
            account = new RememberMeTokenAccountHandle(newToken.getOwnerId(), newToken.getSeries(), newToken.getPolicyName());
            return account;
        }
        AccountHandle account = this.authenticationProvider.login(credential);
        if (account != null && (remMeFlag = (Boolean)credential.getAuthenticationFactor("rememberMe")) != null && remMeFlag.booleanValue()) {
            account.getAttributeMap().put(REMMEFLAG, true);
        }
        return account;
    }

    @Override
    public void afterLoginSuccess(AccountHandle account) {
        Boolean remMeFlag = (Boolean)account.getAttributeMap().get(REMMEFLAG);
        if (remMeFlag != null && remMeFlag.booleanValue()) {
            String policyName = this.policyName(account);
            MetaRememberMePolicy rememberMePolicy = this.rememberMePolicy(policyName);
            if (rememberMePolicy != null && rememberMePolicy.getLifetimeMinutes() > 0L) {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                Transaction.requiresNew(t -> {
                    AuthToken seriesToken;
                    RequestContext req;
                    if (!this.deleteTokenOnFailure && (req = RequestContextHolder.getCurrent()) != null && (seriesToken = new AuthToken(this.clientStore.getToken())) != null) {
                        this.tokenHandler.authTokenStore().deleteBySeries(tenantId, this.authTokenType, seriesToken.getSeries());
                    }
                    AuthToken newToken = this.tokenHandler.newAuthToken(account.getUnmodifiableUniqueKey(), policyName, null);
                    this.tokenHandler.authTokenStore().create(newToken);
                    t.afterCommit(() -> this.clientStore.setToken(newToken.encodeToken(), this.maxAgeSeconds(newToken, rememberMePolicy.getLifetimeMinutes())));
                });
            } else {
                this.clientStore.clearToken();
            }
        }
        this.authenticationProvider.afterLoginSuccess(account);
    }

    private int maxAgeSeconds(AuthToken token, long lifetimeMinutes) {
        if (lifetimeMinutes > 0L) {
            return (int)((token.getStartDate().getTime() + TimeUnit.MINUTES.toMillis(lifetimeMinutes) - System.currentTimeMillis()) / 1000L);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void afterLogout(AccountHandle user) {
        this.authenticationProvider.afterLogout(user);
    }

    private String policyName(AccountHandle account) {
        return (String)account.getAttributeMap().get("accountPolicy");
    }

    private MetaRememberMePolicy rememberMePolicy(String policyName) {
        MetaAuthenticationPolicy.AuthenticationPolicyRuntime pol = this.authPolicyService.getOrDefault(policyName);
        if (pol == null) {
            return null;
        }
        return pol.getMetaData().getRememberMePolicy();
    }

    @Override
    public void logout(AccountHandle user) {
        Transaction.requiresNew(t -> {
            this.clientStore.clearToken();
            this.tokenHandler.authTokenStore().delete(ExecuteContext.getCurrentContext().getClientTenantId(), this.authTokenType, user.getUnmodifiableUniqueKey());
        });
        this.authenticationProvider.logout(user);
    }

    @Override
    public AccountManagementModule getAccountManagementModule() {
        return this.amm;
    }

    @Override
    public boolean isSelectableOnAuthPolicy() {
        if (this.selectableOnAuthPolicy == null) {
            return this.authenticationProvider.isSelectableOnAuthPolicy();
        }
        return this.selectableOnAuthPolicy;
    }

    public void setSelectableOnAuthPolicy(boolean selectableOnAuthPolicy) {
        this.selectableOnAuthPolicy = selectableOnAuthPolicy;
    }

    @Override
    public String getProviderName() {
        if (this.providerName == null) {
            return this.authenticationProvider.getProviderName();
        }
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    @Override
    public AuthLogger getAuthLogger() {
        return this.authenticationProvider.getAuthLogger();
    }

    @Override
    public UserEntityResolver getUserEntityResolver() {
        return this.authenticationProvider.getUserEntityResolver();
    }

    public void setTrustedAuthValidator(TrustedAuthValidator trustedAuthValidator) {
        this.trustedAuthValidator = trustedAuthValidator;
    }

    @Override
    public TrustedAuthValidator getTrustedAuthValidator() {
        if (this.trustedAuthValidator == null && this.authenticationProvider != null) {
            return this.authenticationProvider.getTrustedAuthValidator();
        }
        return this.trustedAuthValidator;
    }

    @Override
    public Class<? extends Credential> getCredentialType() {
        return this.authenticationProvider.getCredentialType();
    }

    @Override
    public AutoLoginHandler getAutoLoginHandler() {
        if (this.autoLoginHandler == null) {
            return this;
        }
        return this.autoLoginHandler;
    }

    public void setAutoLoginHandler(AutoLoginHandler autoLoginHandler) {
        this.autoLoginHandler = autoLoginHandler;
    }

    @Override
    public Exception handleException(AutoLoginInstruction ali, ApplicationException e, RequestContext req, boolean isLogined, UserContext user) {
        if (this.deleteTokenOnFailure && e instanceof RememberMeTokenStolenException) {
            return e;
        }
        if (ali.getCredential() instanceof RememberMeTokenCredential) {
            return null;
        }
        if (this.authenticationProvider.getAutoLoginHandler() != null) {
            return this.authenticationProvider.getAutoLoginHandler().handleException(ali, e, req, isLogined, user);
        }
        return null;
    }

    @Override
    public void handleSuccess(AutoLoginInstruction ali, RequestContext req, UserContext user) {
        if (!(ali.getCredential() instanceof RememberMeTokenCredential) && this.authenticationProvider.getAutoLoginHandler() != null) {
            this.authenticationProvider.getAutoLoginHandler().handleSuccess(ali, req, user);
        }
    }

    @Override
    public AutoLoginInstruction handle(RequestContext req, boolean isLogined, UserContext user) {
        AuthToken token;
        Tenant t;
        if (!isLogined && (t = ExecuteContext.getCurrentContext().getCurrentTenant()) != null && t.getTenantConfig(TenantAuthInfo.class) != null && t.getTenantConfig(TenantAuthInfo.class).isUseRememberMe() && this.authTokenType.equals((token = new AuthToken(this.clientStore.getToken())).getType()) && token.getSeries() != null) {
            return new AutoLoginInstruction(new RememberMeTokenCredential(token.encodeToken()));
        }
        if (this.authenticationProvider.getAutoLoginHandler() != null) {
            return this.authenticationProvider.getAutoLoginHandler().handle(req, isLogined, user);
        }
        return AutoLoginInstruction.THROUGH;
    }

    private AuthToken nextToken(AuthToken previousToken, boolean updateDate) {
        Timestamp startDate = updateDate ? new Timestamp(System.currentTimeMillis()) : previousToken.getStartDate();
        return new AuthToken(previousToken.getTenantId(), previousToken.getType(), previousToken.getOwnerId(), previousToken.getSeries(), this.tokenHandler.newTokenString(null), previousToken.getPolicyName(), startDate, previousToken.getDetails());
    }

    private class RememberMeTokenAccountManagementModule
    implements AccountManagementModule {
        private RememberMeTokenAccountManagementModule() {
        }

        private AccountManagementModule am() {
            AccountManagementModule am = RememberMeTokenAuthenticationProvider.this.authenticationProvider.getAccountManagementModule();
            if (am == null) {
                logger.warn("No AccountManagementModule is specified, so use NO_UPDATABLE_AMM");
                am = AuthenticationProviderBase.NO_UPDATABLE_AMM;
            }
            return am;
        }

        @Override
        public boolean canCreate() {
            return this.am().canCreate();
        }

        @Override
        public boolean canUpdate() {
            return this.am().canUpdate();
        }

        @Override
        public boolean canRemove() {
            return true;
        }

        @Override
        public boolean canRestore() {
            return this.am().canRestore();
        }

        @Override
        public boolean canPurge() {
            return this.am().canPurge();
        }

        @Override
        public boolean canUpdateCredential() {
            return this.am().canUpdateCredential();
        }

        @Override
        public boolean canResetCredential() {
            return this.am().canResetCredential();
        }

        @Override
        public void create(User user) {
            this.am().create(user);
        }

        @Override
        public void afterCreate(User user) {
            this.am().afterCreate(user);
        }

        @Override
        public void update(User user, List<String> updateProperties) {
            this.am().update(user, updateProperties);
        }

        @Override
        public void afterUpdate(User user, String policyName, List<String> updateProperties) {
            this.am().afterUpdate(user, policyName, updateProperties);
        }

        @Override
        public void remove(User user) {
            if (this.am().canRemove()) {
                this.am().remove(user);
            }
            UserEntityResolver uer = RememberMeTokenAuthenticationProvider.this.getUserEntityResolver();
            RememberMeTokenAuthenticationProvider.this.tokenHandler.authTokenStore().delete(ExecuteContext.getCurrentContext().getClientTenantId(), RememberMeTokenAuthenticationProvider.this.authTokenType, user.getValue(uer.getUnmodifiableUniqueKeyProperty()).toString());
        }

        @Override
        public void restore(User user) {
            this.am().restore(user);
        }

        @Override
        public void purge(User user) {
            this.am().purge(user);
        }

        @Override
        public void updateCredential(Credential oldCredential, Credential newCredential) throws CredentialUpdateException {
            this.am().updateCredential(oldCredential, newCredential);
        }

        @Override
        public void resetCredential(Credential credential) throws CredentialUpdateException {
            this.am().resetCredential(credential);
        }

        @Override
        public boolean canResetLockoutStatus() {
            return this.am().canResetLockoutStatus();
        }

        @Override
        public void resetLockoutStatus(String accountId) {
            this.am().resetLockoutStatus(accountId);
        }
    }
}

