/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.token;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenStore;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenUpdateException;
import org.iplass.mtp.impl.auth.authenticate.token.sql.AuthTokenSelectSQL;
import org.iplass.mtp.impl.auth.authenticate.token.sql.AuthTokenUpdateSQL;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.spi.ServiceRegistry;

public class RdbAuthTokenStore
implements AuthTokenStore {
    private AuthTokenSelectSQL selectSql;
    private AuthTokenUpdateSQL updateSql;
    private RdbAdapter rdb = ServiceRegistry.getRegistry().getService(RdbAdapterService.class).getRdbAdapter();
    private boolean saveDetailAsJson;
    private ObjectMapper objectMapper;

    public RdbAuthTokenStore() {
        this.selectSql = this.rdb.getQuerySqlCreator(AuthTokenSelectSQL.class);
        this.updateSql = this.rdb.getUpdateSqlCreator(AuthTokenUpdateSQL.class);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.OBJECT_AND_NON_CONCRETE, JsonTypeInfo.As.PROPERTY);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configOverride(Date.class).setFormat(JsonFormat.Value.forPattern((String)"yyyy-MM-dd").withTimeZone(TimeZone.getDefault()));
    }

    public boolean isSaveDetailAsJson() {
        return this.saveDetailAsJson;
    }

    public void setSaveDetailAsJson(boolean saveDetailAsJson) {
        this.saveDetailAsJson = saveDetailAsJson;
    }

    @Override
    public void create(final AuthToken token) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAuthTokenStore.this.updateSql.createInsertSQL());
                try {
                    RdbAuthTokenStore.this.updateSql.setInsertParameter(RdbAuthTokenStore.this.rdb, ps, token, RdbAuthTokenStore.this.saveDetailAsJson, RdbAuthTokenStore.this.objectMapper);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
                int cnt = ps.executeUpdate();
                if (cnt != 1) {
                    throw new AuthTokenUpdateException("fail to insert AuthToken:" + token.getSeries());
                }
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    @Override
    public void update(final AuthToken newToken, final AuthToken currentToken) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAuthTokenStore.this.updateSql.createUpdateStrictSQL());
                try {
                    RdbAuthTokenStore.this.updateSql.setUpdateStrictParameter(RdbAuthTokenStore.this.rdb, ps, newToken, currentToken, RdbAuthTokenStore.this.saveDetailAsJson, RdbAuthTokenStore.this.objectMapper);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
                int cnt = ps.executeUpdate();
                if (cnt != 1) {
                    throw new AuthTokenUpdateException("fail to update AuthToken:" + newToken.getSeries());
                }
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    @Override
    public void delete(final int tenantId, final String type, final String uniqueKey) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAuthTokenStore.this.updateSql.createDeleteSQL());
                RdbAuthTokenStore.this.updateSql.setDeleteParameter(RdbAuthTokenStore.this.rdb, ps, tenantId, type, uniqueKey);
                ps.executeUpdate();
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    @Override
    public void deleteByDate(final int tenantId, final String type, final Timestamp ts) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAuthTokenStore.this.updateSql.createDeleteByDateSQL());
                RdbAuthTokenStore.this.updateSql.setDeleteByDateParameter(RdbAuthTokenStore.this.rdb, ps, tenantId, type, ts);
                ps.executeUpdate();
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    @Override
    public AuthToken getBySeries(final int tenantId, final String type, final String series) {
        SqlExecuter<AuthToken> executer = new SqlExecuter<AuthToken>(){

            @Override
            public AuthToken logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAuthTokenStore.this.selectSql.createSelectSQL());
                RdbAuthTokenStore.this.selectSql.setSelectParameter(RdbAuthTokenStore.this.rdb, ps, tenantId, type, series);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        AuthToken authToken = RdbAuthTokenStore.this.selectSql.toAuthToken(rs, RdbAuthTokenStore.this.saveDetailAsJson, RdbAuthTokenStore.this.objectMapper, RdbAuthTokenStore.this.rdb);
                        return authToken;
                    }
                    AuthToken authToken = null;
                    return authToken;
                }
            }
        };
        return (AuthToken)executer.execute(this.rdb, true);
    }

    @Override
    public void deleteBySeries(final int tenantId, final String type, final String series) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAuthTokenStore.this.updateSql.createDeleteBySeriesSQL());
                RdbAuthTokenStore.this.updateSql.setDeleteBySeriesParameter(RdbAuthTokenStore.this.rdb, ps, tenantId, type, series);
                ps.executeUpdate();
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    @Override
    public List<AuthToken> getByOwner(final int tenantId, final String type, final String userUniqueKey) {
        SqlExecuter<List<AuthToken>> executer = new SqlExecuter<List<AuthToken>>(){

            @Override
            public List<AuthToken> logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbAuthTokenStore.this.selectSql.createSelectByUserUniqueKeySQL());
                RdbAuthTokenStore.this.selectSql.setSelectByUserUniqueKeyParameter(RdbAuthTokenStore.this.rdb, ps, tenantId, type, userUniqueKey);
                ArrayList<AuthToken> res = new ArrayList<AuthToken>();
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        res.add(RdbAuthTokenStore.this.selectSql.toAuthToken(rs, RdbAuthTokenStore.this.saveDetailAsJson, RdbAuthTokenStore.this.objectMapper, RdbAuthTokenStore.this.rdb));
                    }
                }
                return res;
            }
        };
        return (List)executer.execute(this.rdb, true);
    }
}

