/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.beanvalidation;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.beanvalidation.constraints.ValidEntity;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.ValidateResult;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidEntityValidator
implements ConstraintValidator<ValidEntity, Entity> {
    private static Logger logger = LoggerFactory.getLogger(ValidEntityValidator.class);
    private PropTree propTree;
    private boolean hasMessage;
    private EntityManager em;

    public void initialize(ValidEntity constraintAnnotation) {
        String[] props = constraintAnnotation.properties();
        if (props != null && props.length > 0) {
            this.propTree = new PropTree();
            for (String p : props) {
                this.propTree.parse(p);
            }
        }
        if (constraintAnnotation.message() != null && constraintAnnotation.message().length() > 0) {
            this.hasMessage = true;
        }
        this.em = ManagerLocator.getInstance().getManager(EntityManager.class);
    }

    public boolean isValid(Entity value, ConstraintValidatorContext context) {
        if (!this.hasMessage) {
            context.disableDefaultConstraintViolation();
        }
        return this.isValidCascade(value, new LinkedList<Object>(), this.propTree, context);
    }

    private Set<String> allRefs(EntityHandler eh, EntityContext ec) {
        HashSet<String> refs = new HashSet<String>();
        for (ReferencePropertyHandler rh : eh.getReferencePropertyList(false, ec)) {
            refs.add(rh.getName());
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidCascade(Entity value, List<Object> path, PropTree target, ConstraintValidatorContext context) {
        List<String> props = target == null || target.isAllPrimitive ? null : target.reaf();
        ValidateResult vr = this.em.validate(value, props);
        if (vr.hasError()) {
            for (ValidateError ve : vr.getErrors()) {
                for (String msg : ve.getErrorMessages()) {
                    ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext bbcc = null;
                    ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext nbdc = null;
                    Integer index = null;
                    for (Object p : path) {
                        if (p instanceof String) {
                            if (nbdc != null) {
                                bbcc = nbdc.addPropertyNode((String)p);
                                nbdc = null;
                            } else {
                                bbcc = bbcc != null ? bbcc.addPropertyNode((String)p) : context.buildConstraintViolationWithTemplate(msg).addPropertyNode((String)p);
                            }
                            if (index == null) continue;
                            nbdc = bbcc.inIterable().atIndex(index);
                            index = null;
                            continue;
                        }
                        index = (Integer)p;
                    }
                    bbcc = nbdc != null ? nbdc.addPropertyNode(ve.getPropertyName()) : (bbcc != null ? bbcc.addPropertyNode(ve.getPropertyName()) : context.buildConstraintViolationWithTemplate(msg).addPropertyNode(ve.getPropertyName()));
                    if (index != null) {
                        bbcc.inIterable().atIndex(index).addConstraintViolation();
                        continue;
                    }
                    bbcc.addConstraintViolation();
                }
            }
        }
        boolean isValid = !vr.hasError();
        EntityContext ec = EntityContext.getCurrentContext();
        EntityHandler eh = ec.getHandlerByName(value.getDefinitionName());
        Set<String> childKeys = target == null || target.isAllReference ? this.allRefs(eh, ec) : target.childKeys();
        for (String ref : childKeys) {
            PropTree child;
            PropertyHandler ph = eh.getProperty(ref, ec);
            if (ph == null || !(ph instanceof ReferencePropertyHandler)) {
                logger.warn("ReferenceProperty:" + ref + " is undefined on " + value.getDefinitionName() + ", so can not validate..");
                continue;
            }
            PropTree propTree = child = target == null || target.isAllReference ? null : target.children.get(ref);
            if (ph.getMetaData().getMultiplicity() == 1) {
                Entity refEntity = (Entity)value.getValue(ref);
                if (refEntity == null) continue;
                path.add(ref);
                try {
                    isValid &= this.isValidCascade(refEntity, path, child, context);
                    continue;
                }
                finally {
                    path.remove(path.size() - 1);
                    continue;
                }
            }
            Entity[] refEntities = (Entity[])value.getValue(ref);
            if (refEntities == null) continue;
            path.add(ref);
            try {
                for (int i = 0; i < refEntities.length; ++i) {
                    path.add(i);
                    try {
                        isValid &= this.isValidCascade(refEntities[i], path, child, context);
                        continue;
                    }
                    finally {
                        path.remove(path.size() - 1);
                    }
                }
            }
            finally {
                path.remove(path.size() - 1);
            }
        }
        return isValid;
    }

    private static class PropTree {
        PropTree parent;
        boolean isAllPrimitive;
        boolean isAllReference;
        List<String> reaf;
        LinkedHashMap<String, PropTree> children;

        private PropTree() {
        }

        Set<String> childKeys() {
            if (this.children == null) {
                return Collections.emptySet();
            }
            return this.children.keySet();
        }

        List<String> reaf() {
            if (this.reaf == null) {
                return Collections.emptyList();
            }
            return this.reaf;
        }

        void parse(String path) {
            int index = path.indexOf(46);
            if (index > 0) {
                String name = path.substring(0, index);
                String subpath = path.substring(index + 1);
                PropTree child = this.child(name, this.parent);
                child.parse(subpath);
            } else {
                if (this.reaf == null) {
                    this.reaf = new ArrayList<String>();
                }
                this.reaf.add(path);
                if (path.equals("*")) {
                    this.isAllPrimitive = true;
                }
                if (path.equals("**")) {
                    this.isAllPrimitive = true;
                    this.isAllReference = true;
                }
            }
        }

        PropTree child(String name, PropTree parent) {
            PropTree p;
            if (this.children == null) {
                this.children = new LinkedHashMap();
            }
            if ((p = this.children.get(name)) == null) {
                p = new PropTree();
                p.parent = parent;
                this.children.put(name, p);
            }
            return p;
        }
    }
}

