/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.LoadingAdapter;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.cache.store.builtin.NullKey;
import org.iplass.mtp.impl.cache.store.builtin.TransactionLocalCacheStoreFactory;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheController<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(CacheController.class);
    private final LoadingAdapter<K, V> adapter;
    private final CacheStore store;
    private final boolean hasVersion;
    private final int indexCount;
    private final boolean useNegativeCacheOnSharedCache;
    private final boolean isStrictUpdate;

    public CacheController(CacheStore store, boolean hasVersion, int indexCount, LoadingAdapter<K, V> adapter, boolean useNegativeCacheOnSharedCache) {
        this(store, hasVersion, indexCount, adapter, useNegativeCacheOnSharedCache, false);
    }

    public CacheController(CacheStore store, boolean hasVersion, int indexCount, LoadingAdapter<K, V> adapter, boolean useNegativeCacheOnSharedCache, boolean isStrictUpdate) {
        this.adapter = adapter;
        this.hasVersion = hasVersion;
        this.indexCount = indexCount;
        this.store = store;
        this.useNegativeCacheOnSharedCache = useNegativeCacheOnSharedCache;
        this.isStrictUpdate = isStrictUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        CacheEntry entry = this.store.get(key);
        if (entry != null) {
            return (V)entry.getValue();
        }
        if (this.isStrictUpdate) {
            CacheController cacheController = this;
            synchronized (cacheController) {
                entry = this.store.get(key);
                if (entry != null) {
                    return (V)entry.getValue();
                }
                return this.loadByKey(key);
            }
        }
        return this.loadByKey(key);
    }

    private V loadByKey(K key) {
        V value = this.adapter.load(key);
        if (value != null) {
            this.putToCache(value, true, null, 0L);
        } else if (this.useNegativeCacheOnSharedCache) {
            CacheEntry ce = this.hasVersion ? new CacheEntry((Object)key, (Object)null, Long.MIN_VALUE, (Object[])null) : new CacheEntry(key, null, new Object[0]);
            this.store.put(ce, true);
        }
        return value;
    }

    private CacheEntry getInternal(K key) {
        CacheEntry entry = this.store.get(key);
        if (entry != null) {
            return entry;
        }
        V value = this.adapter.load(key);
        CacheEntry ret = null;
        if (value != null) {
            ret = this.putToCache(value, true, null, 0L);
        } else if (this.useNegativeCacheOnSharedCache) {
            CacheEntry ce = this.hasVersion ? new CacheEntry((Object)key, (Object)null, Long.MIN_VALUE, (Object[])null) : new CacheEntry(key, null, new Object[0]);
            this.store.put(ce, true);
            ret = ce;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getByIndex(int indexType, Object indexVal) {
        CacheEntry entry = this.store.getByIndex(indexType, indexVal);
        if (entry != null) {
            return (V)entry.getValue();
        }
        if (this.isStrictUpdate) {
            CacheController cacheController = this;
            synchronized (cacheController) {
                entry = this.store.getByIndex(indexType, indexVal);
                if (entry != null) {
                    return (V)entry.getValue();
                }
                return this.loadByIndex(indexType, indexVal);
            }
        }
        return this.loadByIndex(indexType, indexVal);
    }

    private V loadByIndex(int indexType, Object indexVal) {
        Object value = null;
        List<V> list = this.adapter.loadByIndex(indexType, indexVal);
        if (list != null && list.size() > 0) {
            for (V v : list) {
                this.putToCache(v, true, null, 0L);
            }
            CacheEntry entry = this.store.getByIndex(indexType, indexVal);
            if (entry != null) {
                value = entry.getValue();
            }
        } else if (this.useNegativeCacheOnSharedCache) {
            Object[] indexValues = new Object[this.store.getFactory().getIndexCount()];
            indexValues[indexType] = indexVal;
            CacheEntry ce = this.hasVersion ? new CacheEntry((Object)new NullKey(), (Object)null, Long.MIN_VALUE, indexValues) : new CacheEntry((Object)new NullKey(), null, indexValues);
            this.store.put(ce, true);
        }
        return (V)value;
    }

    private CacheEntry putToCache(V value, boolean clean, V oldVale, long oldVersion) {
        Object[] indexValue;
        if (this.indexCount > 0) {
            indexValue = new Object[this.indexCount];
            for (int i = 0; i < this.indexCount; ++i) {
                indexValue[i] = this.adapter.getIndexVal(i, value);
            }
        } else {
            indexValue = null;
        }
        CacheEntry ce = this.hasVersion ? new CacheEntry(this.adapter.getKey(value), value, this.adapter.getVersion(value), indexValue) : (oldVale == null ? new CacheEntry(this.adapter.getKey(value), value, indexValue) : new CacheEntry(this.adapter.getKey(value), value, oldVersion + 1L, indexValue));
        this.store.put(ce, clean);
        return ce;
    }

    public CacheStore getStore() {
        return this.store;
    }

    public List<V> getListByIndex(int indexType, Object indexVal) {
        List<CacheEntry> ceList = this.store.getListByIndex(indexType, indexVal);
        if (ceList.size() > 0) {
            ArrayList<Object> ret = new ArrayList<Object>();
            for (CacheEntry ce : ceList) {
                ret.add(ce.getValue());
            }
            return ret;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<V> removeByIndex(int indexType, Object indexVal) {
        if (this.isStrictUpdate) {
            CacheController cacheController = this;
            synchronized (cacheController) {
                return this.removeByIndexInternal(indexType, indexVal);
            }
        }
        return this.removeByIndexInternal(indexType, indexVal);
    }

    private List<V> removeByIndexInternal(int indexType, Object indexVal) {
        List<CacheEntry> ceList = this.store.removeByIndex(indexType, indexVal);
        if (ceList != null && ceList.size() > 0) {
            ArrayList<Object> ret = new ArrayList<Object>();
            for (CacheEntry ce : ceList) {
                ret.add(ce.getValue());
            }
            return ret;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCreate(V value) {
        if (this.isStrictUpdate) {
            CacheController cacheController = this;
            synchronized (cacheController) {
                this.putToCache(value, false, null, 0L);
            }
        } else {
            this.putToCache(value, false, null, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUpdate(V value) {
        if (this.isStrictUpdate) {
            CacheController cacheController = this;
            synchronized (cacheController) {
                this.notifyUpdateInternal(value);
            }
        } else {
            this.notifyUpdateInternal(value);
        }
    }

    private void notifyUpdateInternal(V value) {
        CacheEntry oldValue = this.getInternal(this.adapter.getKey(value));
        if (oldValue == null) {
            this.putToCache(value, false, null, 0L);
        } else {
            this.putToCache(value, false, oldValue.getValue(), oldValue.getVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDeleteByKey(K key) {
        if (this.isStrictUpdate) {
            CacheController cacheController = this;
            synchronized (cacheController) {
                this.store.remove(key);
            }
        } else {
            this.store.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInvalidByKey(K key) {
        if (this.isStrictUpdate) {
            CacheController cacheController = this;
            synchronized (cacheController) {
                this.store.remove(key);
            }
        } else {
            this.store.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDelete(V value) {
        if (this.isStrictUpdate) {
            CacheController cacheController = this;
            synchronized (cacheController) {
                this.store.remove(this.adapter.getKey(value));
            }
        } else {
            this.store.remove(this.adapter.getKey(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInvalid(V value) {
        if (this.isStrictUpdate) {
            CacheController cacheController = this;
            synchronized (cacheController) {
                this.store.remove(this.adapter.getKey(value));
            }
        } else {
            this.store.remove(this.adapter.getKey(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        if (this.isStrictUpdate) {
            CacheController cacheController = this;
            synchronized (cacheController) {
                this.store.removeAll();
            }
        } else {
            this.store.removeAll();
        }
    }

    public void refreshTransactionLocalStore(K key) {
        if (this.store instanceof TransactionLocalCacheStoreFactory.TransactionLocalCacheStore) {
            ((TransactionLocalCacheStoreFactory.TransactionLocalCacheStore)this.store).reloadFromBackendStore(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintenance(Consumer<CacheController<K, V>> maintenanceFunction) {
        if (this.isStrictUpdate) {
            CacheController cacheController = this;
            synchronized (cacheController) {
                maintenanceFunction.accept(this);
            }
        } else {
            maintenanceFunction.accept(this);
        }
    }

    public void invalidateCacheStore() {
        ServiceRegistry.getRegistry().getService(CacheService.class).invalidate(this.store.getNamespace());
    }

    public String trace() {
        if (logger.isTraceEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("CacheController Info");
            builder.append("\nCacheController:" + String.valueOf(this));
            builder.append("\n\tCacheStore:" + String.valueOf(this.store));
            builder.append("\n\tLoadingAdapter:" + String.valueOf(this.adapter));
            builder.append("\n\thasVersion:" + this.hasVersion);
            builder.append("\n\tindexCount:" + this.indexCount);
            builder.append("\n\tuseNegativeCacheOnSharedCache:" + this.useNegativeCacheOnSharedCache);
            builder.append("\n" + this.store.trace());
            logger.trace(builder.toString());
            return builder.toString();
        }
        return "CacheController Info(no details)";
    }
}

