/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache.store;

import java.lang.ref.WeakReference;
import java.util.function.BiFunction;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AutoReloader
implements Runnable {
    public static final String AUTO_RELOADER_USER_NAME = "CacheReloader";
    private static Logger logger = LoggerFactory.getLogger(AutoReloader.class);
    private int tenantId;
    private String namespace;
    private WeakReference<CacheEntry> entryRef;
    private long timeToLive;
    private BiFunction<Object, CacheEntry, CacheEntry> reloadFunction;

    AutoReloader(int tenantId, String namespace, CacheEntry entry, long timeToLive, BiFunction<Object, CacheEntry, CacheEntry> reloadFunction) {
        this.tenantId = tenantId;
        this.namespace = namespace;
        this.entryRef = new WeakReference<CacheEntry>(entry);
        this.timeToLive = timeToLive;
        this.reloadFunction = reloadFunction;
    }

    @Override
    public void run() {
        CacheEntry entry = (CacheEntry)this.entryRef.get();
        if (entry == null) {
            logger.debug("cache entry is already garbage collected, so skip reloading. namespace:{}", (Object)this.namespace);
            return;
        }
        CacheStore store = ServiceRegistry.getRegistry().getService(CacheService.class).getCache(this.namespace, false);
        if (store == null) {
            logger.debug("cache store is null, so skip reloading. namespace:{}", (Object)this.namespace);
            return;
        }
        CacheEntry currentEntry = store.get(entry.getKey());
        if (currentEntry != entry) {
            logger.debug("cache entry is already updated by another thread, so skip reloading. namespace:{}, key:{}", (Object)this.namespace, entry.getKey());
            return;
        }
        CacheEntry[] reloaded = new CacheEntry[1];
        Long[] ttl = new Long[1];
        CacheEntry newEntry = null;
        try {
            newEntry = store.compute(entry.getKey(), (k, e) -> {
                if (e == entry) {
                    return ExecuteContext.executeAs(ServiceRegistry.getRegistry().getService(TenantContextService.class).getTenantContext(this.tenantId), () -> {
                        ExecuteContext ec = ExecuteContext.getCurrentContext();
                        try {
                            ec.setClientId(AUTO_RELOADER_USER_NAME);
                            ec.mdcPut("user", AUTO_RELOADER_USER_NAME);
                            logger.debug("reloading cache entry:{} in namespace:{} ", k, (Object)this.namespace);
                            reloaded[0] = this.reloadFunction.apply(k, (CacheEntry)e);
                            if (reloaded[0] != null) {
                                ttl[0] = reloaded[0].getTimeToLive();
                                if (ttl[0] == null || ttl[0] <= 0L) {
                                    throw new IllegalArgumentException("computeIfAbsentWithAutoReload() must specify TTL on CacheEntry.");
                                }
                                reloaded[0].setTimeToLive(-1L);
                            }
                            CacheEntry cacheEntry = reloaded[0];
                            return cacheEntry;
                        }
                        finally {
                            ec.mdcPut("user", null);
                        }
                    });
                }
                logger.debug("mybe another thread has updated the cache entry: {} in namespace: {}, so skip reloading", k, (Object)this.namespace);
                return e;
            });
        }
        catch (RuntimeException e2) {
            logger.error("failed to reload cache entry: " + String.valueOf(entry.getKey()) + " in namespace: " + this.namespace + ", so cannot update CacheEntry. Attempt to reload after next TTL.", (Throwable)e2);
            CacheService cacheService = ServiceRegistry.getRegistry().getService(CacheService.class);
            cacheService.schedule(ttl[0], new AutoReloader(this.tenantId, this.namespace, newEntry, this.timeToLive, this.reloadFunction));
        }
        if (newEntry != null && newEntry == reloaded[0]) {
            CacheService cacheService = ServiceRegistry.getRegistry().getService(CacheService.class);
            cacheService.schedule(ttl[0], new AutoReloader(this.tenantId, this.namespace, newEntry, ttl[0], this.reloadFunction));
        } else {
            logger.debug("mybe another thread has updated the cache entry: {} in namespace: {}, so skip rescheduling", entry.getKey(), (Object)this.namespace);
        }
    }
}

