/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache.store;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.store.AutoReloader;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStoreFactory;
import org.iplass.mtp.impl.cache.store.event.CacheEventListener;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.spi.ServiceRegistry;

public interface CacheStore {
    public String getNamespace();

    public CacheStoreFactory getFactory();

    public int getSize();

    default public CacheEntry computeIfAbsentWithAutoReload(Object key, BiFunction<Object, CacheEntry, CacheEntry> reloadFunction) {
        CacheEntry[] newEntry = new CacheEntry[1];
        Long[] ttl = new Long[1];
        CacheEntry computed = this.computeIfAbsent(key, k -> {
            newEntry[0] = (CacheEntry)reloadFunction.apply(k, null);
            ttl[0] = newEntry[0].getTimeToLive();
            if (ttl[0] == null || ttl[0] <= 0L) {
                throw new IllegalArgumentException("computeIfAbsentWithAutoReload() must specify TTL on CacheEntry.");
            }
            newEntry[0].setTimeToLive(-1L);
            return newEntry[0];
        });
        if (computed == newEntry[0]) {
            CacheService cacheService = ServiceRegistry.getRegistry().getService(CacheService.class);
            cacheService.schedule(ttl[0], new AutoReloader(ExecuteContext.getCurrentContext().getClientTenantId(), this.getNamespace(), computed, ttl[0], reloadFunction));
        }
        return computed;
    }

    default public CacheEntry computeIfAbsent(Object key, Function<Object, CacheEntry> mappingFunction) {
        CacheEntry newValue;
        CacheEntry v = this.get(key);
        return v == null && (newValue = mappingFunction.apply(key)) != null && (v = this.putIfAbsent(newValue)) == null ? newValue : v;
    }

    default public CacheEntry compute(Object key, BiFunction<Object, CacheEntry, CacheEntry> remappingFunction) {
        CacheEntry newValue;
        CacheEntry oldValue = this.get(key);
        while (true) {
            if ((newValue = remappingFunction.apply(key, oldValue)) == null) {
                if (oldValue != null) {
                    if (this.remove(oldValue)) {
                        return null;
                    }
                    oldValue = this.get(key);
                    continue;
                }
                return null;
            }
            if (oldValue != null) {
                if (this.replace(oldValue, newValue)) {
                    return newValue;
                }
                oldValue = this.get(key);
                continue;
            }
            oldValue = this.putIfAbsent(newValue);
            if (oldValue == null) break;
        }
        return newValue;
    }

    public CacheEntry put(CacheEntry var1, boolean var2);

    public CacheEntry putIfAbsent(CacheEntry var1);

    public CacheEntry get(Object var1);

    public CacheEntry remove(Object var1);

    public boolean remove(CacheEntry var1);

    public CacheEntry replace(CacheEntry var1);

    public boolean replace(CacheEntry var1, CacheEntry var2);

    public void removeAll();

    public List<Object> keySet();

    public CacheEntry getByIndex(int var1, Object var2);

    public List<CacheEntry> getListByIndex(int var1, Object var2);

    public List<CacheEntry> removeByIndex(int var1, Object var2);

    public void addCacheEventListenner(CacheEventListener var1);

    public void removeCacheEventListenner(CacheEventListener var1);

    public List<CacheEventListener> getListeners();

    public String trace();

    public void destroy();
}

