/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache.store.builtin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.iplass.mtp.impl.cache.store.builtin.NullKey;

class FineGrainedLockIndex {
    private ConcurrentMap<Object, IndexValue> indexMap = new ConcurrentHashMap<Object, IndexValue>();
    private int shardSize;
    private boolean fair;

    public FineGrainedLockIndex(int shardSize, boolean fair) {
        this.shardSize = shardSize;
        this.fair = fair;
    }

    public IndexValue getIndexValue(Object value, boolean createIfNone) {
        if (createIfNone) {
            return this.indexMap.computeIfAbsent(value, k -> new IndexValue(this.shardSize, this.fair));
        }
        return (IndexValue)this.indexMap.get(value);
    }

    public int shardIndex(Object key) {
        if (this.shardSize == 1) {
            return 0;
        }
        return Math.abs(key.hashCode() % this.shardSize);
    }

    public void destroy() {
        this.indexMap.clear();
    }

    static class IndexValue {
        private final IndexValueShard[] shards;

        public IndexValue(int shardSize, boolean fair) {
            this.shards = new IndexValueShard[shardSize];
            for (int i = 0; i < shardSize; ++i) {
                this.shards[i] = new IndexValueShard(fair);
            }
        }

        public void add(int index, Object keyRef) {
            this.shards[index].add(keyRef);
        }

        public void remove(int index, Object keyRef) {
            this.shards[index].remove(keyRef);
        }

        public ReentrantLock writeLock(int index) {
            return this.shards[index].lock;
        }

        public int size() {
            if (this.shards.length == 1) {
                Set<Object> r = this.shards[0].refs;
                if (r == null) {
                    return 0;
                }
                return r.size();
            }
            int ret = 0;
            Set<Object> r = null;
            for (int i = 0; i < this.shards.length; ++i) {
                r = this.shards[i].refs;
                if (r == null) continue;
                ret += r.size();
            }
            return ret;
        }

        public List<Object> refs() {
            NullKey nullRef = null;
            ArrayList<Object> refsAll = new ArrayList<Object>();
            Set<Object> r = null;
            for (int i = 0; i < this.shards.length; ++i) {
                r = this.shards[i].refs;
                if (r == null || r.size() <= 0) continue;
                for (Object k : r) {
                    if (k instanceof NullKey) {
                        nullRef = (NullKey)k;
                        continue;
                    }
                    refsAll.add(k);
                }
            }
            if (refsAll.isEmpty() && nullRef != null) {
                refsAll.add(nullRef);
            }
            return refsAll;
        }

        public Object firstRef() {
            NullKey nullRef = null;
            Set<Object> r = null;
            for (int i = 0; i < this.shards.length; ++i) {
                r = this.shards[i].refs;
                if (r == null || r.size() <= 0) continue;
                for (Object k : r) {
                    if (k instanceof NullKey) {
                        nullRef = (NullKey)k;
                        continue;
                    }
                    return k;
                }
            }
            if (nullRef != null) {
                return nullRef;
            }
            return null;
        }
    }

    private static class IndexValueShard {
        private final ReentrantLock lock;
        private volatile Set<Object> refs;

        IndexValueShard(boolean fair) {
            this.lock = new ReentrantLock(fair);
        }

        void add(Object keyRef) {
            Set<Object> r = this.refs;
            if (r == null) {
                r = new HashSet<Object>();
            } else {
                HashSet<Object> newRefs = new HashSet<Object>();
                for (Object ref : r) {
                    if (ref instanceof NullKey) continue;
                    newRefs.add(ref);
                }
                r = newRefs;
            }
            r.add(keyRef);
            this.refs = r;
        }

        void remove(Object keyRef) {
            Set<Object> r = this.refs;
            if (r != null) {
                r = new HashSet<Object>(r);
                r.remove(keyRef);
                if (r.size() == 0) {
                    r = null;
                } else if (r.size() == 1 && r.iterator().next() instanceof NullKey) {
                    r = null;
                }
            }
            this.refs = r;
        }
    }
}

