/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache.store.builtin;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStoreFactory;
import org.iplass.mtp.impl.cache.store.TimeToLiveCalculator;
import org.iplass.mtp.impl.cache.store.builtin.FineGrainedLockIndex;
import org.iplass.mtp.impl.cache.store.builtin.FineGrainedLockIndexConfig;
import org.iplass.mtp.impl.cache.store.builtin.FineGrainedLockState;
import org.iplass.mtp.impl.cache.store.builtin.NullKey;
import org.iplass.mtp.impl.cache.store.builtin.SimpleCacheStoreBase;
import org.iplass.mtp.impl.cache.store.builtin.SimpleCacheStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FineGrainedLockIndexedConcurrentHashMapCacheStore
extends SimpleCacheStoreBase {
    private static Logger logger = LoggerFactory.getLogger(FineGrainedLockIndexedConcurrentHashMapCacheStore.class);
    private final Cache<Object, CacheEntry> cache;
    private TimeToLiveCalculator timeToLiveCalculator;
    private final FineGrainedLockIndex[] indexCache;

    public FineGrainedLockIndexedConcurrentHashMapCacheStore(String namespace, CacheStoreFactory factory, int initialCapacity, TimeToLiveCalculator timeToLiveCalculator, int size, int indexCount, List<FineGrainedLockIndexConfig> indexConfig) {
        super(namespace, true, factory);
        this.timeToLiveCalculator = timeToLiveCalculator;
        this.cache = size > 0 ? Caffeine.newBuilder().maximumSize((long)size).initialCapacity(initialCapacity).removalListener((key, value, cause) -> {
            if (cause.wasEvicted()) {
                this.removeFromIndex((CacheEntry)value, false);
                this.notifyRemoved((CacheEntry)value);
            }
        }).build() : Caffeine.newBuilder().initialCapacity(initialCapacity).build();
        this.indexCache = new FineGrainedLockIndex[indexCount];
        for (int i = 0; i < this.indexCache.length; ++i) {
            this.indexCache[i] = indexConfig != null && i < indexConfig.size() ? indexConfig.get(i).build() : new FineGrainedLockIndexConfig().build();
        }
    }

    private void removeFromIndex(CacheEntry entry, boolean loose) {
        try (FineGrainedLockState fgls = new FineGrainedLockState(null, entry, this.indexCache);){
            fgls.maintain();
        }
    }

    @Override
    protected void removeInvalidEntry() {
        List<Object> keys = this.keySet();
        if (keys != null) {
            for (Object k : keys) {
                this.get(k);
            }
        }
    }

    @Override
    public CacheEntry get(Object key) {
        if (key == null) {
            return null;
        }
        CacheEntry e = (CacheEntry)this.cache.getIfPresent(key);
        if (!SimpleCacheStoreFactory.isStillAliveOrNull(e)) {
            if (logger.isDebugEnabled()) {
                logger.debug("invalidate " + String.valueOf(e) + ", cause timeToLive");
            }
            this.remove(e);
            return null;
        }
        return e;
    }

    @Override
    public CacheEntry put(CacheEntry entry, boolean isClean) {
        this.timeToLiveCalculator.set(entry);
        if (entry.getKey() instanceof NullKey) {
            try (FineGrainedLockState fgls = new FineGrainedLockState(entry, null, this.indexCache);){
                fgls.maintain();
            }
            return null;
        }
        CacheEntry[] previous = new CacheEntry[1];
        CacheEntry putted = this.cache.asMap().compute(entry.getKey(), (? super K k, ? super V v) -> {
            previous[0] = v;
            try (FineGrainedLockState fgls = new FineGrainedLockState(entry, (CacheEntry)v, this.indexCache);){
                fgls.maintain();
            }
            return entry;
        });
        if (previous[0] == null) {
            this.notifyPut(entry);
        } else {
            this.notifyUpdated(previous[0], putted);
        }
        return previous[0];
    }

    @Override
    public CacheEntry remove(Object key) {
        CacheEntry[] previous = new CacheEntry[1];
        this.cache.asMap().compute(key, (? super K k, ? super V v) -> {
            previous[0] = v;
            if (v != null) {
                try (FineGrainedLockState fgls = new FineGrainedLockState(null, (CacheEntry)v, this.indexCache);){
                    fgls.maintain();
                }
            }
            return null;
        });
        if (previous[0] != null) {
            this.notifyRemoved(previous[0]);
        }
        return previous[0];
    }

    @Override
    public void removeAll() {
        for (Object k : this.keySet()) {
            this.remove(k);
        }
    }

    @Override
    public CacheEntry putIfAbsent(CacheEntry entry) {
        if (entry.getKey() instanceof NullKey) {
            throw new UnsupportedOperationException("PutIfAbsent with Null Entry(NullKey) is Unsupported.");
        }
        this.timeToLiveCalculator.set(entry);
        CacheEntry[] previous = new CacheEntry[1];
        this.cache.asMap().compute(entry.getKey(), (? super K k, ? super V v) -> {
            previous[0] = v;
            if (v == null) {
                try (FineGrainedLockState fgls = new FineGrainedLockState(entry, (CacheEntry)v, this.indexCache);){
                    fgls.maintain();
                }
                return entry;
            }
            return v;
        });
        if (previous[0] == null) {
            this.notifyPut(entry);
        }
        return previous[0];
    }

    @Override
    public CacheEntry computeIfAbsent(Object key, Function<Object, CacheEntry> mappingFunction) {
        if (key instanceof NullKey) {
            throw new UnsupportedOperationException("computeIfAbsent with Null Entry(NullKey) is Unsupported.");
        }
        boolean[] computed = new boolean[1];
        CacheEntry entry = this.cache.asMap().computeIfAbsent(key, (? super K k) -> {
            computed[0] = true;
            CacheEntry v = (CacheEntry)mappingFunction.apply(k);
            if (v != null) {
                this.timeToLiveCalculator.set(v);
                try (FineGrainedLockState fgls = new FineGrainedLockState(v, null, this.indexCache);){
                    fgls.maintain();
                }
            }
            return v;
        });
        if (computed[0] && entry != null) {
            this.notifyPut(entry);
        }
        return entry;
    }

    @Override
    public CacheEntry compute(Object key, BiFunction<Object, CacheEntry, CacheEntry> remappingFunction) {
        CacheEntry[] old = new CacheEntry[1];
        CacheEntry entry = this.cache.asMap().compute(key, (? super K k, ? super V v) -> {
            old[0] = v;
            CacheEntry newV = (CacheEntry)remappingFunction.apply(k, (CacheEntry)v);
            if (v != newV) {
                if (newV != null) {
                    this.timeToLiveCalculator.set(newV);
                }
                try (FineGrainedLockState fgls = new FineGrainedLockState(newV, (CacheEntry)v, this.indexCache);){
                    fgls.maintain();
                }
            }
            return newV;
        });
        if (entry != null) {
            if (old[0] == null) {
                this.notifyPut(entry);
            } else {
                this.notifyUpdated(old[0], entry);
            }
        } else if (old[0] != null) {
            this.notifyRemoved(entry);
        }
        return entry;
    }

    @Override
    public boolean remove(CacheEntry entry) {
        CacheEntry[] previous = new CacheEntry[1];
        boolean[] res = new boolean[1];
        this.cache.asMap().computeIfPresent(entry.getKey(), (k, v) -> {
            previous[0] = v;
            if (entry.equals(v)) {
                try (FineGrainedLockState fgls = new FineGrainedLockState(null, (CacheEntry)v, this.indexCache);){
                    fgls.maintain();
                }
                res[0] = true;
                return null;
            }
            return v;
        });
        if (res[0]) {
            this.notifyRemoved(previous[0]);
        }
        return res[0];
    }

    @Override
    public CacheEntry replace(CacheEntry entry) {
        this.timeToLiveCalculator.set(entry);
        CacheEntry[] previous = new CacheEntry[1];
        this.cache.asMap().computeIfPresent(entry.getKey(), (k, v) -> {
            previous[0] = v;
            try (FineGrainedLockState fgls = new FineGrainedLockState(entry, (CacheEntry)v, this.indexCache);){
                fgls.maintain();
            }
            return entry;
        });
        if (previous[0] != null) {
            this.notifyUpdated(previous[0], entry);
        }
        return previous[0];
    }

    @Override
    public boolean replace(CacheEntry oldEntry, CacheEntry newEntry) {
        if (!oldEntry.getKey().equals(newEntry.getKey())) {
            throw new IllegalArgumentException("oldEntry key not equals newEntryKey");
        }
        this.timeToLiveCalculator.set(newEntry);
        CacheEntry[] previous = new CacheEntry[1];
        boolean[] res = new boolean[1];
        this.cache.asMap().computeIfPresent(newEntry.getKey(), (k, v) -> {
            previous[0] = v;
            if (oldEntry.equals(v)) {
                try (FineGrainedLockState fgls = new FineGrainedLockState(newEntry, (CacheEntry)v, this.indexCache);){
                    fgls.maintain();
                }
                res[0] = true;
                return newEntry;
            }
            return v;
        });
        if (res[0]) {
            this.notifyUpdated(previous[0], newEntry);
        }
        return res[0];
    }

    @Override
    public List<Object> keySet() {
        return new ArrayList<Object>(this.cache.asMap().keySet());
    }

    @Override
    public CacheEntry getByIndex(int indexKey, Object indexValue) {
        FineGrainedLockIndex.IndexValue iv = this.indexCache[indexKey].getIndexValue(indexValue, false);
        if (iv == null) {
            return null;
        }
        Object key = iv.firstRef();
        if (key == null) {
            return null;
        }
        if (key instanceof NullKey) {
            Object[] indexValues = new Object[this.indexCache.length];
            indexValues[indexKey] = indexValue;
            return new CacheEntry(key, (Object)null, Long.MIN_VALUE, indexValues);
        }
        return this.get(key);
    }

    @Override
    public List<CacheEntry> getListByIndex(int indexKey, Object indexValue) {
        FineGrainedLockIndex.IndexValue iv = this.indexCache[indexKey].getIndexValue(indexValue, false);
        if (iv == null) {
            return Collections.emptyList();
        }
        List<Object> keys = iv.refs();
        if (keys.size() == 0) {
            return Collections.emptyList();
        }
        if (keys.size() == 1 && keys.get(0) instanceof NullKey) {
            Object[] indexValues = new Object[this.indexCache.length];
            indexValues[indexKey] = indexValue;
            return Collections.singletonList(new CacheEntry(keys.get(0), (Object)null, Long.MIN_VALUE, indexValues));
        }
        ArrayList<CacheEntry> result = new ArrayList<CacheEntry>(keys.size());
        for (Object k : keys) {
            CacheEntry e = this.get(k);
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public List<CacheEntry> removeByIndex(int indexKey, Object indexValue) {
        FineGrainedLockIndex.IndexValue iv = this.indexCache[indexKey].getIndexValue(indexValue, false);
        if (iv == null) {
            return Collections.emptyList();
        }
        List<Object> keys = iv.refs();
        if (keys.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<CacheEntry> result = new ArrayList<CacheEntry>(keys.size());
        for (Object k : keys) {
            CacheEntry e;
            if (k instanceof NullKey || (e = this.remove(k)) == null) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    protected void removeNullEntry(NullKey key) {
    }

    @Override
    public int getSize() {
        return (int)this.cache.estimatedSize();
    }

    @Override
    public String trace() {
        StringBuilder builder = new StringBuilder();
        builder.append("-----------------------------------");
        builder.append("\nCacheStore Info");
        builder.append("\nCacheStore:" + String.valueOf(this));
        builder.append(super.baseTrace());
        ConcurrentMap map = this.cache.asMap();
        builder.append("\n\tcache entry size:" + map.size());
        for (Map.Entry entry : map.entrySet()) {
            builder.append("\n\t\t" + String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue()));
        }
        builder.append("\n\tindexCache size:" + this.indexCache.length);
        builder.append("\n-----------------------------------");
        return builder.toString();
    }

    @Override
    public void destroy() {
        this.cache.asMap().clear();
        this.cache.invalidateAll();
        this.cache.cleanUp();
        for (int i = 0; i < this.indexCache.length; ++i) {
            this.indexCache[i].destroy();
        }
    }
}

