/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache.store.builtin;

import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStoreFactory;
import org.iplass.mtp.impl.cache.store.builtin.NullKey;
import org.iplass.mtp.impl.cache.store.builtin.SimpleCacheStoreBase;

public final class MapBaseCacheStore
extends SimpleCacheStoreBase {
    private Map<Object, CacheEntry> cache;
    private HashMap<Object, Object>[] indexCache;
    private int indexCount;
    private long timeToLive;

    public MapBaseCacheStore(String namespace, Map<Object, CacheEntry> cache, int indexCount, long timeToLive, CacheStoreFactory factory) {
        super(namespace, false, factory);
        this.indexCount = indexCount;
        this.timeToLive = timeToLive;
        this.cache = cache;
        if (indexCount > 0) {
            this.indexCache = new HashMap[indexCount];
            for (int i = 0; i < this.indexCache.length; ++i) {
                this.indexCache[i] = new HashMap();
            }
        }
    }

    private boolean isStillAliveOrNull(CacheEntry e) {
        if (e == null) {
            return true;
        }
        if (this.timeToLive <= 0L) {
            return true;
        }
        return System.currentTimeMillis() - e.getCreationTime() <= this.timeToLive;
    }

    @Override
    protected void removeInvalidEntry() {
        List<Object> keys = this.keySet();
        if (keys != null) {
            for (Object k : keys) {
                this.get(k);
            }
        }
    }

    @Override
    public CacheEntry get(Object key) {
        if (key == null) {
            return null;
        }
        CacheEntry e = this.cache.get(key);
        if (!this.isStillAliveOrNull(e)) {
            this.remove(e);
            return null;
        }
        return e;
    }

    protected void addToIndex(CacheEntry entry) {
        for (int i = 0; i < this.indexCount; ++i) {
            Object ikey = entry.getIndexValue(i);
            Object key = entry.getKey();
            if (ikey instanceof Object[]) {
                Object[] ikeyArray = (Object[])ikey;
                for (int j = 0; j < ikeyArray.length; ++j) {
                    if (ikeyArray[j] == null) continue;
                    Object ival = this.margeVal(this.indexCache[i].get(ikeyArray[j]), key);
                    this.indexCache[i].put(ikeyArray[j], ival);
                }
                continue;
            }
            if (ikey == null) continue;
            Object ival = this.margeVal(this.indexCache[i].get(ikey), key);
            this.indexCache[i].put(ikey, ival);
        }
    }

    protected void removeFromIndex(CacheEntry entry, boolean loose) {
        for (int i = 0; i < this.indexCount; ++i) {
            Object ikey = entry.getIndexValue(i);
            if (ikey instanceof Object[]) {
                Object[] ikeyArray = (Object[])ikey;
                for (int j = 0; j < ikeyArray.length; ++j) {
                    if (ikeyArray[j] == null) continue;
                    Object ival = this.subtractVal(this.indexCache[i].get(ikeyArray[j]), entry.getKey(), loose);
                    this.indexCache[i].put(ikeyArray[j], ival);
                }
                continue;
            }
            if (ikey == null) continue;
            Object ival = this.subtractVal(this.indexCache[i].get(ikey), entry.getKey(), loose);
            this.indexCache[i].put(ikey, ival);
        }
    }

    @Override
    public CacheEntry put(CacheEntry entry, boolean isClean) {
        CacheEntry previous = this.cache.put(entry.getKey(), entry);
        if (previous != null) {
            this.removeFromIndex(previous, false);
        }
        this.addToIndex(entry);
        if (previous == null) {
            this.notifyPut(entry);
        } else {
            this.notifyUpdated(previous, entry);
        }
        return previous;
    }

    @Override
    public CacheEntry remove(Object key) {
        if (key == null) {
            return null;
        }
        CacheEntry previous = this.cache.remove(key);
        if (previous != null) {
            this.removeFromIndex(previous, false);
            this.notifyRemoved(previous);
        }
        return previous;
    }

    @Override
    public void removeAll() {
        if (this.hasListener()) {
            for (Object k : this.keySet()) {
                this.remove(k);
            }
        } else {
            this.cache.clear();
            for (int i = 0; i < this.indexCount; ++i) {
                this.indexCache[i].clear();
            }
        }
    }

    @Override
    public CacheEntry putIfAbsent(CacheEntry entry) {
        if (entry.getKey() == null) {
            this.addToIndex(entry);
            return null;
        }
        if (!this.cache.containsKey(entry.getKey())) {
            CacheEntry previous = this.cache.put(entry.getKey(), entry);
            this.addToIndex(entry);
            this.notifyPut(entry);
            return previous;
        }
        return this.cache.get(entry.getKey());
    }

    @Override
    public boolean remove(CacheEntry entry) {
        if (this.cache.containsKey(entry.getKey()) && this.cache.get(entry.getKey()).equals(entry)) {
            this.cache.remove(entry.getKey());
            this.removeFromIndex(entry, false);
            this.notifyRemoved(entry);
            return true;
        }
        return false;
    }

    @Override
    public CacheEntry replace(CacheEntry entry) {
        if (this.cache.containsKey(entry.getKey())) {
            CacheEntry oldValue = this.cache.put(entry.getKey(), entry);
            this.removeFromIndex(oldValue, false);
            this.addToIndex(entry);
            this.notifyUpdated(oldValue, entry);
            return oldValue;
        }
        return null;
    }

    @Override
    public boolean replace(CacheEntry oldEntry, CacheEntry newEntry) {
        if (!oldEntry.getKey().equals(newEntry.getKey())) {
            throw new IllegalArgumentException("oldEntry key not equals newEntryKey");
        }
        if (this.cache.containsKey(newEntry.getKey()) && this.cache.get(newEntry.getKey()).equals(oldEntry)) {
            CacheEntry previous = this.cache.put(newEntry.getKey(), newEntry);
            this.removeFromIndex(previous, false);
            this.addToIndex(newEntry);
            this.notifyUpdated(previous, newEntry);
            return true;
        }
        return false;
    }

    @Override
    public List<Object> keySet() {
        return new ArrayList<Object>(this.cache.keySet());
    }

    @Override
    public CacheEntry getByIndex(int indexKey, Object indexValue) {
        Object key = this.indexCache[indexKey].get(indexValue);
        if (key == null) {
            return null;
        }
        if (key instanceof Object[]) {
            Object firstKey = ((Object[])key)[0];
            return this.get(firstKey);
        }
        return this.get(key);
    }

    @Override
    public List<CacheEntry> getListByIndex(int indexKey, Object indexValue) {
        Object key = this.indexCache[indexKey].get(indexValue);
        if (key == null) {
            return Collections.emptyList();
        }
        if (key instanceof Object[]) {
            Object[] keyArray = (Object[])key;
            ArrayList<CacheEntry> result = new ArrayList<CacheEntry>(keyArray.length);
            for (int i = 0; i < keyArray.length; ++i) {
                CacheEntry entry = this.get(keyArray[i]);
                if (entry == null) continue;
                result.add(entry);
            }
            return result;
        }
        CacheEntry entry = this.get(key);
        if (entry == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(entry);
    }

    @Override
    public List<CacheEntry> removeByIndex(int indexKey, Object indexValue) {
        List<CacheEntry> list = this.getListByIndex(indexKey, indexValue);
        if (list != null) {
            for (CacheEntry e : list) {
                this.remove(e.getKey());
            }
        }
        return list;
    }

    @Override
    protected void removeNullEntry(NullKey key) {
        this.cache.remove(key);
    }

    @Override
    public int getSize() {
        return this.cache.size();
    }

    @Override
    public String trace() {
        StringBuilder builder = new StringBuilder();
        builder.append("-----------------------------------");
        builder.append("\nCacheStore Info");
        builder.append("\nCacheStore:" + String.valueOf(this));
        builder.append(super.baseTrace());
        builder.append("\n\tindexCount:" + this.indexCount);
        builder.append("\n\ttimeToLive:" + this.timeToLive);
        builder.append("\n\tcache entry size:" + this.cache.size());
        for (Map.Entry<Object, CacheEntry> entry : this.cache.entrySet()) {
            builder.append("\n\t\t" + String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue()));
        }
        if (this.indexCache != null) {
            builder.append("\n\tindexCache size:" + this.indexCache.length);
            for (int i = 0; i < this.indexCache.length; ++i) {
                builder.append("\n\tindexCache[" + i + "] entry size:" + this.indexCache[i].size());
                for (Map.Entry<Object, Object> entry : this.indexCache[i].entrySet()) {
                    if (entry.getValue() instanceof Object[]) {
                        builder.append("\n\t\t" + String.valueOf(entry.getKey()) + "=" + Arrays.toString((Object[])entry.getValue()));
                        continue;
                    }
                    builder.append("\n\t\t" + String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue()));
                }
            }
        } else {
            builder.append((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\n\tindexCache :null"})));
        }
        builder.append("\n-----------------------------------");
        return builder.toString();
    }

    @Override
    public void destroy() {
        this.cache.clear();
        if (this.indexCache != null) {
            for (int i = 0; i < this.indexCache.length; ++i) {
                this.indexCache[i] = null;
            }
        }
        this.cache = null;
    }
}

