/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache.store.builtin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.cache.store.CacheStoreFactory;
import org.iplass.mtp.impl.cache.store.builtin.NullKey;
import org.iplass.mtp.impl.cache.store.event.CacheCreateEvent;
import org.iplass.mtp.impl.cache.store.event.CacheEventListener;
import org.iplass.mtp.impl.cache.store.event.CacheInvalidateEvent;
import org.iplass.mtp.impl.cache.store.event.CacheRemoveEvent;
import org.iplass.mtp.impl.cache.store.event.CacheUpdateEvent;

public abstract class SimpleCacheStoreBase
implements CacheStore {
    private String namespace;
    private List<CacheEventListener> listeners;
    private boolean multithreaded;
    private CacheStoreFactory factory;

    public SimpleCacheStoreBase(String namespace, boolean multithreaded, CacheStoreFactory factory) {
        this.namespace = namespace;
        this.multithreaded = multithreaded;
        this.factory = factory;
        if (multithreaded) {
            this.listeners = new CopyOnWriteArrayList<CacheEventListener>();
        }
    }

    @Override
    public CacheStoreFactory getFactory() {
        return this.factory;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    protected void notifyRemoved(CacheEntry entry) {
        if (this.listeners != null) {
            CacheRemoveEvent e = new CacheRemoveEvent(entry);
            for (CacheEventListener l : this.listeners) {
                l.removed(e);
            }
        }
    }

    protected void notifyPut(CacheEntry entry) {
        if (this.listeners != null) {
            CacheCreateEvent e = new CacheCreateEvent(entry);
            for (CacheEventListener l : this.listeners) {
                l.created(e);
            }
        }
    }

    protected void notifyUpdated(CacheEntry preEntry, CacheEntry entry) {
        if (this.listeners != null) {
            CacheUpdateEvent e = new CacheUpdateEvent(preEntry, entry);
            for (CacheEventListener l : this.listeners) {
                l.updated(e);
            }
        }
    }

    protected void notifyInvalidated(CacheEntry entry) {
        if (this.listeners != null) {
            CacheInvalidateEvent e = new CacheInvalidateEvent(entry);
            for (CacheEventListener l : this.listeners) {
                l.invalidated(e);
            }
        }
    }

    protected boolean hasListener() {
        if (this.listeners == null) {
            return false;
        }
        return this.listeners.size() > 0;
    }

    @Override
    public void addCacheEventListenner(CacheEventListener listener) {
        if (!this.multithreaded && this.listeners == null) {
            this.listeners = new ArrayList<CacheEventListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeCacheEventListenner(CacheEventListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public List<CacheEventListener> getListeners() {
        if (this.listeners == null) {
            return Collections.emptyList();
        }
        return this.listeners;
    }

    protected abstract void removeInvalidEntry();

    protected abstract void removeNullEntry(NullKey var1);

    Object margeVal(Object current, Object added) {
        if (added == null) {
            added = new NullKey();
        }
        if (current == null) {
            return added;
        }
        if (current instanceof NullKey) {
            this.removeNullEntry((NullKey)current);
            return added;
        }
        if (current instanceof Object[]) {
            Object[] newVal = new Object[((Object[])current).length + 1];
            System.arraycopy(current, 0, newVal, 0, newVal.length - 1);
            newVal[newVal.length - 1] = added;
            return newVal;
        }
        return new Object[]{current, added};
    }

    Object subtractVal(Object current, Object removed, boolean loose) {
        if (current == null) {
            return null;
        }
        if (current instanceof Object[]) {
            Object[] ca = (Object[])current;
            ArrayList<Object> ret = new ArrayList<Object>(ca.length);
            for (int i = 0; i < ca.length; ++i) {
                if (ca[i].equals(removed)) continue;
                ret.add(ca[i]);
            }
            if (ret.size() == 0) {
                return null;
            }
            if (ret.size() == 1) {
                return ret.get(0);
            }
            return ret.toArray();
        }
        if (current.equals(removed)) {
            return null;
        }
        if (removed instanceof NullKey) {
            return current;
        }
        if (loose) {
            return current;
        }
        throw new IllegalStateException("illegal cache state... toRemove:" + String.valueOf(removed) + " current:" + String.valueOf(current));
    }

    protected String baseTrace() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n\tnamespace:" + this.namespace);
        builder.append("\n\tmultithreaded:" + this.multithreaded);
        return builder.toString();
    }
}

