/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache.store.builtin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.iplass.mtp.impl.async.AsyncTaskService;
import org.iplass.mtp.impl.cache.store.CacheHandler;
import org.iplass.mtp.impl.cache.store.CacheHandlerTask;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.cache.store.builtin.SimpleLocalCacheContext;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.spi.ServiceRegistry;

public class SimpleLocalCacheHandler
implements CacheHandler {
    private int concurrencyLevel;
    private CacheStore cs;

    public SimpleLocalCacheHandler(CacheStore cs, int concurrencyLevel) {
        this.cs = cs;
        this.concurrencyLevel = concurrencyLevel;
    }

    @SafeVarargs
    public final <K, V, R> List<Future<R>> executeParallel(CacheHandlerTask<K, V, R> handler, K ... inputKeys) {
        ArrayList<Future<R>> ret = new ArrayList<Future<R>>();
        if (inputKeys == null || inputKeys.length == 0) {
            SimpleLocalCacheContext cc = new SimpleLocalCacheContext(this.cs);
            handler.setContext(cc, Collections.emptySet());
            try {
                Object r = handler.call();
                ret.add(new SyncFuture(r, null));
            }
            catch (Exception e) {
                ret.add(new SyncFuture<Object>(null, e));
            }
        } else if (this.concurrencyLevel > 1) {
            AsyncTaskService atc = ServiceRegistry.getRegistry().getService(AsyncTaskService.class);
            for (int i = 0; i < this.concurrencyLevel; ++i) {
                final CacheHandlerTask<K, V, R> copyTask = ObjectUtil.deepCopy(handler);
                final SimpleLocalCacheContext cc = new SimpleLocalCacheContext(this.cs);
                final HashSet<K> keys = new HashSet<K>();
                for (int j = i; j < inputKeys.length; j += this.concurrencyLevel) {
                    keys.add(inputKeys[j]);
                }
                if (keys.size() <= 0) continue;
                Future r = atc.execute(new Callable<R>(){

                    @Override
                    public R call() throws Exception {
                        copyTask.setContext(cc, keys);
                        return copyTask.call();
                    }
                });
                ret.add(r);
            }
        } else {
            HashSet<K> allKeys = new HashSet<K>(Arrays.asList(inputKeys));
            SimpleLocalCacheContext cc = new SimpleLocalCacheContext(this.cs);
            handler.setContext(cc, allKeys);
            try {
                Object r = handler.call();
                ret.add(new SyncFuture(r, null));
            }
            catch (Exception e) {
                ret.add(new SyncFuture<Object>(null, e));
            }
        }
        return ret;
    }

    private static class SyncFuture<R>
    implements Future<R> {
        private R result;
        private Exception e;

        private SyncFuture(R result, Exception e) {
            this.result = result;
            this.e = e;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public R get() throws InterruptedException, ExecutionException {
            if (this.e != null) {
                throw new ExecutionException(this.e);
            }
            return this.result;
        }

        @Override
        public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

