/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache.store.builtin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheHandler;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.cache.store.CacheStoreFactory;
import org.iplass.mtp.impl.cache.store.builtin.AbstractBuiltinCacheStoreFactory;
import org.iplass.mtp.impl.cache.store.builtin.MapBaseCacheStore;
import org.iplass.mtp.impl.cache.store.builtin.NullCacheStore;
import org.iplass.mtp.impl.cache.store.builtin.SimpleLocalCacheHandler;
import org.iplass.mtp.impl.cache.store.event.CacheEventListener;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionListener;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.transaction.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionLocalCacheStoreFactory
extends AbstractBuiltinCacheStoreFactory {
    private static final String CACHE_PREFIX = "org.iplass.mtp.cache.";
    private static final NullCacheStore NULL_CACHE = new NullCacheStore("", null);
    private static Logger logger = LoggerFactory.getLogger(TransactionLocalCacheStoreFactory.class);
    private int initialCapacity = 16;
    private float loadFactor = 0.75f;
    private CacheStoreFactory backendStore;

    public CacheStoreFactory getBackendStore() {
        return this.backendStore;
    }

    public void setBackendStore(CacheStoreFactory backendStore) {
        backendStore.setIndexCount(this.getIndexCount());
        this.backendStore = backendStore;
    }

    @Override
    public void setIndexCount(int indexCount) {
        super.setIndexCount(indexCount);
        if (this.backendStore != null) {
            this.backendStore.setIndexCount(indexCount);
        }
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(float loadFactor) {
        this.loadFactor = loadFactor;
    }

    @Override
    public CacheStore createCacheStore(String namespace) {
        return new TransactionLocalCacheStore(namespace);
    }

    @Override
    public boolean canUseForLocalCache() {
        return false;
    }

    @Override
    public boolean supportsIndex() {
        return true;
    }

    @Override
    public CacheHandler createCacheHandler(CacheStore store) {
        return new SimpleLocalCacheHandler(store, this.getConcurrencyLevelOfCacheHandler());
    }

    @Override
    public CacheStoreFactory getLowerLevel() {
        return this.backendStore;
    }

    public class TransactionLocalCacheStore
    implements CacheStore {
        private final String namespace;
        private final CacheStore backendCacheStore;

        TransactionLocalCacheStore(String namespace) {
            CacheStore cs;
            this.namespace = namespace;
            this.backendCacheStore = TransactionLocalCacheStoreFactory.this.backendStore != null ? (cs = TransactionLocalCacheStoreFactory.this.backendStore.createCacheStore(namespace)) : null;
        }

        public CacheStore getBackendCacheStore() {
            return this.backendCacheStore;
        }

        public void reloadFromBackendStore(Object key) {
            this.getStore().remove(key);
            this.get(key);
        }

        private CacheStore getStore() {
            Transaction t = Transaction.getCurrent();
            if (t != null && t.getStatus() == TransactionStatus.ACTIVE) {
                CacheStore store = (CacheStore)t.getAttribute(TransactionLocalCacheStoreFactory.CACHE_PREFIX + this.namespace);
                if (store == null) {
                    store = new MapBaseCacheStore(this.namespace, new HashMap<Object, CacheEntry>(TransactionLocalCacheStoreFactory.this.initialCapacity, TransactionLocalCacheStoreFactory.this.loadFactor), TransactionLocalCacheStoreFactory.this.getIndexCount(), -1L, TransactionLocalCacheStoreFactory.this);
                    t.setAttribute(TransactionLocalCacheStoreFactory.CACHE_PREFIX + this.namespace, store);
                }
                return store;
            }
            return NULL_CACHE;
        }

        @Override
        public CacheEntry put(final CacheEntry entry, boolean isClean) {
            if (logger.isTraceEnabled()) {
                logger.trace("put local cache!key=" + String.valueOf(entry.getKey()) + ",version=" + entry.getVersion() + ",value=" + String.valueOf(entry.getValue()) + ",clean=" + isClean);
            }
            CacheEntry localPrevious = this.getStore().put(entry, isClean);
            if (this.backendCacheStore == null) {
                return localPrevious;
            }
            if (isClean) {
                CacheEntry backendPrevious = this.backendCacheStore.put(entry, isClean);
                if (localPrevious != null) {
                    return localPrevious;
                }
                return backendPrevious;
            }
            final CacheEntry previous = entry.getKey() != null ? (localPrevious == null ? this.backendCacheStore.get(entry.getKey()) : (localPrevious instanceof RemovedCacheEntry ? null : localPrevious)) : null;
            this.addOrRunTransactionListener(new TransactionListener(){

                @Override
                public void afterRollback(Transaction t) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void afterCommit(Transaction t) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("put shared cache!key=" + String.valueOf(entry.getKey()) + ",version=" + entry.getVersion() + ",value=" + String.valueOf(entry.getValue()));
                    }
                    boolean isConflict = true;
                    try {
                        if (previous == null) {
                            CacheEntry sheredPrevious = TransactionLocalCacheStore.this.backendCacheStore.putIfAbsent(entry);
                            if (sheredPrevious == null) {
                                isConflict = false;
                            } else if (logger.isDebugEnabled()) {
                                logger.debug("maybe another Thread Updated newly version:" + sheredPrevious.getVersion() + ". so markInvalid CacheEntry:" + String.valueOf(entry.getKey()) + " version:" + entry.getVersion());
                            }
                        } else if (TransactionLocalCacheStore.this.backendCacheStore.replace(previous, entry)) {
                            isConflict = false;
                        } else {
                            boolean isLoop = true;
                            while (isLoop) {
                                CacheEntry current = TransactionLocalCacheStore.this.backendCacheStore.get(entry.getKey());
                                if (current == null) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("CacheEntry:" + String.valueOf(entry.getKey()) + " not found. maybe removed. so markInvalid.");
                                    }
                                    isLoop = false;
                                    continue;
                                }
                                if (logger.isDebugEnabled()) {
                                    logger.debug("maybe another Thread Updated newly version:" + current.getVersion() + ". so markInvalid CacheEntry:" + String.valueOf(entry.getKey()) + " version:" + entry.getVersion());
                                }
                                isLoop = false;
                            }
                        }
                    }
                    finally {
                        if (isConflict) {
                            try {
                                TransactionLocalCacheStore.this.backendCacheStore.remove(entry.getKey());
                            }
                            catch (RuntimeException e) {
                                logger.error("cache may be illegal state... cause:" + String.valueOf(e), (Throwable)e);
                            }
                        }
                    }
                }
            });
            return previous;
        }

        @Override
        public CacheEntry computeIfAbsent(final Object key, final Function<Object, CacheEntry> mappingFunction) {
            CacheEntry ce = this.getStore().get(key);
            if (ce == null) {
                CacheEntry backendEntry = this.backendCacheStore.computeIfAbsent(key, mappingFunction);
                if (backendEntry != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("put local cache!key=" + String.valueOf(backendEntry.getKey()) + ",version=" + backendEntry.getVersion() + ",value=" + String.valueOf(backendEntry.getValue()));
                    }
                    this.getStore().put(backendEntry, false);
                }
                return backendEntry;
            }
            if (ce != null && !(ce instanceof RemovedCacheEntry)) {
                return ce;
            }
            final CacheEntry backendEntry = this.backendCacheStore.get(key);
            final CacheEntry computedLocal = mappingFunction.apply(key);
            if (computedLocal != null) {
                this.getStore().put(computedLocal, false);
            }
            this.addOrRunTransactionListener(new TransactionListener(){

                @Override
                public void afterRollback(Transaction t) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void afterCommit(Transaction t) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("cas shared cache!key=" + String.valueOf(key) + ",mappingFunction=" + String.valueOf(mappingFunction));
                    }
                    boolean isConflict = true;
                    try {
                        if (backendEntry == null) {
                            CacheEntry sheredPrevious = TransactionLocalCacheStore.this.backendCacheStore.putIfAbsent(computedLocal);
                            if (sheredPrevious == null) {
                                isConflict = false;
                            } else if (logger.isDebugEnabled()) {
                                logger.debug("maybe another Thread Updated newly version:" + sheredPrevious.getVersion() + ".  so markInvalid CacheEntry:" + String.valueOf(key));
                            }
                        } else if (computedLocal == null) {
                            TransactionLocalCacheStore.this.backendCacheStore.remove(key);
                            isConflict = false;
                        } else if (TransactionLocalCacheStore.this.backendCacheStore.replace(backendEntry, computedLocal)) {
                            isConflict = false;
                        }
                    }
                    finally {
                        if (isConflict) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("maybe another Thread Updated newly version. so so markInvalid CacheEntry:" + String.valueOf(key) + ", mappingFunction:" + String.valueOf(mappingFunction));
                            }
                            try {
                                TransactionLocalCacheStore.this.backendCacheStore.remove(key);
                            }
                            catch (RuntimeException e) {
                                logger.error("cache may be illegal state... cause:" + String.valueOf(e), (Throwable)e);
                            }
                        }
                    }
                }
            });
            return null;
        }

        @Override
        public CacheEntry compute(final Object key, final BiFunction<Object, CacheEntry, CacheEntry> remappingFunction) {
            CacheEntry localEntry = this.getStore().get(key);
            if (localEntry == null) {
                CacheEntry backendEntry = this.backendCacheStore.compute(key, remappingFunction);
                if (backendEntry != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("put local cache!key=" + String.valueOf(backendEntry.getKey()) + ",version=" + backendEntry.getVersion() + ",value=" + String.valueOf(backendEntry.getValue()));
                    }
                    this.getStore().put(backendEntry, false);
                }
                return backendEntry;
            }
            final CacheEntry backendEntry = this.backendCacheStore.get(key);
            final CacheEntry computedLocal = this.getStore().compute(key, (k, v) -> {
                CacheEntry realCe = v instanceof RemovedCacheEntry ? null : v;
                CacheEntry computedCe = (CacheEntry)remappingFunction.apply(k, realCe);
                if (computedCe == null) {
                    if (v instanceof RemovedCacheEntry) {
                        return v;
                    }
                    return new RemovedCacheEntry((CacheEntry)v);
                }
                return computedCe;
            });
            if (Objects.equals(computedLocal, backendEntry)) {
                return computedLocal;
            }
            this.addOrRunTransactionListener(new TransactionListener(){

                @Override
                public void afterRollback(Transaction t) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void afterCommit(Transaction t) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("cas shared cache!key=" + String.valueOf(key) + ",remappingFunction=" + String.valueOf(remappingFunction));
                    }
                    boolean isConflict = true;
                    try {
                        if (computedLocal instanceof RemovedCacheEntry) {
                            TransactionLocalCacheStore.this.backendCacheStore.remove(key);
                            isConflict = false;
                        } else if (backendEntry != null && TransactionLocalCacheStore.this.backendCacheStore.replace(backendEntry, computedLocal)) {
                            isConflict = false;
                        }
                    }
                    finally {
                        if (isConflict) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("maybe another Thread Updated newly version. so so markInvalid CacheEntry:" + String.valueOf(key) + ", remappingFunction:" + String.valueOf(remappingFunction));
                            }
                            try {
                                TransactionLocalCacheStore.this.backendCacheStore.remove(key);
                            }
                            catch (RuntimeException e) {
                                logger.error("cache may be illegal state... cause:" + String.valueOf(e), (Throwable)e);
                            }
                        }
                    }
                }
            });
            return computedLocal;
        }

        @Override
        public CacheEntry putIfAbsent(final CacheEntry entry) {
            CacheEntry target = this.getStore().get(entry.getKey());
            if (target != null && !(target instanceof RemovedCacheEntry)) {
                return target;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("put local cache!key=" + String.valueOf(entry.getKey()) + ",version=" + entry.getVersion() + ",value=" + String.valueOf(entry.getValue()));
            }
            this.getStore().put(entry, false);
            final CacheEntry backendPrevious = this.backendCacheStore.get(entry.getKey());
            if (backendPrevious != null && !(target instanceof RemovedCacheEntry)) {
                return backendPrevious;
            }
            this.addOrRunTransactionListener(new TransactionListener(){

                @Override
                public void afterRollback(Transaction t) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void afterCommit(Transaction t) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("put shared cache!key=" + String.valueOf(entry.getKey()) + ",version=" + entry.getVersion() + ",value=" + String.valueOf(entry.getValue()));
                    }
                    boolean isConflict = true;
                    try {
                        if (backendPrevious == null) {
                            CacheEntry sheredPrevious = TransactionLocalCacheStore.this.backendCacheStore.putIfAbsent(entry);
                            if (sheredPrevious == null) {
                                isConflict = false;
                            } else if (logger.isDebugEnabled()) {
                                logger.debug("maybe another Thread Updated newly version:" + sheredPrevious.getVersion() + ".  so markInvalid CacheEntry:" + String.valueOf(entry.getKey()) + " version:" + entry.getVersion());
                            }
                        } else if (TransactionLocalCacheStore.this.backendCacheStore.replace(backendPrevious, entry)) {
                            isConflict = false;
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("maybe another Thread Updated newly version. expected previous version is " + backendPrevious.getVersion() + " but no match.  so markInvalid CacheEntry:" + String.valueOf(entry.getKey()) + " version:" + entry.getVersion());
                        }
                    }
                    finally {
                        if (isConflict) {
                            try {
                                TransactionLocalCacheStore.this.backendCacheStore.remove(entry.getKey());
                            }
                            catch (RuntimeException e) {
                                logger.error("cache may be illegal state... cause:" + String.valueOf(e), (Throwable)e);
                            }
                        }
                    }
                }
            });
            return null;
        }

        @Override
        public CacheEntry get(Object key) {
            CacheStore localCache = this.getStore();
            CacheEntry entry = localCache.get(key);
            if (entry != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("hit local cache!key=" + String.valueOf(entry.getKey()) + ",version=" + entry.getVersion() + ",value=" + String.valueOf(entry.getValue()));
                }
                return entry;
            }
            if (this.backendCacheStore == null) {
                return null;
            }
            CacheEntry sharedEntry = this.backendCacheStore.get(key);
            if (sharedEntry != null) {
                localCache.put(sharedEntry, true);
                return sharedEntry;
            }
            return null;
        }

        @Override
        public CacheEntry remove(final Object key) {
            if (logger.isTraceEnabled()) {
                logger.trace("remove local cache!key=" + String.valueOf(key));
            }
            CacheEntry sharedToRemove = this.backendCacheStore != null ? this.backendCacheStore.get(key) : null;
            CacheStore localCache = this.getStore();
            CacheEntry removed = localCache.remove(key);
            if (sharedToRemove != null) {
                localCache.put(new RemovedCacheEntry(sharedToRemove), true);
            }
            if (this.backendCacheStore == null) {
                return removed;
            }
            Object previous = key != null ? (removed != null ? (removed instanceof RemovedCacheEntry ? null : sharedToRemove) : sharedToRemove) : null;
            this.addOrRunTransactionListener(new TransactionListener(){
                final /* synthetic */ CacheEntry val$previous;
                {
                    this.val$previous = cacheEntry;
                }

                @Override
                public void afterRollback(Transaction t) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void afterCommit(Transaction t) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("remove from shared cache!key=" + String.valueOf(key));
                    }
                    boolean isConflict = true;
                    try {
                        if (this.val$previous != null) {
                            if (!TransactionLocalCacheStore.this.backendCacheStore.remove(this.val$previous)) {
                                boolean isLoop = true;
                                while (isLoop) {
                                    CacheEntry current = TransactionLocalCacheStore.this.backendCacheStore.get(key);
                                    if (current == null) {
                                        if (logger.isDebugEnabled()) {
                                            logger.debug("CacheEntry:" + String.valueOf(key) + " not found. maybe already removed by another thread.");
                                        }
                                        isLoop = false;
                                        isConflict = false;
                                        continue;
                                    }
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("maybe another Thread Updated newly version:" + current.getVersion() + ". so markInvalid CacheEntry:" + String.valueOf(this.val$previous.getKey()) + " version:" + this.val$previous.getVersion());
                                    }
                                    isLoop = false;
                                }
                            } else {
                                isConflict = false;
                            }
                        } else {
                            TransactionLocalCacheStore.this.backendCacheStore.remove(key);
                            isConflict = false;
                        }
                    }
                    finally {
                        if (isConflict) {
                            try {
                                TransactionLocalCacheStore.this.backendCacheStore.remove(this.val$previous.getKey());
                            }
                            catch (RuntimeException e) {
                                logger.error("cache may be illegal state... cause:" + String.valueOf(e), (Throwable)e);
                            }
                        }
                    }
                }
            });
            return sharedToRemove;
        }

        @Override
        public boolean remove(CacheEntry entry) {
            CacheEntry compareTarget = this.get(entry.getKey());
            if (compareTarget == null || !compareTarget.equals(entry)) {
                return false;
            }
            this.remove(entry.getKey());
            return true;
        }

        @Override
        public CacheEntry replace(final CacheEntry entry) {
            CacheEntry target = this.getStore().get(entry.getKey());
            if (target instanceof RemovedCacheEntry) {
                return null;
            }
            CacheEntry backendPrevious = this.backendCacheStore.get(entry.getKey());
            if (backendPrevious == null) {
                return null;
            }
            if (target == null) {
                target = backendPrevious;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("put local cache!key=" + String.valueOf(entry.getKey()) + ",version=" + entry.getVersion() + ",value=" + String.valueOf(entry.getValue()));
            }
            this.getStore().put(entry, false);
            final CacheEntry previous = target;
            this.addOrRunTransactionListener(new TransactionListener(){

                @Override
                public void afterRollback(Transaction t) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void afterCommit(Transaction t) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("put shared cache!key=" + String.valueOf(entry.getKey()) + ",version=" + entry.getVersion() + ",value=" + String.valueOf(entry.getValue()));
                    }
                    boolean isConflict = true;
                    try {
                        if (previous != null) {
                            if (TransactionLocalCacheStore.this.backendCacheStore.replace(previous, entry)) {
                                isConflict = false;
                            } else {
                                boolean isLoop = true;
                                while (isLoop) {
                                    CacheEntry current = TransactionLocalCacheStore.this.backendCacheStore.get(entry.getKey());
                                    if (current == null) {
                                        if (logger.isDebugEnabled()) {
                                            logger.debug("CacheEntry:" + String.valueOf(entry.getKey()) + " not found. maybe removed. so markInvalid.");
                                        }
                                        isLoop = false;
                                        continue;
                                    }
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("maybe another Thread Updated newly version:" + current.getVersion() + ".  so markInvalid CacheEntry:" + String.valueOf(entry.getKey()) + " version:" + entry.getVersion());
                                    }
                                    isLoop = false;
                                }
                            }
                        }
                    }
                    finally {
                        if (isConflict) {
                            try {
                                TransactionLocalCacheStore.this.backendCacheStore.remove(entry.getKey());
                            }
                            catch (RuntimeException e) {
                                logger.error("cache may be illegal state... cause:" + String.valueOf(e), (Throwable)e);
                            }
                        }
                    }
                }
            });
            return target;
        }

        @Override
        public boolean replace(CacheEntry oldEntry, final CacheEntry newEntry) {
            if (!oldEntry.getKey().equals(newEntry.getKey())) {
                throw new IllegalArgumentException("new key must equals old key.");
            }
            CacheEntry target = this.getStore().get(oldEntry.getKey());
            if (target instanceof RemovedCacheEntry || !oldEntry.equals(target)) {
                return false;
            }
            if (target == null) {
                target = this.backendCacheStore.get(newEntry.getKey());
            }
            if (target == null || !oldEntry.equals(target)) {
                return false;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("put local cache!key=" + String.valueOf(newEntry.getKey()) + ",version=" + newEntry.getVersion() + ",value=" + String.valueOf(newEntry.getValue()));
            }
            this.getStore().put(newEntry, false);
            final CacheEntry previous = target;
            this.addOrRunTransactionListener(new TransactionListener(){

                @Override
                public void afterRollback(Transaction t) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void afterCommit(Transaction t) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("put shared cache!key=" + String.valueOf(newEntry.getKey()) + ",version=" + newEntry.getVersion() + ",value=" + String.valueOf(newEntry.getValue()));
                    }
                    boolean isConflict = true;
                    try {
                        if (previous != null) {
                            if (TransactionLocalCacheStore.this.backendCacheStore.replace(previous, newEntry)) {
                                isConflict = false;
                            } else {
                                boolean isLoop = true;
                                while (isLoop) {
                                    CacheEntry current = TransactionLocalCacheStore.this.backendCacheStore.get(newEntry.getKey());
                                    if (current == null) {
                                        if (logger.isDebugEnabled()) {
                                            logger.debug("CacheEntry:" + String.valueOf(newEntry.getKey()) + " not found. maybe removed. so markInvalid.");
                                        }
                                        isLoop = false;
                                        continue;
                                    }
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("maybe another Thread Updated newly version:" + current.getVersion() + ". so markInvalid CacheEntry:" + String.valueOf(newEntry.getKey()) + " version:" + newEntry.getVersion());
                                    }
                                    isLoop = false;
                                }
                            }
                        }
                    }
                    finally {
                        if (isConflict) {
                            try {
                                TransactionLocalCacheStore.this.backendCacheStore.remove(newEntry.getKey());
                            }
                            catch (RuntimeException e) {
                                logger.error("cache may be illegal state... cause:" + String.valueOf(e), (Throwable)e);
                            }
                        }
                    }
                }
            });
            return true;
        }

        @Override
        public void removeAll() {
            for (Object key : this.keySet()) {
                this.remove(key);
            }
        }

        @Override
        public List<Object> keySet() {
            ArrayList<Object> ret = new ArrayList<Object>();
            if (this.backendCacheStore != null) {
                ret.addAll(this.backendCacheStore.keySet());
            }
            CacheStore localStore = this.getStore();
            List<Object> localKeySet = localStore.keySet();
            for (Object k : localKeySet) {
                CacheEntry ce = localStore.get(k);
                if (ce == null || ret.contains(k)) continue;
                ret.add(k);
            }
            return ret;
        }

        @Override
        public CacheEntry getByIndex(int indexKey, Object indexValue) {
            CacheStore localCache = this.getStore();
            List<CacheEntry> entries = localCache.getListByIndex(indexKey, indexValue);
            if (entries != null && entries.size() > 0) {
                CacheEntry entry = null;
                Iterator<CacheEntry> iterator = entries.iterator();
                while (iterator.hasNext()) {
                    CacheEntry ent;
                    entry = ent = iterator.next();
                    if (ent instanceof RemovedCacheEntry) continue;
                    break;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("hit local cache!indexVal(" + indexKey + ")=" + String.valueOf(indexValue) + ",key=" + String.valueOf(entry.getKey()) + ",version=" + entry.getVersion() + ",value=" + String.valueOf(entry.getValue()) + ",is Remove=" + (entry instanceof RemovedCacheEntry));
                }
                return entry;
            }
            if (this.backendCacheStore == null) {
                return null;
            }
            CacheEntry sharedEntry = this.backendCacheStore.getByIndex(indexKey, indexValue);
            if (sharedEntry != null) {
                CacheEntry localEntry = localCache.get(sharedEntry.getKey());
                if (localEntry != null && (localEntry instanceof RemovedCacheEntry || !indexValue.equals(localEntry.getIndexValue(indexKey)))) {
                    return null;
                }
                localCache.put(sharedEntry, true);
                return sharedEntry;
            }
            return null;
        }

        @Override
        public List<CacheEntry> getListByIndex(int indexKey, Object indexValue) {
            CacheStore localCache = this.getStore();
            List<CacheEntry> localList = localCache.getListByIndex(indexKey, indexValue);
            if (this.backendCacheStore == null) {
                return localList;
            }
            ArrayList<CacheEntry> ret = new ArrayList<CacheEntry>();
            List<CacheEntry> sharedList = this.backendCacheStore.getListByIndex(indexKey, indexValue);
            for (CacheEntry sce : sharedList) {
                CacheEntry lce = this.get(sce.getKey());
                if (lce == null || lce instanceof RemovedCacheEntry || !indexValue.equals(lce.getIndexValue(indexKey))) continue;
                ret.add(lce);
            }
            for (CacheEntry lce : localList) {
                if (ret.contains(lce)) continue;
                ret.add(lce);
            }
            return ret;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public void addCacheEventListenner(CacheEventListener listener) {
            if (this.backendCacheStore != null) {
                this.backendCacheStore.addCacheEventListenner(listener);
            }
        }

        @Override
        public void removeCacheEventListenner(CacheEventListener listener) {
            if (this.backendCacheStore != null) {
                this.backendCacheStore.removeCacheEventListenner(listener);
            }
        }

        @Override
        public List<CacheEventListener> getListeners() {
            if (this.backendCacheStore == null) {
                return Collections.emptyList();
            }
            return this.backendCacheStore.getListeners();
        }

        private void addOrRunTransactionListener(TransactionListener listener) {
            Transaction t = ManagerLocator.getInstance().getManager(TransactionManager.class).currentTransaction();
            if (t != null && t.getStatus() == TransactionStatus.ACTIVE) {
                t.addTransactionListener(listener);
            } else {
                listener.afterCommit(null);
            }
        }

        @Override
        public CacheStoreFactory getFactory() {
            return TransactionLocalCacheStoreFactory.this;
        }

        @Override
        public List<CacheEntry> removeByIndex(final int indexKey, final Object indexValue) {
            List<CacheEntry> list = this.getListByIndex(indexKey, indexValue);
            if (list != null) {
                CacheStore localCache = this.getStore();
                for (CacheEntry e : list) {
                    localCache.put(new RemovedCacheEntry(e), false);
                }
            }
            this.addOrRunTransactionListener(new TransactionListener(){

                @Override
                public void afterRollback(Transaction t) {
                }

                @Override
                public void afterCommit(Transaction t) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("removeByIndex shared cache!indexKey=" + indexKey + ", indexValue=" + String.valueOf(indexValue));
                    }
                    TransactionLocalCacheStore.this.backendCacheStore.removeByIndex(indexKey, indexValue);
                }
            });
            return list;
        }

        @Override
        public int getSize() {
            return this.backendCacheStore.getSize();
        }

        @Override
        public String trace() {
            StringBuilder builder = new StringBuilder();
            builder.append("-----------------------------------");
            builder.append("\nCacheStore Info");
            builder.append("\nCacheStore:" + String.valueOf(this));
            builder.append("\n\tnamespace:" + this.namespace);
            builder.append("\n\tindexCount:" + TransactionLocalCacheStoreFactory.this.getIndexCount());
            CacheStore localCache = this.getStore();
            builder.append("\n\t===================================");
            builder.append("\n\tlocalCache:" + String.valueOf(localCache));
            builder.append("\n" + localCache.trace());
            builder.append("\n\t===================================");
            builder.append("\n\tbackendCacheStore:" + String.valueOf(this.backendCacheStore));
            builder.append("\n" + this.backendCacheStore.trace());
            builder.append("\n-----------------------------------");
            return builder.toString();
        }

        @Override
        public void destroy() {
            if (this.backendCacheStore != null) {
                this.backendCacheStore.destroy();
            }
        }
    }

    public static final class RemovedCacheEntry
    extends CacheEntry {
        private static final long serialVersionUID = 8582988909194271518L;

        public RemovedCacheEntry(Object key, Object[] indexValues) {
            super(key, (Object)null, Long.MIN_VALUE, indexValues);
        }

        public RemovedCacheEntry(CacheEntry actual) {
            super(actual.getKey(), (Object)null, actual.getVersion() + 1L, actual.getIndexValues());
        }
    }
}

