/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cluster.channel.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.iplass.mtp.impl.async.AsyncTaskService;
import org.iplass.mtp.impl.cluster.ClusterService;
import org.iplass.mtp.impl.cluster.Message;
import org.iplass.mtp.impl.cluster.channel.MessageChannel;
import org.iplass.mtp.impl.cluster.channel.MessageReceiver;
import org.iplass.mtp.impl.cluster.channel.http.SendMessageTask;
import org.iplass.mtp.impl.core.config.ServerEnv;
import org.iplass.mtp.impl.http.HttpClientConfig;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceInitListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessageChannel
implements MessageChannel,
ServiceInitListener<ClusterService> {
    private static Logger logger = LoggerFactory.getLogger(HttpMessageChannel.class);
    public static final String PORT_DEF_SYSTEM_PROP_NAME = "mtp.cluster.http.myportno";
    public static final String SERVER_NAME_DEF_SYSTEM_PROP_NAME = "mtp.cluster.http.myservername";
    public static final String INTERFACE_NAME_DEF_SYSTEM_PROP_NAME = "mtp.cluster.http.myinterfacename";
    public static final String ASYNC_TASK_SERVICE_NAME = "AsyncTaskServiceForHttpMessageChannel";
    public static final String CERT_KEY_NAME = "certKey";
    public static final String EVENT_NAME_NAME = "en";
    private List<String> serverUrl;
    private String certKey;
    private MessageReceiver messageHandler;
    private Integer connectionTimeout = HttpClientConfig.DEFAULT_CONNECTION_TIMEOUT;
    private Integer soTimeout = HttpClientConfig.DEFAULT_SO_TIMEOUT;
    private String proxyHost;
    private Integer proxyPort;
    private Integer poolingMaxTotal = HttpClientConfig.DEFAULT_POOLING_MAX_TOTAL;
    private Integer poolingDefaultMaxPerRoute = HttpClientConfig.DEFAULT_POOLING_DEFAULT_MAX_PER_ROUTE;
    private Integer poolingTimeToLive;
    private Integer retryCount = 3;
    private Integer retryDelay = 10000;
    private HttpClientConfig httpClientConfig;
    private Timer timer = new Timer("httpMessageChannelRetryTimer", true);
    private AsyncTaskService asyncTaskService;
    private Charset contentCharset = StandardCharsets.UTF_8;

    HttpClient getHttpClient() {
        return this.httpClientConfig.getInstance();
    }

    public Integer getPoolingTimeToLive() {
        return this.poolingTimeToLive;
    }

    public void setPoolingTimeToLive(Integer poolingTimeToLive) {
        this.poolingTimeToLive = poolingTimeToLive;
    }

    public Integer getPoolingMaxTotal() {
        return this.poolingMaxTotal;
    }

    public void setPoolingMaxTotal(Integer poolingMaxTotal) {
        this.poolingMaxTotal = poolingMaxTotal;
    }

    public Integer getPoolingDefaultMaxPerRoute() {
        return this.poolingDefaultMaxPerRoute;
    }

    public void setPoolingDefaultMaxPerRoute(Integer poolingDefaultMaxPerRoute) {
        this.poolingDefaultMaxPerRoute = poolingDefaultMaxPerRoute;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    public Integer getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(Integer retryDelay) {
        this.retryDelay = retryDelay;
    }

    public List<String> getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(List<String> serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getCertKey() {
        return this.certKey;
    }

    public void setCertKey(String certKey) {
        this.certKey = certKey;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(Integer soTimeout) {
        this.soTimeout = soTimeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Override
    public void setMessageReceiver(MessageReceiver messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void doReceiveMessage(Message msg, String certKeyFromOther) {
        if (this.certKey != null && !this.certKey.equals(certKeyFromOther)) {
            return;
        }
        this.messageHandler.receiveMessage(msg);
    }

    public MessageReceiver getMessageHandler() {
        return this.messageHandler;
    }

    void doRetry(final SendMessageTask task) {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                HttpMessageChannel.this.asyncTaskService.execute(task);
            }
        }, this.retryDelay.intValue());
    }

    int doSend(Message message, String url) throws IOException {
        HttpPost post = null;
        try {
            post = new HttpPost(url);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            if (this.certKey != null) {
                params.add(new BasicNameValuePair(CERT_KEY_NAME, this.certKey));
            }
            params.add(new BasicNameValuePair(EVENT_NAME_NAME, message.getEventName()));
            if (message.getParam() != null) {
                for (Map.Entry<String, String> e : message.getParam().entrySet()) {
                    params.add(new BasicNameValuePair(e.getKey(), e.getValue()));
                }
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, this.contentCharset));
            return (Integer)this.getHttpClient().execute((ClassicHttpRequest)post, response -> {
                try {
                    Integer n = response.getCode();
                    return n;
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            });
        }
        catch (IOException e) {
            if (post != null) {
                post.abort();
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (post != null) {
                post.abort();
            }
            throw e;
        }
    }

    @Override
    public void sendMessage(Message message) {
        if (this.serverUrl != null && this.serverUrl.size() > 0) {
            for (String url : this.serverUrl) {
                this.asyncTaskService.execute(new SendMessageTask(message, url, this.retryCount, this));
            }
        }
    }

    private List<URI> toURI(List<String> urls) throws URISyntaxException {
        ArrayList<URI> ret = new ArrayList<URI>();
        for (String url : urls) {
            URI u = new URI(url);
            ret.add(u);
        }
        return ret;
    }

    private void addHostNameAndAddress(Set<String> list, InetAddress ia) {
        String hostName = ia.getHostName();
        if (ia.isLoopbackAddress()) {
            list.add("localhost");
            list.add(ia.getHostAddress());
        } else {
            list.add(hostName);
            String address = ia.getHostAddress();
            if (hostName.contains(".") && !address.equals(hostName)) {
                list.add(hostName.substring(0, hostName.indexOf(46)));
            }
            list.add(address);
        }
    }

    private String[] getMyServerNameAndAddress() throws SocketException {
        Enumeration<InetAddress> addresses;
        String defHostName = ServerEnv.getInstance().getProperty(SERVER_NAME_DEF_SYSTEM_PROP_NAME);
        if (defHostName == null) {
            defHostName = ServerEnv.getInstance().getProperty("mtp.server.myservername");
        }
        if (defHostName != null) {
            return new String[]{defHostName};
        }
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        String networkInterfaceName = ServerEnv.getInstance().getProperty(INTERFACE_NAME_DEF_SYSTEM_PROP_NAME);
        if (networkInterfaceName == null) {
            networkInterfaceName = ServerEnv.getInstance().getProperty("mtp.server.myinterfacename");
        }
        NetworkInterface ni = null;
        NetworkInterface loopBack = null;
        if (networkInterfaceName != null) {
            ni = NetworkInterface.getByName(networkInterfaceName);
            if (ni == null) {
                throw new ServiceConfigrationException("networkInterfaceName:" + networkInterfaceName + " not found...");
            }
        } else {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface forCheck = e.nextElement();
                if (forCheck.isLoopback()) {
                    loopBack = forCheck;
                    continue;
                }
                if (!forCheck.isUp()) continue;
                ni = forCheck;
                break;
            }
        }
        if (ni != null) {
            addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                this.addHostNameAndAddress(list, addresses.nextElement());
            }
        }
        if (loopBack != null) {
            addresses = loopBack.getInetAddresses();
            while (addresses.hasMoreElements()) {
                this.addHostNameAndAddress(list, addresses.nextElement());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private int getMyPort() {
        String portStr = ServerEnv.getInstance().getProperty(PORT_DEF_SYSTEM_PROP_NAME);
        if (portStr == null) {
            return -1;
        }
        return Integer.parseInt(portStr);
    }

    @Override
    public void inited(ClusterService service, Config config) {
        this.asyncTaskService = (AsyncTaskService)config.getDependentService(ASYNC_TASK_SERVICE_NAME);
        if (this.serverUrl != null) {
            try {
                ArrayList<String> newServerUrl = new ArrayList<String>();
                List<URI> uriList = this.toURI(this.serverUrl);
                String[] myServerNames = this.getMyServerNameAndAddress();
                int port = this.getMyPort();
                for (int i = 0; i < uriList.size(); ++i) {
                    URI uri = uriList.get(i);
                    boolean isMyHost = false;
                    for (String myName : myServerNames) {
                        if (uri.getHost().equals(myName)) {
                            if (port == -1) {
                                int portCount = 0;
                                for (URI uu : uriList) {
                                    if (!uu.getHost().equals(uri.getHost())) continue;
                                    ++portCount;
                                }
                                if (portCount > 1) {
                                    if (uri.getPort() == port) {
                                        isMyHost = true;
                                    }
                                } else {
                                    isMyHost = true;
                                }
                            } else if (uri.getPort() == port) {
                                isMyHost = true;
                            }
                        }
                        if (isMyHost) break;
                    }
                    if (!isMyHost) {
                        newServerUrl.add(this.serverUrl.get(i));
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(this.serverUrl.get(i) + " is my server(and port) url, so remove notifiy list.");
                }
                this.serverUrl = newServerUrl;
            }
            catch (SocketException | URISyntaxException e) {
                throw new ServiceConfigrationException("clusterservice setting is invalid:" + e.toString(), e);
            }
        }
        if (this.serverUrl != null && this.serverUrl.size() > 0) {
            HttpClientConfig httpClientConfig = new HttpClientConfig();
            httpClientConfig.setConnectionTimeout(this.connectionTimeout);
            httpClientConfig.setSoTimeout(this.soTimeout);
            if (this.proxyHost != null) {
                httpClientConfig.setProxyHost(this.proxyHost);
                httpClientConfig.setProxyPort(this.proxyPort);
            }
            if (this.poolingMaxTotal != null) {
                httpClientConfig.setPoolingMaxTotal(this.poolingMaxTotal);
            }
            if (this.poolingDefaultMaxPerRoute != null) {
                httpClientConfig.setPoolingDefaultMaxPerRoute(this.poolingDefaultMaxPerRoute);
            }
            if (this.poolingTimeToLive != null) {
                httpClientConfig.setPoolingTimeToLive(this.poolingTimeToLive);
            }
            httpClientConfig.inited(service, config);
            this.httpClientConfig = httpClientConfig;
        }
    }

    @Override
    public void destroyed() {
        if (this.httpClientConfig != null) {
            this.httpClientConfig.destroyed();
            this.httpClientConfig = null;
        }
        this.timer.cancel();
    }
}

