/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command;

import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.ExceptionAware;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.interceptor.CommandInterceptor;
import org.iplass.mtp.command.interceptor.CommandInvocation;
import org.iplass.mtp.impl.command.MetaCommand;
import org.iplass.mtp.impl.command.MetaMetaCommand;
import org.iplass.mtp.transaction.TransactionOption;

public class InvocationImpl
implements CommandInvocation {
    public static CommandInterceptor[] NULL_COMMAND_INTERCEPTOR = new CommandInterceptor[0];
    private CommandInterceptor[] commandInterceptors;
    private Command cmd;
    private RequestContext request;
    private int index;
    private TransactionOption transactionOption;
    private String cmdName;

    public InvocationImpl(CommandInterceptor[] commandInterceptors, MetaCommand.CommandRuntime cmdRuntime, RequestContext request) {
        this.commandInterceptors = commandInterceptors != null ? commandInterceptors : NULL_COMMAND_INTERCEPTOR;
        if (cmdRuntime != null) {
            this.cmd = cmdRuntime.getCommand();
            this.transactionOption = cmdRuntime.getTransactionOption();
            this.cmdName = cmdRuntime.name();
        }
        this.request = request;
        this.index = -1;
    }

    public InvocationImpl(CommandInterceptor[] commandInterceptors, MetaMetaCommand.MetaCommandRuntime metaCmd, RequestContext request, TransactionOption transactionOption) {
        this.commandInterceptors = commandInterceptors != null ? commandInterceptors : NULL_COMMAND_INTERCEPTOR;
        if (metaCmd != null) {
            this.cmd = metaCmd.newCommand();
            this.cmdName = metaCmd.getMetaData().getName();
        }
        this.request = request;
        if (transactionOption == null) {
            this.transactionOption = new TransactionOption();
            this.transactionOption.setReadOnly(metaCmd.getMetaData().isReadOnly());
        } else {
            this.transactionOption = transactionOption;
        }
        this.index = -1;
    }

    public InvocationImpl(CommandInterceptor[] commandInterceptors, Command cmd, RequestContext request, TransactionOption transactionOption, String cmdName) {
        this.commandInterceptors = commandInterceptors != null ? commandInterceptors : NULL_COMMAND_INTERCEPTOR;
        this.cmd = cmd;
        this.cmdName = cmdName;
        this.request = request;
        this.transactionOption = transactionOption == null ? new TransactionOption() : transactionOption;
        this.index = -1;
    }

    public TransactionOption getTransactionOption() {
        return this.transactionOption;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String proceedCommand() {
        try {
            if (this.cmd == null) return null;
            ++this.index;
            try {
                if (this.index == this.commandInterceptors.length) {
                    String string = this.cmd.execute(this.request);
                    return string;
                }
                String string = this.commandInterceptors[this.index].intercept(this);
                return string;
            }
            finally {
                --this.index;
            }
        }
        catch (RuntimeException e) {
            if (!(this.cmd instanceof ExceptionAware)) throw e;
            if (this.index != -1) throw e;
            return ((ExceptionAware)((Object)this.cmd)).handleException(e, this.request);
        }
    }

    @Override
    public RequestContext getRequest() {
        return this.request;
    }

    @Override
    public Command getCommand() {
        if (this.cmd != null) {
            return this.cmd;
        }
        return null;
    }

    @Override
    public String getCommandName() {
        return this.cmdName;
    }
}

