/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command;

import jakarta.xml.bind.annotation.XmlSeeAlso;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.definition.config.CommandConfig;
import org.iplass.mtp.command.definition.config.CompositeCommandConfig;
import org.iplass.mtp.command.definition.config.SingleCommandConfig;
import org.iplass.mtp.impl.command.MetaCompositeCommand;
import org.iplass.mtp.impl.command.MetaSingleCommand;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.util.KeyGenerator;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.transaction.Propagation;
import org.iplass.mtp.transaction.TransactionOption;

@XmlSeeAlso(value={MetaSingleCommand.class, MetaCompositeCommand.class})
public abstract class MetaCommand
implements MetaData {
    public static final String CMD_BINDING_NAME = "cmd";
    private static final long serialVersionUID = 3346194032850331694L;
    private String commandConfig;
    private Propagation transactionPropagation = Propagation.REQUIRED;
    private boolean rollbackWhenException = true;
    private boolean throwExceptionIfSetRollbackOnly;

    public boolean isRollbackWhenException() {
        return this.rollbackWhenException;
    }

    public void setRollbackWhenException(boolean rollbackWhenException) {
        this.rollbackWhenException = rollbackWhenException;
    }

    public boolean isThrowExceptionIfSetRollbackOnly() {
        return this.throwExceptionIfSetRollbackOnly;
    }

    public void setThrowExceptionIfSetRollbackOnly(boolean throwExceptionIfSetRollbackOnly) {
        this.throwExceptionIfSetRollbackOnly = throwExceptionIfSetRollbackOnly;
    }

    public Propagation getTransactionPropagation() {
        return this.transactionPropagation;
    }

    public void setTransactionPropagation(Propagation transactionPropagation) {
        this.transactionPropagation = transactionPropagation;
    }

    public String getCommandConfig() {
        return this.commandConfig;
    }

    public void setCommandConfig(String commandConfig) {
        this.commandConfig = commandConfig;
    }

    public static MetaCommand createInstance(CommandConfig definition) {
        if (definition instanceof SingleCommandConfig) {
            return new MetaSingleCommand();
        }
        if (definition instanceof CompositeCommandConfig) {
            return new MetaCompositeCommand();
        }
        return null;
    }

    public abstract void applyConfig(CommandConfig var1);

    public abstract CommandConfig currentConfig();

    protected void fillFrom(CommandConfig definition) {
        this.commandConfig = definition.getInitializeScript();
        this.transactionPropagation = definition.getTransactionPropagation();
        this.rollbackWhenException = definition.isRollbackWhenException();
        this.throwExceptionIfSetRollbackOnly = definition.isThrowExceptionIfSetRollbackOnly();
    }

    protected void fillTo(CommandConfig definition) {
        definition.setInitializeScript(this.commandConfig);
        definition.setTransactionPropagation(this.transactionPropagation);
        definition.setRollbackWhenException(this.rollbackWhenException);
        definition.setThrowExceptionIfSetRollbackOnly(this.throwExceptionIfSetRollbackOnly);
    }

    @Override
    public MetaCommand copy() {
        return ObjectUtil.deepCopy(this);
    }

    public abstract CommandRuntime createRuntime();

    public abstract class CommandRuntime {
        private static final String SCRIPT_PREFIX = "CommandRuntime_commandConfig";
        private Command instance;
        protected Script configScript;

        public CommandRuntime(String identifer) {
            if (this.getMetaData().getCommandConfig() != null) {
                TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
                ScriptEngine ss = tc.getScriptEngine();
                KeyGenerator keyGen = new KeyGenerator();
                this.configScript = ss.createScript(this.getMetaData().getCommandConfig(), "CommandRuntime_commandConfig_" + identifer + "_" + keyGen.generateId());
            }
            this.initImpl(identifer);
            if (!this.newInstancePerRequest()) {
                this.instance = this.newCommand();
            }
        }

        public TransactionOption getTransactionOption() {
            TransactionOption transactionOption = new TransactionOption(MetaCommand.this.getTransactionPropagation());
            transactionOption.setReadOnly(this.readOnly());
            transactionOption.setRollbackWhenException(MetaCommand.this.isRollbackWhenException());
            transactionOption.setThrowExceptionIfSetRollbackOnly(MetaCommand.this.isThrowExceptionIfSetRollbackOnly());
            return transactionOption;
        }

        public final Command getCommand() {
            if (this.instance == null) {
                return this.newCommand();
            }
            return this.instance;
        }

        public abstract MetaCommand getMetaData();

        protected abstract void initImpl(String var1);

        protected abstract Command newCommand();

        public abstract boolean readOnly();

        protected abstract boolean newInstancePerRequest();

        public abstract String name();
    }
}

