/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.CommandConfig;
import org.iplass.mtp.command.annotation.CompositeCommandConfig;
import org.iplass.mtp.impl.command.MetaCommand;
import org.iplass.mtp.impl.command.MetaCompositeCommand;
import org.iplass.mtp.impl.command.MetaSingleCommand;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;

public class MetaCommandFactory {
    public MetaCommandResult toMetaCommand(CommandConfig[] commandDefs, Class<?> annotatedClass) {
        ArrayList<MetaCommandInfo> metaCommandInfos = new ArrayList<MetaCommandInfo>();
        MetaCommand meta = null;
        if (commandDefs.length > 1) {
            MetaCompositeCommand metaComposite = new MetaCompositeCommand();
            MetaCommand[] cmds = new MetaCommand[commandDefs.length];
            for (int i = 0; i < cmds.length; ++i) {
                MetaCommandInfo info = this.toMetaCommand(commandDefs[i], annotatedClass);
                cmds[i] = info.metaCommand;
                metaCommandInfos.add(info);
            }
            metaComposite.setCommands(cmds);
            meta = metaComposite;
        } else if (commandDefs.length == 1) {
            MetaCommandInfo info = this.toMetaCommand(commandDefs[0], annotatedClass);
            meta = info.metaCommand;
            metaCommandInfos.add(info);
        }
        return new MetaCommandResult(metaCommandInfos, meta);
    }

    public MetaCommandResult toMetaCommand(CompositeCommandConfig compositeCommandDef, Class<?> annotatedClass) {
        if (compositeCommandDef.command().length == 0) {
            return null;
        }
        ArrayList<MetaCommandInfo> metaCommandInfos = new ArrayList<MetaCommandInfo>();
        MetaCompositeCommand metaComposite = new MetaCompositeCommand();
        metaComposite.setTransactionPropagation(compositeCommandDef.transactionPropagation());
        metaComposite.setRollbackWhenException(compositeCommandDef.rollbackWhenException());
        metaComposite.setThrowExceptionIfSetRollbackOnly(compositeCommandDef.throwExceptionIfSetRollbackOnly());
        MetaCommand[] cmds = new MetaCommand[compositeCommandDef.command().length];
        for (int i = 0; i < cmds.length; ++i) {
            MetaCommandInfo info = this.toMetaCommand(compositeCommandDef.command()[i], annotatedClass);
            cmds[i] = info.metaCommand;
            metaCommandInfos.add(info);
        }
        metaComposite.setCommands(cmds);
        if (!"##default".equals(compositeCommandDef.rule())) {
            metaComposite.setRule(compositeCommandDef.rule());
        }
        return new MetaCommandResult(metaCommandInfos, metaComposite);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MetaCommandInfo toMetaCommand(CommandConfig commandDef, Class<?> anotatedClass) {
        MetaSingleCommand metaCommand = new MetaSingleCommand();
        Class<Command> cmdClass = null;
        if (commandDef.commandClass() == Command.class) {
            if (anotatedClass == null || !Command.class.isAssignableFrom(anotatedClass)) throw new MetaDataRuntimeException("Anotated class is not Command class, so commandClass must specify:" + String.valueOf(anotatedClass));
            cmdClass = anotatedClass;
        } else {
            cmdClass = commandDef.commandClass();
        }
        metaCommand.setTransactionPropagation(commandDef.transactionPropagation());
        metaCommand.setRollbackWhenException(commandDef.rollbackWhenException());
        metaCommand.setThrowExceptionIfSetRollbackOnly(commandDef.throwExceptionIfSetRollbackOnly());
        CommandClass ano = cmdClass.getAnnotation(CommandClass.class);
        if ("##default".equals(ano.name())) {
            metaCommand.setMetaMetaCommandId("/commandClass/" + cmdClass.getName().replace(".", "/"));
        } else {
            metaCommand.setMetaMetaCommandId("/commandClass/" + ano.name());
        }
        if ("##default".equals(commandDef.value())) return new MetaCommandInfo(metaCommand, cmdClass);
        metaCommand.setCommandConfig(commandDef.value());
        return new MetaCommandInfo(metaCommand, cmdClass);
    }

    public static class MetaCommandInfo {
        public MetaCommand metaCommand;
        public Class<? extends Command> cmdClass;

        public MetaCommandInfo(MetaCommand metaCommand, Class<? extends Command> cmdClass) {
            this.metaCommand = metaCommand;
            this.cmdClass = cmdClass;
        }
    }

    public static class MetaCommandResult {
        public List<MetaCommandInfo> metaCommandInfos;
        public MetaCommand metaCommand;

        public MetaCommandResult(List<MetaCommandInfo> metaCommandInfos, MetaCommand metaCommand) {
            this.metaCommandInfos = metaCommandInfos;
            this.metaCommand = metaCommand;
        }
    }
}

